/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.testsuite.math.integrals;

import org.jquantlib.QL;
import org.jquantlib.math.Ops;
import org.jquantlib.math.functions.Constant;
import org.jquantlib.math.functions.Cube;
import org.jquantlib.math.functions.Fourth;
import org.jquantlib.math.functions.Identity;
import org.jquantlib.math.functions.Square;
import org.jquantlib.math.integrals.TabulatedGaussLegendre;
import org.junit.Assert;
import org.junit.Test;

public class TabulatedGaussLegendreTest {
    public TabulatedGaussLegendreTest() {
        QL.info("::::: " + this.getClass().getSimpleName() + " :::::");
    }

    @Test
    public void testPolynomials() {
        this.checkSingleTabulated(new Constant(1.0), "f(x)=1", 2.0, 1.0E-13);
        this.checkSingleTabulated(new Identity(), "f(x)=x", 0.0, 1.0E-13);
        this.checkSingleTabulated(new Square(), "f(x)=x^2", 0.6666666666666666, 1.0E-13);
        this.checkSingleTabulated(new Cube(), "f(x)=x^3", 0.0, 1.0E-13);
        this.checkSingleTabulated(new Fourth(), "f(x)=x^4", 0.4, 1.0E-13);
    }

    public void checkSingleTabulated(Ops.DoubleOp f, String tag, double expected, double tolerance) {
        int[] order = new int[]{6, 7, 12, 20};
        TabulatedGaussLegendre quad = new TabulatedGaussLegendre();
        for (int element : order) {
            quad.setOrder(element);
            double realised = quad.evaluate(f);
            if (!(Math.abs(realised - expected) > tolerance)) continue;
            Assert.fail((String)(" integrating " + tag + "\n" + "    order " + element + "\n" + "    realised: " + realised + "\n" + "    expected: " + expected));
        }
    }
}

