/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.testsuite.math.integrals;

import org.jquantlib.QL;
import org.jquantlib.math.Constants;
import org.jquantlib.math.Ops;
import org.jquantlib.math.functions.Constant;
import org.jquantlib.math.functions.Cube;
import org.jquantlib.math.functions.Fourth;
import org.jquantlib.math.functions.Identity;
import org.jquantlib.math.functions.Square;
import org.jquantlib.math.integrals.GaussKronrodPatterson;
import org.junit.Assert;
import org.junit.Test;

public class GaussKonrodPattersonIntegratorTest {
    public GaussKonrodPattersonIntegratorTest() {
        QL.info("::::: " + this.getClass().getSimpleName() + " :::::");
    }

    @Test
    public void testPolynomials() {
        this.checkSingleTabulated(new Constant(1.0), "f(x)=1", 2.0, 1.0E-13);
        this.checkSingleTabulated(new Identity(), "f(x)=x", 0.0, 1.0E-13);
        this.checkSingleTabulated(new Square(), "f(x)=x^2", 0.6666666666666666, 1.0E-13);
        this.checkSingleTabulated(new Cube(), "f(x)=x^3", 0.0, 1.0E-13);
        this.checkSingleTabulated(new Fourth(), "f(x)=x^4", 0.4, 1.0E-13);
    }

    private void checkSingleTabulated(Ops.DoubleOp f, String tag, double expected, double tolerance) {
        GaussKronrodPatterson quad = new GaussKronrodPatterson();
        double realised = quad.op(f, -1.0, 1.0);
        if (Math.abs(realised - expected) > tolerance) {
            Assert.fail((String)(" integrating " + tag + "\n" + "    realised: " + realised + "\n" + "    expected: " + expected));
        }
    }

    @Test
    public void testExp() {
        Ops.DoubleOp exp = new Ops.DoubleOp(){

            @Override
            public double op(double x) {
                return Math.exp(x);
            }
        };
        GaussKronrodPatterson quad = new GaussKronrodPatterson(0.0, 1.1 * Constants.QL_EPSILON);
        double realised = quad.op(exp, 0.0, 6.0);
        double expected = Math.exp(6.0) - 1.0;
        double tolerance = 1.0E-10;
        if (Math.abs(realised - expected) > 1.0E-10) {
            Assert.fail((String)("Expected: " + expected + " Realised: " + realised));
        }
    }
}

