/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.testsuite.math.integrals;

import org.jquantlib.QL;
import org.jquantlib.math.distributions.GammaFunction;
import org.junit.Assert;
import org.junit.Test;

public class GammaFunctionTest {
    public GammaFunctionTest() {
        QL.info("::::: " + this.getClass().getSimpleName() + " :::::");
    }

    @Test
    public void testGammaFunction() {
        GammaFunction gfn = new GammaFunction();
        double expected = 0.0;
        double calculated = gfn.logValue(1.0);
        if (Math.abs(calculated) > 1.0E-15) {
            Assert.fail((String)("GammaFunction(1)\n    calculated: " + calculated + "\n" + "    expected:   " + expected));
        }
        for (int i = 2; i < 9000; ++i) {
            expected += Math.log(i);
            calculated = gfn.logValue(i + 1);
            if (!(Math.abs(calculated - expected) / expected > 1.0E-9)) continue;
            Assert.fail((String)("GammaFunction(" + i + ")\n" + "    calculated: " + calculated + "\n" + "    expected:   " + expected + "\n" + "    rel. error: " + Math.abs(calculated - expected) / expected));
        }
    }

    @Test
    public void testKnownValuesAbramStegun() {
        double[][] values = new double[][]{{1.075, -0.0388257395}, {1.225, -0.0922078291}, {1.5, -0.1207822376}, {1.975, -0.010367006}};
        GammaFunction gammaFunction = new GammaFunction();
        for (double[] value : values) {
            double x = value[0];
            double expected = value[1];
            double realised = gammaFunction.logValue(x);
            double tolerance = 1.0E-10;
            if (!(Math.abs(expected - realised) > 1.0E-10)) continue;
            Assert.fail((String)("x: " + x + " expected: " + expected + " realised: " + realised));
        }
    }
}

