/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.testsuite.math.distributions;

import org.jquantlib.QL;
import org.jquantlib.math.distributions.NormalDistribution;
import org.junit.Assert;
import org.junit.Test;

public class NormalDistributionTest {
    public NormalDistributionTest() {
        QL.info("::::: " + this.getClass().getSimpleName() + " :::::");
    }

    @Test
    public void testNormalDistribution() {
        double[][] testvalues = new double[][]{{0.0, 0.398942280401433}, {1.0, 0.241970724519143}, {2.0, 0.053990966513188}, {3.0, 0.004431848411938}, {4.0, 1.338302258E-4}, {5.0, 1.486719515E-6}};
        NormalDistribution normal = new NormalDistribution();
        for (double[] testvalue : testvalues) {
            double tolerance;
            double z = testvalue[0];
            double expected = testvalue[1];
            double computed = normal.op(z);
            double d = tolerance = Math.abs(z) < 3.01 ? 1.0E-15 : 1.0E-10;
            if (expected - computed > tolerance) {
                Assert.fail((String)("expected : " + expected + " but was " + computed));
            }
            if (!(Math.abs(expected - normal.op(-z)) > tolerance)) continue;
            Assert.fail((String)("expected: " + expected + " but was " + normal.op(-z)));
        }
    }
}

