/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.testsuite.math.distributions;

import org.jquantlib.QL;
import org.jquantlib.math.distributions.NonCentralChiSquaredDistribution;
import org.junit.Assert;
import org.junit.Test;

public class NonCentralChiSquaredDistributionTest {
    public NonCentralChiSquaredDistributionTest() {
        QL.info("::::: " + this.getClass().getSimpleName() + " :::::");
    }

    @Test
    public void testPenevRayKovELV() {
        double[][] values;
        for (double[] value : values = new double[][]{{1.0, 3.0, 12.0, 0.958368}, {2.0, 2.0, 6.0, 0.775015}, {4.0, 4.0, 14.0, 0.883645}, {4.0, 16.0, 16.0, 0.352378}, {10.0, 16.0, 12.0, 0.039595}, {3.001, 0.8, 0.67, 0.084415}}) {
            double expected = value[3];
            double df = value[0];
            double ncp = value[1];
            NonCentralChiSquaredDistribution nccsd = new NonCentralChiSquaredDistribution(df, ncp);
            double x = value[2];
            double realised = nccsd.op(x);
            if (!(Math.abs(expected - realised) > 1.0E-6)) continue;
            Assert.fail((String)("Noncentral chi squared failed: df " + df + " ncp " + ncp + " x " + x + " expected " + expected + " realised " + realised));
        }
    }
}

