/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.testsuite.math.distributions;

import org.jquantlib.QL;
import org.jquantlib.math.distributions.MoroInverseCumulativeNormal;
import org.junit.Assert;
import org.junit.Test;

public class MoroInverseCumulativeNormalTest {
    public MoroInverseCumulativeNormalTest() {
        QL.info("::::: " + this.getClass().getSimpleName() + " :::::");
    }

    @Test
    public void testInverseCumulativNormal() {
        double[][] normal_testvalues = new double[][]{{0.01, -2.326347873944969}, {0.1, -1.281551563277035}, {0.2, -0.8416212348979942}, {0.3, -0.5244005119066527}, {0.4, -0.25334710332144356}, {0.5, 0.0}, {0.6, 0.25334710332144356}, {0.7, 0.5244005119066525}, {0.8, 0.8416212348979947}, {0.9, 1.281551563277035}, {0.99, 2.326347873944969}};
        MoroInverseCumulativeNormal icn = new MoroInverseCumulativeNormal();
        for (double[] normalTestvalue : normal_testvalues) {
            double x_position = normalTestvalue[0];
            double tolerance = 0.015;
            double normal_expected = normalTestvalue[1];
            double computed_normal = icn.op(x_position);
            if (!(Math.abs(normal_expected - computed_normal) > 0.015)) continue;
            Assert.fail((String)("x_position " + x_position + " normal_expected: " + normal_expected + " normal_computed: " + computed_normal));
        }
    }
}

