/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.testsuite.math.distributions;

import org.jquantlib.QL;
import org.jquantlib.math.distributions.CumulativePoissonDistribution;
import org.junit.Assert;
import org.junit.Test;

public class CumulativePoissonDistributionTest {
    public CumulativePoissonDistributionTest() {
        QL.info("::::: " + this.getClass().getSimpleName() + " :::::");
    }

    @Test
    public void testCumulativePoissonDistribution() {
        double[] testvalues = new double[]{0.60653065971263, 0.90979598956895, 0.98561232203303, 0.99824837744371, 0.99982788437004, 0.99998583506268, 0.9999989976204, 0.99999993780309, 0.99999999656451, 0.99999999982903, 0.99999999999226, 0.99999999999968, 0.99999999999999, 1.0, 1.0};
        double[] testvalues2 = new double[]{0.00673794699909, 0.040427681994512854, 0.12465201948308113, 0.26502591529736175, 0.4404932850652127, 0.61596065483306, 0.76218346297294, 0.86662832592999, 0.93190636527815, 0.9681719426938, 0.98630473140162, 0.99454690808699, 0.99798114837256, 0.99930201002086, 0.9997737463333305};
        for (double mean = 0.0; mean <= 10.0; mean += 0.5) {
            double logHelper;
            double cumExpected;
            CumulativePoissonDistribution cdf = new CumulativePoissonDistribution(mean);
            int i = 0;
            double cumCalculated = cdf.op(i);
            double error = Math.abs(cumCalculated - (cumExpected = Math.exp(logHelper = -mean)));
            if (error > 1.0E-13) {
                Assert.fail((String)("expected: " + cumExpected + "  calculated: " + cumCalculated + "  error: " + error));
            }
            for (i = 1; i < 25; ++i) {
                cumCalculated = cdf.op(i);
                if (mean == 0.0) {
                    cumExpected = 1.0;
                } else {
                    logHelper = logHelper + Math.log(mean) - Math.log(i);
                    cumExpected += Math.exp(logHelper);
                }
                error = Math.abs(cumCalculated - cumExpected);
                if (!(error > 1.0E-12)) continue;
                Assert.fail((String)("expected: " + cumExpected + "  calculated: " + cumCalculated + "  error: " + error));
            }
        }
    }
}

