/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.testsuite.math;

import java.util.EnumSet;
import java.util.Set;
import org.jquantlib.QL;
import org.jquantlib.math.Closeness;
import org.jquantlib.math.functions.GreaterThanPredicate;
import org.jquantlib.math.functions.Square;
import org.jquantlib.math.matrixutilities.Array;
import org.jquantlib.math.matrixutilities.Matrix;
import org.jquantlib.math.matrixutilities.internal.Address;
import org.jquantlib.testsuite.math.MatrixTest;
import org.junit.Assert;
import org.junit.Test;

public class ArrayTest {
    private final Set<Address.Flags> jFlags;
    private final Set<Address.Flags> fFlags;

    public ArrayTest() {
        QL.info("::::: " + this.getClass().getSimpleName() + " :::::");
        this.jFlags = EnumSet.noneOf(Address.Flags.class);
        this.fFlags = EnumSet.of(Address.Flags.FORTRAN);
    }

    private Array augmented(Array array) {
        int begin = array.begin();
        int end = array.end();
        Array result = new Array(array.size() + 2, array.flags());
        result.set(begin, Math.random());
        int i = begin;
        int j = 1 + begin;
        while (i < end) {
            result.set(j, array.get(i));
            ++i;
            ++j;
        }
        result.set(end + 1, Math.random());
        return result;
    }

    private Array range(Array array) {
        int begin = array.begin();
        int end = array.end();
        return array.range(begin + 1, end - 1);
    }

    public static boolean equals(Array a, Array b) {
        if (a.size() != b.size()) {
            return false;
        }
        int offsetA = a.flags().contains((Object)Address.Flags.FORTRAN) ? 1 : 0;
        int offsetB = b.flags().contains((Object)Address.Flags.FORTRAN) ? 1 : 0;
        for (int i = 0; i < a.size(); ++i) {
            if (a.get(i + offsetA) == b.get(i + offsetB)) continue;
            return false;
        }
        return true;
    }

    @Test
    public void testToString() {
        this.testToString(this.jFlags);
        this.testToString(this.fFlags);
    }

    private void testToString(Set<Address.Flags> flags) {
        Array a = new Array(new double[]{1.0, 2.0, 3.0, 4.0}, flags);
        this.testToString(a);
        this.testToString(this.range(this.augmented(a)));
        this.testToString(this.range(this.augmented(this.range(this.augmented(a)))));
    }

    private void testToString(Array a) {
        String result = a.toString();
        System.out.println(result);
    }

    @Test
    public void toFortran() {
        this.toFortran(this.jFlags);
        this.toFortran(this.fFlags);
    }

    private void toFortran(Set<Address.Flags> flags) {
        Array a = new Array(new double[]{1.0, 2.0, 3.0, 4.0}, flags).toFortran();
        this.toFortran(a);
        this.toFortran(this.range(this.augmented(a)));
        this.toFortran(this.range(this.augmented(this.range(this.augmented(a)))));
    }

    private void toFortran(Array a) {
        Array result = a.toFortran();
        System.out.println(result);
    }

    @Test
    public void toJava() {
        this.toJava(this.jFlags);
        this.toJava(this.fFlags);
    }

    private void toJava(Set<Address.Flags> flags) {
        Array a = new Array(new double[]{1.0, 2.0, 3.0, 4.0}, flags).toJava();
        this.toJava(a);
        this.toJava(this.range(this.augmented(a)));
        this.toJava(this.range(this.augmented(this.range(this.augmented(a)))));
    }

    private void toJava(Array a) {
        Array result = a.toJava();
        System.out.println(result);
    }

    @Test
    public void iterator() {
        this.iterator(this.jFlags, this.jFlags);
        this.iterator(this.jFlags, this.fFlags);
        this.iterator(this.fFlags, this.jFlags);
        this.iterator(this.fFlags, this.fFlags);
    }

    private void iterator(Set<Address.Flags> flagsA, Set<Address.Flags> flagsB) {
        Array aA = new Array(new double[]{1.0, -2.0, -3.0, 5.0, -9.0, -11.0, -12.0}, flagsA);
        Array aB = new Array(new double[]{1.0, -2.0, -3.0, 5.0, -9.0, -11.0, -12.0}, flagsB);
        this.iterator(aA, aB);
        this.iterator(this.range(this.augmented(aA)), this.range(this.augmented(aB)));
        this.iterator(this.range(this.augmented(this.range(this.augmented(aA)))), this.range(this.augmented(this.range(this.augmented(aB)))));
    }

    private void iterator(Array aA, Array aB) {
        int pos = aB.begin();
        for (double d : aA) {
            junit.framework.Assert.assertTrue((String)"iterator failed", (d == aB.get(pos) ? 1 : 0) != 0);
            ++pos;
        }
    }

    @Test
    public void testClone() {
        this.testClone(this.jFlags, this.jFlags);
        this.testClone(this.jFlags, this.fFlags);
        this.testClone(this.fFlags, this.jFlags);
        this.testClone(this.fFlags, this.fFlags);
    }

    private void testClone(Set<Address.Flags> flagsA, Set<Address.Flags> flagsB) {
        Array aA = new Array(new double[]{1.0, 2.0, 3.0, 4.0}, flagsA);
        Array aB = new Array(new double[]{1.0, 2.0, 3.0, 4.0}, flagsB);
        this.testClone(aA, aB);
        this.testClone(this.range(this.augmented(aA)), this.range(this.augmented(aB)));
        this.testClone(this.range(this.augmented(this.range(this.augmented(aA)))), this.range(this.augmented(this.range(this.augmented(aB)))));
    }

    private void testClone(Array aA, Array aB) {
        Array result = aA.clone();
        if (result == aA) {
            Assert.fail((String)"'clone' must return a new instance");
        }
        if (result == aB) {
            Assert.fail((String)"'clone' must return a new instance");
        }
        if (!ArrayTest.equals(result, aB)) {
            Assert.fail((String)"'clone' failed");
        }
    }

    @Test
    public void abs() {
        this.abs(this.jFlags, this.jFlags);
        this.abs(this.jFlags, this.fFlags);
        this.abs(this.fFlags, this.jFlags);
        this.abs(this.fFlags, this.fFlags);
    }

    private void abs(Set<Address.Flags> flagsA, Set<Address.Flags> flagsB) {
        Array aA = new Array(new double[]{1.0, -2.0, -3.0, 5.0, -9.0, -11.0, -12.0}, flagsA);
        Array aB = new Array(new double[]{1.0, 2.0, 3.0, 5.0, 9.0, 11.0, 12.0}, flagsB);
        this.abs(aA, aB);
        this.abs(this.range(this.augmented(aA)), this.range(this.augmented(aB)));
        this.abs(this.range(this.augmented(this.range(this.augmented(aA)))), this.range(this.augmented(this.range(this.augmented(aB)))));
    }

    private void abs(Array aA, Array aB) {
        Array result = aA.abs();
        if (result == aA) {
            Assert.fail((String)"'abs' must return a new instance");
        }
        if (result == aB) {
            Assert.fail((String)"'abs' must return a new instance");
        }
        if (!ArrayTest.equals(result, aB)) {
            Assert.fail((String)"'abs' failed");
        }
    }

    @Test
    public void accumulate() {
        Array aA = new Array(new double[]{1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0});
        this.accumulate(aA);
        this.accumulate(this.range(this.augmented(aA)));
        this.accumulate(this.range(this.augmented(this.range(this.augmented(aA)))));
    }

    private void accumulate(Array aA) {
        if (aA.accumulate() != 45.0) {
            Assert.fail((String)"'accumulate' failed");
        }
        if (aA.accumulate(2, 5, -2.0) != 10.0) {
            Assert.fail((String)"'accumulate' failed");
        }
    }

    @Test
    public void add() {
        this.add(this.jFlags, this.jFlags);
        this.add(this.jFlags, this.fFlags);
        this.add(this.fFlags, this.jFlags);
        this.add(this.fFlags, this.fFlags);
    }

    private void add(Set<Address.Flags> flagsA, Set<Address.Flags> flagsB) {
        Array aA = new Array(new double[]{1.0, 2.0, 3.0, 4.0}, flagsA);
        Array aB = new Array(new double[]{4.0, 3.0, 2.0, 1.0}, flagsB);
        this.add(aA, aB);
        this.add(this.range(this.augmented(aA)), this.range(this.augmented(aB)));
        this.add(this.range(this.augmented(this.range(this.augmented(aA)))), this.range(this.augmented(this.range(this.augmented(aB)))));
    }

    private void add(Array aA, Array aB) {
        Array a = aA.add(aB);
        if (a == aA) {
            Assert.fail((String)"'add' must return a new instance");
        }
        if (a.size() != aA.size()) {
            Assert.fail((String)"'add' failed");
        }
        for (int i = 0; i < a.size(); ++i) {
            if (a.get(i) == 5.0) continue;
            Assert.fail((String)"'add' failed");
        }
    }

    @Test
    public void addAssign() {
        this.addAssign(this.jFlags, this.jFlags);
        this.addAssign(this.jFlags, this.fFlags);
        this.addAssign(this.fFlags, this.jFlags);
        this.addAssign(this.fFlags, this.fFlags);
    }

    private void addAssign(Set<Address.Flags> flagsA, Set<Address.Flags> flagsB) {
        Array aA = new Array(new double[]{1.0, 2.0, 3.0, 4.0}, flagsA);
        Array aB = new Array(new double[]{4.0, 3.0, 2.0, 1.0}, flagsB);
        this.addAssign(aA, aB);
        this.addAssign(this.range(this.augmented(aA)), this.range(this.augmented(aB)));
        this.addAssign(this.range(this.augmented(this.range(this.augmented(aA)))), this.range(this.augmented(this.range(this.augmented(aB)))));
    }

    private void addAssign(Array aA, Array aB) {
        Array clone = aA.clone();
        Array a = clone.addAssign(aB);
        if (a != clone) {
            Assert.fail((String)"addAssign must return <this>");
        }
        int begin = a.begin();
        int end = a.end();
        for (int i = begin; i < end; ++i) {
            if (a.get(i) == 5.0) continue;
            Assert.fail((String)"'addAssign' failed");
        }
    }

    @Test
    public void sub() {
        this.sub(this.jFlags, this.jFlags);
        this.sub(this.jFlags, this.fFlags);
        this.sub(this.fFlags, this.jFlags);
        this.sub(this.fFlags, this.fFlags);
    }

    private void sub(Set<Address.Flags> flagsA, Set<Address.Flags> flagsB) {
        Array aA = new Array(new double[]{9.0, 8.0, 7.0, 6.0}, flagsA);
        Array aB = new Array(new double[]{4.0, 3.0, 2.0, 1.0}, flagsB);
        this.sub(aA, aB);
        this.sub(this.range(this.augmented(aA)), this.range(this.augmented(aB)));
        this.sub(this.range(this.augmented(this.range(this.augmented(aA)))), this.range(this.augmented(this.range(this.augmented(aB)))));
    }

    private void sub(Array aA, Array aB) {
        Array a = aA.sub(aB);
        if (a == aA) {
            Assert.fail((String)"'sub' must return a new instance");
        }
        if (a.size() != aA.size()) {
            Assert.fail((String)"'sub' failed");
        }
        for (int i = 0; i < a.size(); ++i) {
            if (a.get(i) == 5.0) continue;
            Assert.fail((String)"'sub' failed");
        }
    }

    @Test
    public void subAssign() {
        this.subAssign(this.jFlags, this.jFlags);
        this.subAssign(this.jFlags, this.fFlags);
        this.subAssign(this.fFlags, this.jFlags);
        this.subAssign(this.fFlags, this.fFlags);
    }

    private void subAssign(Set<Address.Flags> flagsA, Set<Address.Flags> flagsB) {
        Array aA = new Array(new double[]{9.0, 8.0, 7.0, 6.0}, flagsA);
        Array aB = new Array(new double[]{4.0, 3.0, 2.0, 1.0}, flagsB);
        this.subAssign(aA, aB);
        this.subAssign(this.range(this.augmented(aA)), this.range(this.augmented(aB)));
        this.subAssign(this.range(this.augmented(this.range(this.augmented(aA)))), this.range(this.augmented(this.range(this.augmented(aB)))));
    }

    private void subAssign(Array aA, Array aB) {
        Array clone = aA.clone();
        Array a = clone.subAssign(aB);
        if (a != clone) {
            Assert.fail((String)"subAssign must return <this>");
        }
        if (a.size() != aA.size()) {
            Assert.fail((String)"'subAssign' failed");
        }
        int begin = a.begin();
        int end = a.end();
        for (int i = begin; i < end; ++i) {
            if (a.get(i) == 5.0) continue;
            Assert.fail((String)"'subAssign' failed");
        }
    }

    @Test
    public void mul() {
        this.mul(this.jFlags, this.jFlags);
        this.mul(this.jFlags, this.fFlags);
        this.mul(this.fFlags, this.jFlags);
        this.mul(this.fFlags, this.fFlags);
    }

    private void mul(Set<Address.Flags> flagsA, Set<Address.Flags> flagsB) {
        Array aA = new Array(new double[]{200.0, 100.0, 250.0, 500.0}, flagsA);
        Array aB = new Array(new double[]{5.0, 10.0, 4.0, 2.0}, flagsB);
        this.mul(aA, aB);
        this.mul(this.range(this.augmented(aA)), this.range(this.augmented(aB)));
        this.mul(this.range(this.augmented(this.range(this.augmented(aA)))), this.range(this.augmented(this.range(this.augmented(aB)))));
    }

    private void mul(Array aA, Array aB) {
        Array clone = aA.clone();
        Array a1 = clone.mul(aB);
        if (a1 == clone) {
            Assert.fail((String)"'mul' must return a new instance");
        }
        if (a1.size() != aA.size()) {
            Assert.fail((String)"'mul' failed");
        }
        for (int i = a1.begin(); i < a1.end(); ++i) {
            if (a1.get(i) == 1000.0) continue;
            Assert.fail((String)"'mul' failed");
        }
        Matrix mB = new Matrix(new double[][]{{1.0, 2.0, 0.0}, {2.0, 1.0, 0.0}, {2.0, 1.0, 1.0}, {1.0, 2.0, 0.0}});
        Array aB2 = new Array(new double[]{1400.0, 1750.0, 250.0});
        Array a2 = clone.mul(mB);
        if (a2 == clone) {
            Assert.fail((String)"'mul' must return a new instance");
        }
        if (a2.size() != mB.cols()) {
            Assert.fail((String)"'mul' failed");
        }
        for (int i = a2.begin(); i < a2.end(); ++i) {
            double elem = aB2.get(i);
            if (a2.get(i) == elem) continue;
            Assert.fail((String)"'mul' failed");
        }
    }

    @Test
    public void mulAssign() {
        this.mulAssign(this.jFlags, this.jFlags);
        this.mulAssign(this.jFlags, this.fFlags);
        this.mulAssign(this.fFlags, this.jFlags);
        this.mulAssign(this.fFlags, this.fFlags);
    }

    private void mulAssign(Set<Address.Flags> flagsA, Set<Address.Flags> flagsB) {
        Array aA = new Array(new double[]{200.0, 100.0, 250.0, 500.0}, flagsA);
        Array aB = new Array(new double[]{5.0, 10.0, 4.0, 2.0}, flagsB);
        this.mulAssign(aA, aB);
        this.mulAssign(this.range(this.augmented(aA)), this.range(this.augmented(aB)));
        this.mulAssign(this.range(this.augmented(this.range(this.augmented(aA)))), this.range(this.augmented(this.range(this.augmented(aB)))));
    }

    private void mulAssign(Array aA, Array aB) {
        Array clone = aA.clone();
        Array a = clone.mulAssign(aB);
        if (a != clone) {
            Assert.fail((String)"mulAssign must return <this>");
        }
        if (a.size() != aA.size()) {
            Assert.fail((String)"'mulAssign' failed");
        }
        int begin = a.begin();
        int end = a.end();
        for (int i = begin; i < end; ++i) {
            if (a.get(i) == 1000.0) continue;
            Assert.fail((String)"'mulAssign' failed");
        }
    }

    @Test
    public void div() {
        this.div(this.jFlags, this.jFlags);
        this.div(this.jFlags, this.fFlags);
        this.div(this.fFlags, this.jFlags);
        this.div(this.fFlags, this.fFlags);
    }

    private void div(Set<Address.Flags> flagsA, Set<Address.Flags> flagsB) {
        Array aA = new Array(new double[]{20.0, 18.0, 16.0, 14.0}, flagsA);
        Array aB = new Array(new double[]{10.0, 9.0, 8.0, 7.0}, flagsB);
        this.div(aA, aB);
        this.div(this.range(this.augmented(aA)), this.range(this.augmented(aB)));
    }

    private void div(Array aA, Array aB) {
        Array clone = aA.clone();
        Array a = clone.div(aB);
        if (a == clone) {
            Assert.fail((String)"'div' must return a new instance");
        }
        if (a.size() != aA.size()) {
            Assert.fail((String)"'div' failed");
        }
        for (int i = 0; i < a.size(); ++i) {
            if (a.get(i) == 2.0) continue;
            Assert.fail((String)"'div' failed");
        }
    }

    @Test
    public void divAssign() {
        this.divAssign(this.jFlags, this.jFlags);
        this.divAssign(this.jFlags, this.fFlags);
        this.divAssign(this.fFlags, this.jFlags);
        this.divAssign(this.fFlags, this.fFlags);
    }

    private void divAssign(Set<Address.Flags> flagsA, Set<Address.Flags> flagsB) {
        Array aA = new Array(new double[]{20.0, 18.0, 16.0, 14.0}, flagsA);
        Array aB = new Array(new double[]{10.0, 9.0, 8.0, 7.0}, flagsB);
        this.divAssign(aA, aB);
        this.divAssign(this.range(this.augmented(aA)), this.range(this.augmented(aB)));
        this.divAssign(this.range(this.augmented(this.range(this.augmented(aA)))), this.range(this.augmented(this.range(this.augmented(aB)))));
    }

    private void divAssign(Array aA, Array aB) {
        Array clone = aA.clone();
        Array a = clone.divAssign(aB);
        if (a != clone) {
            Assert.fail((String)"divAssign must return <this>");
        }
        if (a.size() != aA.size()) {
            Assert.fail((String)"'divAssign' failed");
        }
        int begin = a.begin();
        int end = a.end();
        for (int i = begin; i < end; ++i) {
            if (Closeness.isClose(a.get(i), 2.0)) continue;
            Assert.fail((String)"'divAssign' failed");
        }
    }

    @Test
    public void dotProduct() {
        this.dotProduct(this.jFlags, this.jFlags);
        this.dotProduct(this.jFlags, this.fFlags);
        this.dotProduct(this.fFlags, this.jFlags);
        this.dotProduct(this.fFlags, this.fFlags);
    }

    private void dotProduct(Set<Address.Flags> flagsA, Set<Address.Flags> flagsB) {
        Array aA = new Array(new double[]{2.0, 1.0, -2.0, 3.0}, flagsA);
        Array aB = new Array(new double[]{3.0, 4.0, 5.0, 1.0}, flagsB);
        this.dotProduct(aA, aB);
        this.dotProduct(this.range(this.augmented(aA)), this.range(this.augmented(aB)));
        this.dotProduct(this.range(this.augmented(this.range(this.augmented(aA)))), this.range(this.augmented(this.range(this.augmented(aB)))));
    }

    private void dotProduct(Array aA, Array aB) {
        if (aA.dotProduct(aB) != 3.0) {
            Assert.fail((String)"'dotProduct' failed");
        }
    }

    @Test
    public void innerProduct() {
        this.dotProduct();
    }

    @Test
    public void outerProduct() {
        this.outerProduct(this.jFlags, this.jFlags);
        this.outerProduct(this.jFlags, this.fFlags);
        this.outerProduct(this.fFlags, this.jFlags);
        this.outerProduct(this.fFlags, this.fFlags);
    }

    private void outerProduct(Set<Address.Flags> flagsA, Set<Address.Flags> flagsB) {
        Array aA = new Array(new double[]{2.0, 1.0, -2.0}, flagsA);
        Array aB = new Array(new double[]{3.0, 4.0, 5.0, 1.0}, flagsB);
        this.outerProduct(aA, aB);
        this.outerProduct(this.range(this.augmented(aA)), this.range(this.augmented(aB)));
        this.outerProduct(this.range(this.augmented(this.range(this.augmented(aA)))), this.range(this.augmented(this.range(this.augmented(aB)))));
    }

    private void outerProduct(Array aA, Array aB) {
        Matrix mC = new Matrix(new double[][]{{6.0, 8.0, 10.0, 2.0}, {3.0, 4.0, 5.0, 1.0}, {-6.0, -8.0, -10.0, -2.0}});
        Matrix m = aA.outerProduct(aB);
        if (!MatrixTest.equals(m, mC)) {
            Assert.fail((String)"'outerProduct' failed");
        }
    }

    @Test
    public void transform() {
        this.transform(this.jFlags, this.jFlags);
        this.transform(this.jFlags, this.fFlags);
        this.transform(this.fFlags, this.jFlags);
        this.transform(this.fFlags, this.fFlags);
    }

    private void transform(Set<Address.Flags> flagsA, Set<Address.Flags> flagsB) {
        Array aA = new Array(new double[]{5.0, 2.0, 3.0, 4.0}, flagsA);
        Array aB = new Array(new double[]{25.0, 4.0, 9.0, 16.0}, flagsB);
        this.transform(aA, aB);
        this.transform(this.range(this.augmented(aA)), this.range(this.augmented(aB)));
        this.transform(this.range(this.augmented(this.range(this.augmented(aA)))), this.range(this.augmented(this.range(this.augmented(aB)))));
    }

    private void transform(Array aA, Array aB) {
        int offset;
        Array tmp1 = aA.clone();
        Array result = tmp1.transform(new Square());
        if (result != tmp1) {
            Assert.fail((String)"'transform' must return this");
        }
        if (!ArrayTest.equals(result, aB)) {
            Assert.fail((String)"'transform' failed");
        }
        Array aC = new Array(new double[]{5.0, 4.0, 9.0, 4.0});
        Array tmp2 = aA.clone();
        result = tmp2.transform(1 + (offset = aA.begin()), 3 + offset, new Square());
        if (result != tmp2) {
            Assert.fail((String)"'transform' must return this");
        }
        if (!ArrayTest.equals(result, aC)) {
            Assert.fail((String)"'transform' failed");
        }
    }

    @Test
    public void lowerBound_Case1() {
        this.lowerBound_Case1(this.jFlags);
        this.lowerBound_Case1(this.fFlags);
    }

    private void lowerBound_Case1(Set<Address.Flags> flags) {
        String MESSAGE = "lowerBound Case 1 failed";
        double[] array = new double[]{0.0, 0.0, 0.0, 0.0, 1.0, 1.0, 1.0, 1.0};
        for (int i = 0; i < 5; ++i) {
            for (int j = 4; j < 7; ++j) {
                double[] tmp = new double[j - i + 1];
                System.arraycopy(array, i, tmp, 0, j - i + 1);
                Array con = new Array(tmp, flags);
                int offset = con.begin();
                int pos = con.lowerBound(1.0);
                if (pos == 4 - i + offset) continue;
                Assert.fail((String)"lowerBound Case 1 failed");
            }
        }
    }

    @Test
    public void lowerBound_Case2() {
        this.lowerBound_Case2(this.jFlags, this.jFlags);
        this.lowerBound_Case2(this.jFlags, this.fFlags);
        this.lowerBound_Case2(this.fFlags, this.jFlags);
        this.lowerBound_Case2(this.fFlags, this.fFlags);
    }

    private void lowerBound_Case2(Set<Address.Flags> flagsA, Set<Address.Flags> flagsB) {
        Array A = new Array(new double[]{1.0, 2.0, 3.0, 3.0, 3.0, 5.0, 8.0}, flagsA);
        Array C = new Array(new double[]{8.0, 5.0, 3.0, 3.0, 3.0, 2.0, 1.0}, flagsB);
        this.lowerBound_Case2(A, C);
        this.lowerBound_Case2(this.range(this.augmented(A)), this.range(this.augmented(C)));
    }

    private void lowerBound_Case2(Array A, Array C) {
        String MESSAGE = "lowerBound Case 2 failed";
        int N = A.size();
        double first = A.first();
        double last = A.last();
        int offsetA = A.begin();
        int pos = A.lowerBound(3.0);
        Assert.assertTrue((String)"lowerBound Case 2 failed", (pos == 2 + offsetA ? 1 : 0) != 0);
        pos = A.lowerBound(first);
        Assert.assertTrue((String)"lowerBound Case 2 failed", (pos == 0 + offsetA ? 1 : 0) != 0);
        pos = A.lowerBound(last);
        Assert.assertTrue((String)"lowerBound Case 2 failed", (pos == N - 1 + offsetA ? 1 : 0) != 0);
        pos = A.lowerBound(4.0);
        Assert.assertTrue((String)"lowerBound Case 2 failed", (pos == 5 + offsetA ? 1 : 0) != 0);
        GreaterThanPredicate gt = new GreaterThanPredicate();
        int offsetC = C.begin();
        pos = C.lowerBound(3.0, gt);
        Assert.assertTrue((String)"lowerBound Case 2 failed", (pos == 2 + offsetC ? 1 : 0) != 0);
        pos = C.lowerBound(first, gt);
        Assert.assertTrue((String)"lowerBound Case 2 failed", (pos == N - 1 + offsetC ? 1 : 0) != 0);
        pos = C.lowerBound(last, gt);
        Assert.assertTrue((String)"lowerBound Case 2 failed", (pos == 0 + offsetC ? 1 : 0) != 0);
        pos = C.lowerBound(4.0, gt);
        Assert.assertTrue((String)"lowerBound Case 2 failed", (pos == 2 + offsetC ? 1 : 0) != 0);
    }

    @Test
    public void upperBound_Case1() {
        this.upperBound_Case1(this.jFlags);
        this.upperBound_Case1(this.fFlags);
    }

    private void upperBound_Case1(Set<Address.Flags> flags) {
        String MESSAGE = "upperBound Case 1 failed";
        double[] array = new double[]{0.0, 0.0, 0.0, 0.0, 1.0, 1.0, 1.0, 1.0};
        for (int i = 0; i < 5; ++i) {
            for (int j = 4; j < 7; ++j) {
                double[] tmp = new double[j - i + 1];
                System.arraycopy(array, i, tmp, 0, j - i + 1);
                Array con = new Array(tmp, flags);
                int offset = con.begin();
                int pos = con.upperBound(0.0);
                if (pos == 4 - i + offset) continue;
                Assert.fail((String)"upperBound Case 1 failed");
            }
        }
    }

    @Test
    public void upperBound_Case2() {
        this.upperBound_Case2(this.jFlags, this.jFlags);
        this.upperBound_Case2(this.jFlags, this.fFlags);
        this.upperBound_Case2(this.fFlags, this.jFlags);
        this.upperBound_Case2(this.fFlags, this.fFlags);
    }

    private void upperBound_Case2(Set<Address.Flags> flagsA, Set<Address.Flags> flagsB) {
        Array A = new Array(new double[]{1.0, 2.0, 3.0, 3.0, 3.0, 5.0, 8.0}, flagsA);
        Array C = new Array(new double[]{8.0, 5.0, 3.0, 3.0, 3.0, 2.0, 1.0}, flagsB);
        this.upperBound_Case2(A, C);
        this.upperBound_Case2(this.range(this.augmented(A)), this.range(this.augmented(C)));
    }

    private void upperBound_Case2(Array A, Array C) {
        String MESSAGE = "upperBound Case 2 failed";
        int N = A.size();
        double first = A.first();
        double last = A.last();
        int offsetA = A.begin();
        int pos = A.upperBound(3.0);
        Assert.assertTrue((String)"upperBound Case 2 failed", (pos == 5 + offsetA ? 1 : 0) != 0);
        pos = A.upperBound(first);
        Assert.assertTrue((String)"upperBound Case 2 failed", (pos == 1 + offsetA ? 1 : 0) != 0);
        pos = A.upperBound(last);
        Assert.assertTrue((String)"upperBound Case 2 failed", (pos == N + offsetA ? 1 : 0) != 0);
        pos = A.upperBound(4.0);
        Assert.assertTrue((String)"upperBound Case 2 failed", (pos == 5 + offsetA ? 1 : 0) != 0);
        GreaterThanPredicate gt = new GreaterThanPredicate();
        int offsetC = C.begin();
        pos = C.upperBound(3.0, gt);
        Assert.assertTrue((String)"upperBound Case 2 failed", (pos == 5 + offsetC ? 1 : 0) != 0);
        pos = C.upperBound(first, gt);
        Assert.assertTrue((String)"upperBound Case 2 failed", (pos == N + offsetC ? 1 : 0) != 0);
        pos = C.upperBound(last, gt);
        Assert.assertTrue((String)"upperBound Case 2 failed", (pos == 1 + offsetC ? 1 : 0) != 0);
        pos = C.upperBound(4.0, gt);
        Assert.assertTrue((String)"upperBound Case 2 failed", (pos == 2 + offsetC ? 1 : 0) != 0);
    }

    @Test
    public void adjacentDifference() {
        this.adjacentDifference(this.jFlags, this.jFlags);
        this.adjacentDifference(this.jFlags, this.fFlags);
        this.adjacentDifference(this.fFlags, this.jFlags);
        this.adjacentDifference(this.fFlags, this.fFlags);
    }

    private void adjacentDifference(Set<Address.Flags> flagsA, Set<Address.Flags> flagsB) {
        Array aA = new Array(new double[]{1.0, 2.0, 3.0, 5.0, 9.0, 11.0, 12.0}, flagsA);
        Array aB = new Array(new double[]{1.0, 1.0, 1.0, 2.0, 4.0, 2.0, 1.0}, flagsB);
        this.adjacentDifference(aA, aB);
        this.adjacentDifference(this.range(this.augmented(aA)), this.range(this.augmented(aB)));
        this.adjacentDifference(this.range(this.augmented(this.range(this.augmented(aA)))), this.range(this.augmented(this.range(this.augmented(aB)))));
    }

    private void adjacentDifference(Array aA, Array aB) {
        Array result = aA.adjacentDifference();
        if (result == aA) {
            Assert.fail((String)"'adjacentDifferences' must return a new instance");
        }
        if (result == aB) {
            Assert.fail((String)"'adjacentDifferences' must return a new instance");
        }
        if (!ArrayTest.equals(result, aB)) {
            Assert.fail((String)"'adjacentDifferences' failed");
        }
    }

    @Test
    public void exp() {
        this.exp(this.jFlags, this.jFlags);
        this.exp(this.jFlags, this.fFlags);
        this.exp(this.fFlags, this.jFlags);
        this.exp(this.fFlags, this.fFlags);
    }

    private void exp(Set<Address.Flags> flagsA, Set<Address.Flags> flagsB) {
        Array aA = new Array(new double[]{1.0, 2.0, 3.0, 4.0}, flagsA);
        Array aB = new Array(new double[]{Math.exp(1.0), Math.exp(2.0), Math.exp(3.0), Math.exp(4.0)}, flagsB);
        this.exp(aA, aB);
        this.exp(this.range(this.augmented(aA)), this.range(this.augmented(aB)));
        this.exp(this.range(this.augmented(this.range(this.augmented(aA)))), this.range(this.augmented(this.range(this.augmented(aB)))));
    }

    private void exp(Array aA, Array aB) {
        Array result = aA.exp();
        if (result == aA) {
            Assert.fail((String)"'exp' must return a new instance");
        }
        if (result == aB) {
            Assert.fail((String)"'exp' must return a new instance");
        }
        if (!ArrayTest.equals(result, aB)) {
            Assert.fail((String)"'exp' failed");
        }
    }

    @Test
    public void fillScalar() {
        this.fillScalar(this.jFlags, this.jFlags);
        this.fillScalar(this.jFlags, this.fFlags);
        this.fillScalar(this.fFlags, this.jFlags);
        this.fillScalar(this.fFlags, this.fFlags);
    }

    private void fillScalar(Set<Address.Flags> flagsA, Set<Address.Flags> flagsB) {
        Array aA = new Array(4, flagsA);
        Array aB = new Array(new double[]{2.0, 2.0, 2.0, 2.0}, flagsB);
        this.fillScalar(aA, aB);
        this.fillScalar(this.range(this.augmented(aA)), this.range(this.augmented(aB)));
        this.fillScalar(this.range(this.augmented(this.range(this.augmented(aA)))), this.range(this.augmented(this.range(this.augmented(aB)))));
    }

    private void fillScalar(Array aA, Array aB) {
        aA.fill(2.0);
        if (!ArrayTest.equals(aA, aB)) {
            Assert.fail((String)"'fill' failed");
        }
    }

    @Test
    public void fillArray() {
        this.fillArray(this.jFlags, this.jFlags);
        this.fillArray(this.jFlags, this.fFlags);
        this.fillArray(this.fFlags, this.jFlags);
        this.fillArray(this.fFlags, this.fFlags);
    }

    private void fillArray(Set<Address.Flags> flagsA, Set<Address.Flags> flagsB) {
        Array aA = new Array(4, flagsA);
        Array aB = new Array(new double[]{2.0, 2.0, 2.0, 2.0}, flagsB);
        this.fillArray(aA, aB);
        this.fillArray(this.range(this.augmented(aA)), this.range(this.augmented(aB)));
        this.fillArray(this.range(this.augmented(this.range(this.augmented(aA)))), this.range(this.augmented(this.range(this.augmented(aB)))));
    }

    private void fillArray(Array aA, Array aB) {
        aA.fill(aB);
        if (!ArrayTest.equals(aA, aB)) {
            Assert.fail((String)"'fill' failed");
        }
    }

    @Test
    public void first() {
        this.first(this.jFlags);
        this.first(this.fFlags);
    }

    private void first(Set<Address.Flags> flags) {
        Array aA = new Array(new double[]{1.0, 2.0, 3.0, 4.0}, flags);
        this.first(aA);
        this.first(this.range(this.augmented(aA)));
        this.first(this.range(this.augmented(this.range(this.augmented(aA)))));
    }

    private void first(Array aA) {
        if (aA.first() != 1.0) {
            Assert.fail((String)"'first' failed");
        }
    }

    @Test
    public void last() {
        this.last(this.jFlags);
        this.last(this.fFlags);
    }

    private void last(Set<Address.Flags> flags) {
        Array aA = new Array(new double[]{1.0, 2.0, 3.0, 4.0}, flags);
        this.last(aA);
        this.last(this.range(this.augmented(aA)));
        this.last(this.range(this.augmented(this.range(this.augmented(aA)))));
    }

    private void last(Array aA) {
        if (aA.last() != 4.0) {
            Assert.fail((String)"'last' failed");
        }
    }

    @Test
    public void log() {
        this.log(this.jFlags, this.jFlags);
        this.log(this.jFlags, this.fFlags);
        this.log(this.fFlags, this.jFlags);
        this.log(this.fFlags, this.fFlags);
    }

    private void log(Set<Address.Flags> flagsA, Set<Address.Flags> flagsB) {
        Array aA = new Array(new double[]{Math.exp(1.0), Math.exp(2.0), Math.exp(3.0), Math.exp(4.0)}, flagsA);
        Array aB = new Array(new double[]{1.0, 2.0, 3.0, 4.0}, flagsB);
        this.log(aA, aB);
        this.log(this.range(this.augmented(aA)), this.range(this.augmented(aB)));
        this.log(this.range(this.augmented(this.range(this.augmented(aA)))), this.range(this.augmented(this.range(this.augmented(aB)))));
    }

    private void log(Array aA, Array aB) {
        Array result = aA.log();
        if (result == aA) {
            Assert.fail((String)"'log' must return a new instance");
        }
        if (result == aB) {
            Assert.fail((String)"'log' must return a new instance");
        }
        if (!ArrayTest.equals(result, aB)) {
            Assert.fail((String)"'log' failed");
        }
    }

    @Test
    public void min() {
        this.min(this.jFlags);
        this.min(this.fFlags);
    }

    private void min(Set<Address.Flags> flags) {
        Array aA = new Array(new double[]{0.0, 1.0, 2.0, -3.0, 4.0, 0.0, -6.0, 7.0, 8.0, 0.0}, flags);
        this.min(aA);
        this.min(this.range(this.augmented(aA)));
        this.min(this.range(this.augmented(this.range(this.augmented(aA)))));
    }

    private void min(Array aA) {
        if (aA.min() != -6.0) {
            Assert.fail((String)"'min' failed");
        }
        if (aA.min(3, 6) != -3.0) {
            Assert.fail((String)"'min' failed");
        }
    }

    @Test
    public void max() {
        this.max(this.jFlags);
        this.max(this.fFlags);
    }

    private void max(Set<Address.Flags> flags) {
        Array aA = new Array(new double[]{0.0, 1.0, 2.0, -3.0, 4.0, 0.0, -6.0, 7.0, 8.0, 0.0}, flags);
        this.max(aA);
        this.max(this.range(this.augmented(aA)));
        this.max(this.range(this.augmented(this.range(this.augmented(aA)))));
    }

    private void max(Array aA) {
        if (aA.max() != 8.0) {
            Assert.fail((String)"'max' failed");
        }
        if (aA.max(2, 6) != 4.0) {
            Assert.fail((String)"'max' failed");
        }
    }

    @Test
    public void sort() {
        this.sort(this.jFlags, this.jFlags);
        this.sort(this.jFlags, this.fFlags);
        this.sort(this.fFlags, this.jFlags);
        this.sort(this.fFlags, this.fFlags);
    }

    private void sort(Set<Address.Flags> flagsA, Set<Address.Flags> flagsB) {
        Array aA = new Array(new double[]{9.0, 8.0, 2.0, 3.0, 1.0, 4.0, 8.0, 9.0}, flagsA);
        Array aB = new Array(new double[]{1.0, 2.0, 3.0, 4.0, 8.0, 8.0, 9.0, 9.0}, flagsB);
        this.sort(aA, aB);
        this.sort(this.range(this.augmented(aA)), this.range(this.augmented(aB)));
        this.sort(this.range(this.augmented(this.range(this.augmented(aA)))), this.range(this.augmented(this.range(this.augmented(aB)))));
    }

    private void sort(Array aA, Array aB) {
        Array result = aA.sort();
        if (result != aA) {
            Assert.fail((String)"'sort' must return <this>");
        }
        if (!ArrayTest.equals(result, aB)) {
            Assert.fail((String)"'sort' failed");
        }
    }

    @Test
    public void sqrt() {
        this.sqrt(this.jFlags, this.jFlags);
        this.sqrt(this.jFlags, this.fFlags);
        this.sqrt(this.fFlags, this.jFlags);
        this.sqrt(this.fFlags, this.fFlags);
    }

    private void sqrt(Set<Address.Flags> flagsA, Set<Address.Flags> flagsB) {
        Array aA = new Array(new double[]{1.0, 4.0, 9.0, 16.0}, flagsA);
        Array aB = new Array(new double[]{1.0, 2.0, 3.0, 4.0}, flagsB);
        this.sqrt(aA, aB);
        this.sqrt(this.range(this.augmented(aA)), this.range(this.augmented(aB)));
        this.sqrt(this.range(this.augmented(this.range(this.augmented(aA)))), this.range(this.augmented(this.range(this.augmented(aB)))));
    }

    private void sqrt(Array aA, Array aB) {
        Array result = aA.sqrt();
        if (result == aA) {
            Assert.fail((String)"'sqrt' must return a new instance");
        }
        if (result == aB) {
            Assert.fail((String)"'sqrt' must return a new instance");
        }
        if (!ArrayTest.equals(result, aB)) {
            Assert.fail((String)"'sqrt' failed");
        }
    }

    @Test
    public void sqr() {
        this.sqr(this.jFlags, this.jFlags);
        this.sqr(this.jFlags, this.fFlags);
        this.sqr(this.fFlags, this.jFlags);
        this.sqr(this.fFlags, this.fFlags);
    }

    private void sqr(Set<Address.Flags> flagsA, Set<Address.Flags> flagsB) {
        Array aA = new Array(new double[]{1.0, 2.0, 3.0, 4.0}, flagsA);
        Array aB = new Array(new double[]{1.0, 4.0, 9.0, 16.0}, flagsB);
        this.sqr(aA, aB);
        this.sqr(this.range(this.augmented(aA)), this.range(this.augmented(aB)));
        this.sqr(this.range(this.augmented(this.range(this.augmented(aA)))), this.range(this.augmented(this.range(this.augmented(aB)))));
    }

    private void sqr(Array aA, Array aB) {
        Array result = aA.sqr();
        if (result == aA) {
            Assert.fail((String)"'sqr' must return a new instance");
        }
        if (result == aB) {
            Assert.fail((String)"'sqr' must return a new instance");
        }
        if (!ArrayTest.equals(result, aB)) {
            Assert.fail((String)"'sqr' failed");
        }
    }

    @Test
    public void swap() {
        this.swap(this.jFlags, this.jFlags);
        this.swap(this.jFlags, this.fFlags);
        this.swap(this.fFlags, this.jFlags);
        this.swap(this.fFlags, this.fFlags);
    }

    private void swap(Set<Address.Flags> flagsA, Set<Address.Flags> flagsB) {
        Array aA = new Array(new double[]{1.0, 2.0, 3.0, 4.0}, flagsA);
        Array aB = new Array(new double[]{4.0, 3.0, 2.0, 1.0}, flagsB);
        this.swap(aA, aB);
        this.swap(this.range(this.augmented(aA)), this.range(this.augmented(aB)));
        this.swap(this.range(this.augmented(this.range(this.augmented(aA)))), this.range(this.augmented(this.range(this.augmented(aB)))));
    }

    private void swap(Array aA, Array aB) {
        Array aAclone = aA.clone();
        Array aBclone = aB.clone();
        aA.swap(aB);
        if (!ArrayTest.equals(aA, aBclone)) {
            Assert.fail((String)"'swap' failed");
        }
        if (!ArrayTest.equals(aB, aAclone)) {
            Assert.fail((String)"'swap' failed");
        }
    }
}

