/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.testsuite.instruments;

import org.jquantlib.QL;
import org.jquantlib.SavedSettings;
import org.jquantlib.Settings;
import org.jquantlib.cashflow.BlackIborCouponPricer;
import org.jquantlib.cashflow.PricerSetter;
import org.jquantlib.daycounters.Actual360;
import org.jquantlib.daycounters.DayCounter;
import org.jquantlib.exercise.AmericanExercise;
import org.jquantlib.exercise.EuropeanExercise;
import org.jquantlib.exercise.Exercise;
import org.jquantlib.indexes.Euribor1Y;
import org.jquantlib.instruments.CallabilitySchedule;
import org.jquantlib.instruments.DividendSchedule;
import org.jquantlib.instruments.Option;
import org.jquantlib.instruments.PlainVanillaPayoff;
import org.jquantlib.instruments.VanillaOption;
import org.jquantlib.instruments.bonds.ConvertibleFixedCouponBond;
import org.jquantlib.instruments.bonds.ConvertibleFloatingRateBond;
import org.jquantlib.instruments.bonds.ConvertibleZeroCouponBond;
import org.jquantlib.instruments.bonds.FixedRateBond;
import org.jquantlib.instruments.bonds.FloatingRateBond;
import org.jquantlib.instruments.bonds.ZeroCouponBond;
import org.jquantlib.math.matrixutilities.Array;
import org.jquantlib.methods.lattices.CoxRossRubinstein;
import org.jquantlib.pricingengines.BinomialConvertibleEngine;
import org.jquantlib.pricingengines.bond.DiscountingBondEngine;
import org.jquantlib.pricingengines.vanilla.BinomialVanillaEngine;
import org.jquantlib.processes.BlackScholesMertonProcess;
import org.jquantlib.quotes.Handle;
import org.jquantlib.quotes.Quote;
import org.jquantlib.quotes.RelinkableHandle;
import org.jquantlib.quotes.SimpleQuote;
import org.jquantlib.termstructures.BlackVolTermStructure;
import org.jquantlib.termstructures.YieldTermStructure;
import org.jquantlib.termstructures.volatilities.optionlet.OptionletVolatilityStructure;
import org.jquantlib.termstructures.yieldcurves.ForwardSpreadedTermStructure;
import org.jquantlib.testsuite.util.Utilities;
import org.jquantlib.time.BusinessDayConvention;
import org.jquantlib.time.Calendar;
import org.jquantlib.time.Date;
import org.jquantlib.time.DateGeneration;
import org.jquantlib.time.Frequency;
import org.jquantlib.time.MakeSchedule;
import org.jquantlib.time.Period;
import org.jquantlib.time.Schedule;
import org.jquantlib.time.TimeUnit;
import org.jquantlib.time.calendars.Target;
import org.junit.Assert;
import org.junit.Test;

public class ConvertibleBondTest {
    public ConvertibleBondTest() {
        QL.info("::::: " + this.getClass().getSimpleName() + " :::::");
    }

    @Test
    public void testBond() {
        System.setProperty("EXPERIMENTAL", "true");
        QL.info("Testing out-of-the-money convertible bonds against vanilla bonds...");
        CommonVars vars = new CommonVars();
        vars.conversionRatio = 1.0E-16;
        EuropeanExercise euExercise = new EuropeanExercise(vars.maturityDate);
        AmericanExercise amExercise = new AmericanExercise(vars.issueDate, vars.maturityDate);
        int timeSteps = 1001;
        BinomialConvertibleEngine<CoxRossRubinstein> engine = new BinomialConvertibleEngine<CoxRossRubinstein>(CoxRossRubinstein.class, vars.process, 1001);
        Handle<YieldTermStructure> discountCurve = new Handle<YieldTermStructure>(new ForwardSpreadedTermStructure(vars.riskFreeRate, vars.creditSpread));
        Schedule schedule = new MakeSchedule(vars.issueDate, vars.maturityDate, new Period(Frequency.Once), vars.calendar, BusinessDayConvention.Following).backwards().schedule();
        ConvertibleZeroCouponBond euZero = new ConvertibleZeroCouponBond((Exercise)euExercise, vars.conversionRatio, vars.no_dividends, vars.no_callability, (Handle<Quote>)vars.creditSpread, vars.issueDate, vars.settlementDays, vars.dayCounter, schedule, vars.redemption);
        euZero.setPricingEngine(engine);
        ConvertibleZeroCouponBond amZero = new ConvertibleZeroCouponBond((Exercise)amExercise, vars.conversionRatio, vars.no_dividends, vars.no_callability, (Handle<Quote>)vars.creditSpread, vars.issueDate, vars.settlementDays, vars.dayCounter, schedule, vars.redemption);
        amZero.setPricingEngine(engine);
        ZeroCouponBond zero = new ZeroCouponBond(vars.settlementDays, vars.calendar, 100.0, vars.maturityDate, BusinessDayConvention.Following, vars.redemption, vars.issueDate);
        DiscountingBondEngine bondEngine = new DiscountingBondEngine(discountCurve);
        zero.setPricingEngine(bondEngine);
        double tolerance = 0.01 * (vars.faceAmount / 100.0);
        double error = Math.abs(euZero.NPV() - zero.settlementValue());
        if (error > tolerance) {
            Assert.fail((String)("failed to reproduce zero-coupon bond price:\n    calculated: " + euZero.NPV() + "\n    expected:   " + zero.settlementValue() + "\n    error:      " + error));
        }
        if ((error = Math.abs(amZero.NPV() - zero.settlementValue())) > tolerance) {
            Assert.fail((String)("failed to reproduce zero-coupon bond price:\n    calculated: " + amZero.NPV() + "\n    expected:   " + zero.settlementValue() + "\n    error:      " + error));
        }
        double[] coupons = new double[]{0.05};
        schedule = new MakeSchedule(vars.issueDate, vars.maturityDate, new Period(vars.frequency), vars.calendar, BusinessDayConvention.Following).backwards().schedule();
        ConvertibleFixedCouponBond euFixed = new ConvertibleFixedCouponBond(euExercise, vars.conversionRatio, vars.no_dividends, vars.no_callability, vars.creditSpread, vars.issueDate, vars.settlementDays, coupons, vars.dayCounter, schedule, vars.redemption);
        euFixed.setPricingEngine(engine);
        ConvertibleFixedCouponBond amFixed = new ConvertibleFixedCouponBond(amExercise, vars.conversionRatio, vars.no_dividends, vars.no_callability, vars.creditSpread, vars.issueDate, vars.settlementDays, coupons, vars.dayCounter, schedule, vars.redemption);
        amFixed.setPricingEngine(engine);
        FixedRateBond fixed = new FixedRateBond(vars.settlementDays, vars.faceAmount, schedule, coupons, vars.dayCounter, BusinessDayConvention.Following, vars.redemption, vars.issueDate);
        fixed.setPricingEngine(bondEngine);
        tolerance = 0.02 * (vars.faceAmount / 100.0);
        error = Math.abs(euFixed.NPV() - fixed.settlementValue());
        if (error > tolerance) {
            Assert.fail((String)("failed to reproduce fixed-coupon bond price:\n    calculated: " + euFixed.NPV() + "\n    expected:   " + fixed.settlementValue() + "\n    error:      " + error));
        }
        if ((error = Math.abs(amFixed.NPV() - fixed.settlementValue())) > tolerance) {
            Assert.fail((String)("failed to reproduce fixed-coupon bond price:\n    calculated: " + amFixed.NPV() + "\n    expected:   " + fixed.settlementValue() + "\n    error:      " + error));
        }
        Euribor1Y index = new Euribor1Y(discountCurve);
        int fixingDays = 2;
        Array gearings = new Array(1).fill(1.0);
        Array spreadsArr = new Array(0);
        double[] spreads = new double[]{0.0};
        ConvertibleFloatingRateBond euFloating = new ConvertibleFloatingRateBond(euExercise, vars.conversionRatio, vars.no_dividends, vars.no_callability, vars.creditSpread, vars.issueDate, vars.settlementDays, index, 2, spreads, vars.dayCounter, schedule, vars.redemption);
        euFloating.setPricingEngine(engine);
        ConvertibleFloatingRateBond amFloating = new ConvertibleFloatingRateBond(amExercise, vars.conversionRatio, vars.no_dividends, vars.no_callability, vars.creditSpread, vars.issueDate, vars.settlementDays, index, 2, spreads, vars.dayCounter, schedule, vars.redemption);
        amFloating.setPricingEngine(engine);
        BlackIborCouponPricer pricer = new BlackIborCouponPricer(new Handle<OptionletVolatilityStructure>());
        Schedule floatSchedule = new Schedule(vars.issueDate, vars.maturityDate, new Period(vars.frequency), vars.calendar, BusinessDayConvention.Following, BusinessDayConvention.Following, DateGeneration.Rule.Backward, false);
        FloatingRateBond floating = new FloatingRateBond(vars.settlementDays, vars.faceAmount, floatSchedule, index, vars.dayCounter, BusinessDayConvention.Following, 2, gearings, spreadsArr, new Array(0), new Array(0), false, vars.redemption, vars.issueDate);
        floating.setPricingEngine(bondEngine);
        PricerSetter.setCouponPricer(floating.cashflows(), pricer);
        tolerance = 0.02 * (vars.faceAmount / 100.0);
        error = Math.abs(euFloating.NPV() - floating.settlementValue());
        if (error > tolerance) {
            Assert.fail((String)("failed to reproduce floating-rate bond price:\n    calculated: " + euFloating.NPV() + "\n    expected:   " + floating.settlementValue() + "\n    error:      " + error));
        }
        if ((error = Math.abs(amFloating.NPV() - floating.settlementValue())) > tolerance) {
            Assert.fail((String)("failed to reproduce floating-rate bond price:\n    calculated: " + amFloating.NPV() + "\n    expected:   " + floating.settlementValue() + "\n    error:      " + error));
        }
    }

    @Test
    public void testOption() {
        System.setProperty("EXPERIMENTAL", "true");
        QL.info("Testing zero-coupon convertible bonds against vanilla option...");
        CommonVars vars = new CommonVars();
        EuropeanExercise euExercise = new EuropeanExercise(vars.maturityDate);
        vars.settlementDays = 0;
        int timeSteps = 1001;
        BinomialConvertibleEngine<CoxRossRubinstein> engine = new BinomialConvertibleEngine<CoxRossRubinstein>(CoxRossRubinstein.class, vars.process, 1001);
        BinomialVanillaEngine vanillaEngine = new BinomialVanillaEngine(CoxRossRubinstein.class, vars.process, 1001);
        vars.creditSpread.linkTo(new SimpleQuote(0.0));
        double conversionStrike = vars.redemption / vars.conversionRatio;
        PlainVanillaPayoff payoff = new PlainVanillaPayoff(Option.Type.Call, conversionStrike);
        Schedule schedule = new MakeSchedule(vars.issueDate, vars.maturityDate, new Period(Frequency.Once), vars.calendar, BusinessDayConvention.Following).backwards().schedule();
        ConvertibleZeroCouponBond euZero = new ConvertibleZeroCouponBond((Exercise)euExercise, vars.conversionRatio, vars.no_dividends, vars.no_callability, (Handle<Quote>)vars.creditSpread, vars.issueDate, vars.settlementDays, vars.dayCounter, schedule, vars.redemption);
        euZero.setPricingEngine(engine);
        VanillaOption euOption = new VanillaOption(payoff, euExercise);
        euOption.setPricingEngine(vanillaEngine);
        double tolerance = 0.05 * (vars.faceAmount / 100.0);
        double expected = vars.faceAmount / 100.0 * (vars.redemption * ((YieldTermStructure)vars.riskFreeRate.currentLink()).discount(vars.maturityDate) + vars.conversionRatio * euOption.NPV());
        double error = Math.abs(euZero.NPV() - expected);
        if (error > tolerance) {
            Assert.fail((String)("failed to reproduce plain-option price:\n    calculated: " + euZero.NPV() + "\n    expected:   " + expected + "\n    error:      " + error));
        }
    }

    private class CommonVars {
        Date today;
        Date issueDate;
        Date maturityDate;
        Calendar calendar;
        DayCounter dayCounter;
        Frequency frequency;
        int settlementDays;
        RelinkableHandle<Quote> underlying = new RelinkableHandle();
        RelinkableHandle<YieldTermStructure> dividendYield = new RelinkableHandle();
        RelinkableHandle<YieldTermStructure> riskFreeRate = new RelinkableHandle();
        RelinkableHandle<BlackVolTermStructure> volatility = new RelinkableHandle();
        BlackScholesMertonProcess process;
        RelinkableHandle<Quote> creditSpread = new RelinkableHandle();
        CallabilitySchedule no_callability = new CallabilitySchedule();
        DividendSchedule no_dividends = new DividendSchedule();
        double faceAmount;
        double redemption;
        double conversionRatio;
        SavedSettings backup = new SavedSettings();

        CommonVars() {
            this.calendar = new Target();
            this.today = this.calendar.adjust(Date.todaysDate());
            new Settings().setEvaluationDate(this.today);
            this.dayCounter = new Actual360();
            this.frequency = Frequency.Annual;
            this.settlementDays = 3;
            this.issueDate = this.calendar.advance(this.today, 2, TimeUnit.Days);
            this.maturityDate = this.calendar.advance(this.issueDate, 10, TimeUnit.Years);
            this.issueDate = this.calendar.advance(this.maturityDate, -10, TimeUnit.Years);
            this.underlying.linkTo(new SimpleQuote(50.0));
            this.dividendYield.linkTo(Utilities.flatRate(this.today, 0.02, this.dayCounter));
            this.riskFreeRate.linkTo(Utilities.flatRate(this.today, 0.05, this.dayCounter));
            this.volatility.linkTo(Utilities.flatVol(this.today, 0.15, this.dayCounter));
            this.process = new BlackScholesMertonProcess(this.underlying, this.dividendYield, this.riskFreeRate, this.volatility);
            this.creditSpread.linkTo(new SimpleQuote(0.005));
            this.faceAmount = 100.0;
            this.redemption = 100.0;
            this.conversionRatio = this.redemption / ((Quote)this.underlying.currentLink()).value();
        }
    }
}

