/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.testsuite.instruments;

import org.jquantlib.QL;
import org.jquantlib.SavedSettings;
import org.jquantlib.Settings;
import org.jquantlib.cashflow.BlackIborCouponPricer;
import org.jquantlib.cashflow.FixedRateLeg;
import org.jquantlib.cashflow.Leg;
import org.jquantlib.cashflow.PricerSetter;
import org.jquantlib.cashflow.SimpleCashFlow;
import org.jquantlib.daycounters.Actual360;
import org.jquantlib.daycounters.ActualActual;
import org.jquantlib.daycounters.Business252;
import org.jquantlib.daycounters.DayCounter;
import org.jquantlib.daycounters.Thirty360;
import org.jquantlib.indexes.ibor.USDLibor;
import org.jquantlib.instruments.Bond;
import org.jquantlib.instruments.bonds.FixedRateBond;
import org.jquantlib.instruments.bonds.FloatingRateBond;
import org.jquantlib.instruments.bonds.ZeroCouponBond;
import org.jquantlib.math.matrixutilities.Array;
import org.jquantlib.pricingengines.bond.DiscountingBondEngine;
import org.jquantlib.quotes.Handle;
import org.jquantlib.quotes.SimpleQuote;
import org.jquantlib.termstructures.Compounding;
import org.jquantlib.termstructures.InterestRate;
import org.jquantlib.termstructures.YieldTermStructure;
import org.jquantlib.termstructures.volatilities.optionlet.OptionletVolatilityStructure;
import org.jquantlib.testsuite.util.Utilities;
import org.jquantlib.time.BusinessDayConvention;
import org.jquantlib.time.Calendar;
import org.jquantlib.time.Date;
import org.jquantlib.time.DateGeneration;
import org.jquantlib.time.Frequency;
import org.jquantlib.time.Month;
import org.jquantlib.time.Period;
import org.jquantlib.time.Schedule;
import org.jquantlib.time.TimeUnit;
import org.jquantlib.time.calendars.Brazil;
import org.jquantlib.time.calendars.NullCalendar;
import org.jquantlib.time.calendars.Target;
import org.jquantlib.time.calendars.UnitedStates;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class BondTest {
    public BondTest() {
        QL.info("::::: " + this.getClass().getSimpleName() + " :::::");
    }

    @Ignore
    @Test
    public void testYield() {
        QL.info("Testing consistency of bond price/yield calculation....");
        Target calendar = new Target();
        Date today = calendar.adjust(Date.todaysDate());
        double faceAmount = 1000000.0;
        double tolerance = 1.0E-7;
        int maxEvaluations = 100;
        int[] issueMonths = new int[]{-24, -18, -12, -6, 0, 6, 12, 18, 24};
        int[] lengths = new int[]{3, 5, 10, 15, 20};
        int settlementDays = 3;
        double[] coupons = new double[]{0.02, 0.05, 0.08};
        Frequency[] frequencies = new Frequency[]{Frequency.Semiannual, Frequency.Annual};
        Thirty360 bondDayCount = new Thirty360();
        BusinessDayConvention accrualConvention = BusinessDayConvention.Unadjusted;
        BusinessDayConvention paymentConvention = BusinessDayConvention.ModifiedFollowing;
        double redemption = 100.0;
        double[] yields = new double[]{0.03, 0.04, 0.05, 0.06, 0.07};
        Compounding[] compounding = new Compounding[]{Compounding.Compounded, Compounding.Continuous};
        for (int i = 0; i < issueMonths.length; ++i) {
            for (int j = 0; j < lengths.length; ++j) {
                for (int k = 0; k < coupons.length; ++k) {
                    for (int l = 0; l < frequencies.length; ++l) {
                        for (int n = 0; n < compounding.length; ++n) {
                            Date dated;
                            Date issue = dated = calendar.advance(today, issueMonths[i], TimeUnit.Months);
                            Date maturity = calendar.advance(issue, lengths[j], TimeUnit.Years);
                            Schedule sch = new Schedule(dated, maturity, new Period(frequencies[l]), calendar, accrualConvention, accrualConvention, DateGeneration.Rule.Backward, false, new Date(), new Date());
                            FixedRateBond bond = new FixedRateBond(3, 1000000.0, sch, new double[]{coupons[k]}, bondDayCount, paymentConvention, 100.0, issue);
                            for (int m = 0; m < yields.length; ++m) {
                                double price2;
                                double price = bond.cleanPrice(yields[m], bondDayCount, compounding[n], frequencies[l]);
                                double calculated = bond.yield(price, bondDayCount, compounding[n], frequencies[l], new Date(), 1.0E-7, 100);
                                if (!(Math.abs(yields[m] - calculated) > 1.0E-7) || !(Math.abs(price - (price2 = bond.cleanPrice(calculated, bondDayCount, compounding[n], frequencies[l]))) / price > 1.0E-7)) continue;
                                Assert.fail((String)("yield recalculation failed:\n    issue:     " + issue + "\n" + "    maturity:  " + maturity + "\n" + "    coupon:    " + coupons[k] + "\n" + "    frequency: " + (Object)((Object)frequencies[l]) + "\n\n" + "    yield:  " + yields[m] + " " + (compounding[n] == Compounding.Continuous ? "compounded" : "continuous") + "\n" + "    price:  " + price + "\n" + "    yield': " + calculated + "\n" + "    price': " + price2));
                            }
                        }
                    }
                }
            }
        }
    }

    @Test
    public void testTheoretical() {
        QL.info("Testing theoretical bond price/yield calculation...");
        Target calendar = new Target();
        Date today = calendar.adjust(Date.todaysDate());
        double faceAmount = 1000000.0;
        double tolerance = 1.0E-7;
        int maxEvaluations = 100;
        int[] lengths = new int[]{3, 5, 10, 15, 20};
        int settlementDays = 3;
        double[] coupons = new double[]{0.02, 0.05, 0.08};
        Frequency[] frequencies = new Frequency[]{Frequency.Semiannual, Frequency.Annual};
        Actual360 bondDayCount = new Actual360();
        BusinessDayConvention accrualConvention = BusinessDayConvention.Unadjusted;
        BusinessDayConvention paymentConvention = BusinessDayConvention.ModifiedFollowing;
        double redemption = 100.0;
        double[] yields = new double[]{0.03, 0.04, 0.05, 0.06, 0.07};
        for (int length : lengths) {
            for (double coupon : coupons) {
                for (Frequency frequency : frequencies) {
                    Date dated;
                    Date issue = dated = today;
                    Date maturity = calendar.advance(issue, length, TimeUnit.Years);
                    SimpleQuote rate = new SimpleQuote(0.0);
                    Handle<YieldTermStructure> discountCurve = new Handle<YieldTermStructure>(Utilities.flatRate(today, rate, (DayCounter)bondDayCount));
                    Schedule sch = new Schedule(dated, maturity, new Period(frequency), calendar, accrualConvention, accrualConvention, DateGeneration.Rule.Backward, false);
                    FixedRateBond bond = new FixedRateBond(3, 1000000.0, sch, new double[]{coupon}, bondDayCount, paymentConvention, 100.0, issue);
                    DiscountingBondEngine bondEngine = new DiscountingBondEngine(discountCurve);
                    bond.setPricingEngine(bondEngine);
                    for (double yield : yields) {
                        double calculatedYield;
                        rate.setValue(yield);
                        double price = bond.cleanPrice(yield, bondDayCount, Compounding.Continuous, frequency);
                        double calculatedPrice = bond.cleanPrice();
                        if (Math.abs(price - calculatedPrice) > 1.0E-7) {
                            Assert.fail((String)("price calculation failed:\n    issue:     " + issue + "\n    maturity:  " + maturity + "\n    coupon:    " + coupon + "\n    frequency: " + (Object)((Object)frequency) + "\n" + "\n    yield:  " + yield + "\n    expected:    " + price + "\n    calculated': " + calculatedPrice + "\n    error':      " + (price - calculatedPrice)));
                        }
                        if (!(Math.abs(yield - (calculatedYield = bond.yield(bondDayCount, Compounding.Continuous, frequency, 1.0E-7, 100))) > 1.0E-7)) continue;
                        Assert.fail((String)("yield calculation failed:\n    issue:     " + issue + "\n    maturity:  " + maturity + "\n    coupon:    " + coupon + "\n    frequency: " + (Object)((Object)frequency) + "\n" + "\n    yield:  " + yield + "\n    price:    " + price + "\n    yield': " + calculatedYield));
                    }
                }
            }
        }
    }

    @Test
    public void testCached() {
        double yield;
        QL.info("Testing bond price/yield calculation against cached values...");
        Date today = new Date(22, Month.November, 2004);
        Settings settings = new Settings();
        settings.setEvaluationDate(today);
        double faceAmount = 1000000.0;
        NullCalendar bondCalendar = new NullCalendar();
        ActualActual bondDayCount = new ActualActual(ActualActual.Convention.ISMA);
        boolean settlementDays = true;
        Handle<YieldTermStructure> discountCurve = new Handle<YieldTermStructure>(Utilities.flatRate(today, 0.03, (DayCounter)new Actual360()));
        Frequency freq = Frequency.Semiannual;
        Schedule sch1 = new Schedule(new Date(31, Month.October, 2004), new Date(31, Month.October, 2006), new Period(freq), bondCalendar, BusinessDayConvention.Unadjusted, BusinessDayConvention.Unadjusted, DateGeneration.Rule.Backward, false);
        FixedRateBond bond1 = new FixedRateBond(1, 1000000.0, sch1, new double[]{0.025}, bondDayCount, BusinessDayConvention.ModifiedFollowing, 100.0, new Date(1, Month.November, 2004));
        DiscountingBondEngine bondEngine = new DiscountingBondEngine(discountCurve);
        bond1.setPricingEngine(bondEngine);
        double marketPrice1 = 99.203125;
        double marketYield1 = 0.02925;
        Schedule sch2 = new Schedule(new Date(15, Month.November, 2004), new Date(15, Month.November, 2009), new Period(freq), bondCalendar, BusinessDayConvention.Unadjusted, BusinessDayConvention.Unadjusted, DateGeneration.Rule.Backward, false);
        FixedRateBond bond2 = new FixedRateBond(1, 1000000.0, sch2, new double[]{0.035}, bondDayCount, BusinessDayConvention.ModifiedFollowing, 100.0, new Date(15, Month.November, 2004));
        bond2.setPricingEngine(bondEngine);
        double marketPrice2 = 99.6875;
        double marketYield2 = 0.03569;
        double cachedPrice1a = 99.204505;
        double cachedPrice2a = 99.687192;
        double cachedPrice1b = 98.943393;
        double cachedPrice2b = 101.986794;
        double cachedYield1a = 0.029257;
        double cachedYield2a = 0.035689;
        double cachedYield1b = 0.029045;
        double cachedYield2b = 0.035375;
        double cachedYield1c = 0.030423;
        double cachedYield2c = 0.030432;
        double tolerance = 1.0E-6;
        double price = bond1.cleanPrice(0.02925, bondDayCount, Compounding.Compounded, freq);
        if (Math.abs(price - 99.204505) > 1.0E-6) {
            Assert.fail((String)("failed to reproduce cached price:\n    calculated: " + price + "\n    expected:   " + 99.204505 + "\n    tolerance:  " + 1.0E-6 + "\n    error:      " + (price - 99.204505)));
        }
        if (Math.abs((price = bond1.cleanPrice()) - 98.943393) > 1.0E-6) {
            Assert.fail((String)("failed to reproduce cached price:\n    calculated: " + price + "\n    expected:   " + 98.943393 + "\n    tolerance:  " + 1.0E-6 + "\n    error:      " + (price - 98.943393)));
        }
        if (Math.abs((yield = bond1.yield(99.203125, bondDayCount, Compounding.Compounded, freq)) - 0.029257) > 1.0E-6) {
            Assert.fail((String)("failed to reproduce cached compounded yield:\n    calculated: " + yield + "\n    expected:   " + 0.029257 + "\n    tolerance:  " + 1.0E-6 + "\n    error:      " + (yield - 0.029257)));
        }
        if (Math.abs((yield = bond1.yield(99.203125, bondDayCount, Compounding.Continuous, freq)) - 0.029045) > 1.0E-6) {
            Assert.fail((String)("failed to reproduce cached continuous yield:\n    calculated: " + yield + "\n    expected:   " + 0.029045 + "\n    tolerance:  " + 1.0E-6 + "\n    error:      " + (yield - 0.029045)));
        }
        if (Math.abs((yield = bond1.yield(bondDayCount, Compounding.Continuous, freq)) - 0.030423) > 1.0E-6) {
            Assert.fail((String)("failed to reproduce cached continuous yield:\n    calculated: " + yield + "\n    expected:   " + 0.030423 + "\n    tolerance:  " + 1.0E-6 + "\n    error:      " + (yield - 0.030423)));
        }
        if (Math.abs((price = bond2.cleanPrice(0.03569, bondDayCount, Compounding.Compounded, freq)) - 99.687192) > 1.0E-6) {
            Assert.fail((String)("failed to reproduce cached price:\n    calculated: " + price + "\n    expected:   " + 99.687192 + "\n    tolerance:  " + 1.0E-6 + "\n    error:      " + (price - 99.687192)));
        }
        if (Math.abs((price = bond2.cleanPrice()) - 101.986794) > 1.0E-6) {
            Assert.fail((String)("failed to reproduce cached price:\n    calculated: " + price + "\n    expected:   " + 101.986794 + "\n    tolerance:  " + 1.0E-6 + "\n    error:      " + (price - 101.986794)));
        }
        if (Math.abs((yield = bond2.yield(99.6875, bondDayCount, Compounding.Compounded, freq)) - 0.035689) > 1.0E-6) {
            Assert.fail((String)("failed to reproduce cached compounded yield:\n    calculated: " + yield + "\n    expected:   " + 0.035689 + "\n    tolerance:  " + 1.0E-6 + "\n    error:      " + (yield - 0.035689)));
        }
        if (Math.abs((yield = bond2.yield(99.6875, bondDayCount, Compounding.Continuous, freq)) - 0.035375) > 1.0E-6) {
            Assert.fail((String)("failed to reproduce cached continuous yield:\n    calculated: " + yield + "\n    expected:   " + 0.035375 + "\n    tolerance:  " + 1.0E-6 + "\n    error:      " + (yield - 0.035375)));
        }
        if (Math.abs((yield = bond2.yield(bondDayCount, Compounding.Continuous, freq)) - 0.030432) > 1.0E-6) {
            Assert.fail((String)("failed to reproduce cached continuous yield:\n    calculated: " + yield + "\n    expected:   " + 0.030432 + "\n    tolerance:  " + 1.0E-6 + "\n    error:      " + (yield - 0.030432)));
        }
        Schedule sch3 = new Schedule(new Date(30, Month.November, 2004), new Date(30, Month.November, 2006), new Period(freq), new UnitedStates(UnitedStates.Market.GOVERNMENTBOND), BusinessDayConvention.Unadjusted, BusinessDayConvention.Unadjusted, DateGeneration.Rule.Backward, false);
        FixedRateBond bond3 = new FixedRateBond(1, 1000000.0, sch3, new double[]{0.02875}, new ActualActual(ActualActual.Convention.ISMA), BusinessDayConvention.ModifiedFollowing, 100.0, new Date(30, Month.November, 2004));
        bond3.setPricingEngine(bondEngine);
        double marketYield3 = 0.02997;
        Date settlementDate = new Date(30, Month.November, 2004);
        double cachedPrice3 = 99.764874;
        price = bond3.cleanPrice(0.02997, bondDayCount, Compounding.Compounded, freq, settlementDate);
        if (Math.abs(price - 99.764874) > 1.0E-6) {
            Assert.fail((String)("failed to reproduce cached price:\n    calculated: " + price + "" + "\n    expected:   " + 99.764874 + "" + "\n    error:      " + (price - 99.764874)));
        }
        settings.setEvaluationDate(new Date(22, Month.November, 2004));
        price = bond3.cleanPrice(0.02997, bondDayCount, Compounding.Compounded, freq);
        if (Math.abs(price - 99.764874) > 1.0E-6) {
            Assert.fail((String)("failed to reproduce cached price:\n    calculated: " + price + "" + "\n    expected:   " + 99.764874 + "" + "\n    error:      " + (price - 99.764874)));
        }
    }

    @Test
    public void testCachedZero() {
        QL.info("Testing zero-coupon bond prices against cached values...");
        Target calendar = new Target();
        Date today = calendar.adjust(Date.todaysDate());
        Settings settings = new Settings();
        settings.setEvaluationDate(today);
        double faceAmount = 1000000.0;
        boolean settlementDays = true;
        Handle<YieldTermStructure> discountCurve = new Handle<YieldTermStructure>(Utilities.flatRate(today, 0.03, (DayCounter)new Actual360()));
        double tolerance = 1.0E-6;
        ZeroCouponBond bond1 = new ZeroCouponBond(1, new UnitedStates(UnitedStates.Market.GOVERNMENTBOND), 1000000.0, new Date(30, Month.November, 2008), BusinessDayConvention.ModifiedFollowing, 100.0, new Date(30, Month.November, 2004));
        DiscountingBondEngine bondEngine = new DiscountingBondEngine(discountCurve);
        bond1.setPricingEngine(bondEngine);
        double cachedPrice1 = 88.551726;
        double price = bond1.cleanPrice();
        if (Math.abs(price - 88.551726) > 1.0E-6) {
            Assert.fail((String)("failed to reproduce cached price:\n    calculated: " + price + "\n" + "    expected:   " + 88.551726 + "\n" + "    error:      " + (price - 88.551726)));
        }
        ZeroCouponBond bond2 = new ZeroCouponBond(1, new UnitedStates(UnitedStates.Market.GOVERNMENTBOND), 1000000.0, new Date(30, Month.November, 2007), BusinessDayConvention.ModifiedFollowing, 100.0, new Date(30, Month.November, 2004));
        bond2.setPricingEngine(bondEngine);
        double cachedPrice2 = 91.278949;
        price = bond2.cleanPrice();
        if (Math.abs(price - 91.278949) > 1.0E-6) {
            Assert.fail((String)("failed to reproduce cached price:\n    calculated: " + price + "\n" + "    expected:   " + 91.278949 + "\n" + "    error:      " + (price - 91.278949)));
        }
        ZeroCouponBond bond3 = new ZeroCouponBond(1, new UnitedStates(UnitedStates.Market.GOVERNMENTBOND), 1000000.0, new Date(30, Month.November, 2006), BusinessDayConvention.ModifiedFollowing, 100.0, new Date(30, Month.November, 2004));
        bond3.setPricingEngine(bondEngine);
        double cachedPrice3 = 94.098006;
        price = bond3.cleanPrice();
        if (Math.abs(price - 94.098006) > 1.0E-6) {
            Assert.fail((String)("failed to reproduce cached price:\n    calculated: " + price + "\n" + "    expected:   " + 94.098006 + "\n" + "    error:      " + (price - 94.098006)));
        }
    }

    @Test
    public void testCachedFixed() {
        QL.info("Testing fixed-coupon bond prices against cached values...");
        Target calendar = new Target();
        Date today = calendar.adjust(Date.todaysDate());
        Settings settings = new Settings();
        settings.setEvaluationDate(today);
        double faceAmount = 1000000.0;
        boolean settlementDays = true;
        Handle<YieldTermStructure> discountCurve = new Handle<YieldTermStructure>(Utilities.flatRate(today, 0.03, (DayCounter)new Actual360()));
        double tolerance = 1.0E-6;
        Schedule sch = new Schedule(new Date(30, Month.November, 2004), new Date(30, Month.November, 2008), new Period(Frequency.Semiannual), new UnitedStates(UnitedStates.Market.GOVERNMENTBOND), BusinessDayConvention.Unadjusted, BusinessDayConvention.Unadjusted, DateGeneration.Rule.Backward, false);
        FixedRateBond bond1 = new FixedRateBond(1, 1000000.0, sch, new double[]{0.02875}, new ActualActual(ActualActual.Convention.ISMA), BusinessDayConvention.ModifiedFollowing, 100.0, new Date(30, Month.November, 2004));
        DiscountingBondEngine bondEngine = new DiscountingBondEngine(discountCurve);
        bond1.setPricingEngine(bondEngine);
        double cachedPrice1 = 99.2981;
        double price = bond1.cleanPrice();
        if (Math.abs(price - 99.2981) > 1.0E-6) {
            Assert.fail((String)("failed to reproduce cached price:\n    calculated: " + price + "\n" + "    expected:   " + 99.2981 + "\n" + "    error:      " + (price - 99.2981)));
        }
        double[] couponRates = new double[]{0.02875, 0.03, 0.03125, 0.0325};
        FixedRateBond bond2 = new FixedRateBond(1, 1000000.0, sch, couponRates, new ActualActual(ActualActual.Convention.ISMA), BusinessDayConvention.ModifiedFollowing, 100.0, new Date(30, Month.November, 2004));
        bond2.setPricingEngine(bondEngine);
        double cachedPrice2 = 100.334149;
        price = bond2.cleanPrice();
        if (Math.abs(price - 100.334149) > 1.0E-6) {
            Assert.fail((String)("failed to reproduce cached price:\n    calculated: " + price + "\n" + "    expected:   " + 100.334149 + "\n" + "    error:      " + (price - 100.334149)));
        }
        Schedule sch3 = new Schedule(new Date(30, Month.November, 2004), new Date(30, Month.March, 2009), new Period(Frequency.Semiannual), new UnitedStates(UnitedStates.Market.GOVERNMENTBOND), BusinessDayConvention.Unadjusted, BusinessDayConvention.Unadjusted, DateGeneration.Rule.Backward, false, new Date(), new Date(30, Month.November, 2008));
        FixedRateBond bond3 = new FixedRateBond(1, 1000000.0, sch3, couponRates, new ActualActual(ActualActual.Convention.ISMA), BusinessDayConvention.ModifiedFollowing, 100.0, new Date(30, Month.November, 2004));
        bond3.setPricingEngine(bondEngine);
        double cachedPrice3 = 100.382794;
        price = bond3.cleanPrice();
        if (Math.abs(price - 100.382794) > 1.0E-6) {
            Assert.fail((String)("failed to reproduce cached price:\n    calculated: " + price + "\n" + "    expected:   " + 100.382794 + "\n" + "    error:      " + (price - 100.382794)));
        }
    }

    @Test
    public void testCachedFloating() {
        QL.info("Testing floating-rate bond prices against cached values...");
        CommonVars vars = new CommonVars();
        Date today = new Date(22, Month.November, 2004);
        Settings settings = new Settings();
        settings.setEvaluationDate(today);
        boolean settlementDays = true;
        Handle<YieldTermStructure> riskFreeRate = new Handle<YieldTermStructure>(Utilities.flatRate(today, 0.025, (DayCounter)new Actual360()));
        Handle<YieldTermStructure> discountCurve = new Handle<YieldTermStructure>(Utilities.flatRate(today, 0.03, (DayCounter)new Actual360()));
        USDLibor index = new USDLibor(new Period(6, TimeUnit.Months), riskFreeRate);
        boolean fixingDays = true;
        double tolerance = 1.0E-6;
        BlackIborCouponPricer pricer = new BlackIborCouponPricer(new Handle<OptionletVolatilityStructure>());
        Schedule sch = new Schedule(new Date(30, Month.November, 2004), new Date(30, Month.November, 2008), new Period(Frequency.Semiannual), new UnitedStates(UnitedStates.Market.GOVERNMENTBOND), BusinessDayConvention.ModifiedFollowing, BusinessDayConvention.ModifiedFollowing, DateGeneration.Rule.Backward, false);
        FloatingRateBond bond1 = new FloatingRateBond(1, vars.faceAmount, sch, index, new ActualActual(ActualActual.Convention.ISMA), BusinessDayConvention.ModifiedFollowing, 1, new Array(0), new Array(0), new Array(0), new Array(0), false, 100.0, new Date(30, Month.November, 2004));
        DiscountingBondEngine bondEngine = new DiscountingBondEngine(riskFreeRate);
        bond1.setPricingEngine(bondEngine);
        PricerSetter.setCouponPricer(bond1.cashflows(), pricer);
        boolean indexedCoupon = new Settings().isUseIndexedCoupon();
        double cachedPrice1 = indexedCoupon ? 99.874645 : 99.874646;
        double price = bond1.cleanPrice();
        if (Math.abs(price - cachedPrice1) > 1.0E-6) {
            Assert.fail((String)("failed to reproduce cached price:\n    calculated: " + price + "\n" + "    expected:   " + cachedPrice1 + "\n" + "    error:      " + (price - cachedPrice1)));
        }
        FloatingRateBond bond2 = new FloatingRateBond(1, vars.faceAmount, sch, index, new ActualActual(ActualActual.Convention.ISMA), BusinessDayConvention.ModifiedFollowing, 1, new Array(0), new Array(0), new Array(0), new Array(0), false, 100.0, new Date(30, Month.November, 2004));
        DiscountingBondEngine bondEngine2 = new DiscountingBondEngine(discountCurve);
        bond2.setPricingEngine(bondEngine2);
        PricerSetter.setCouponPricer(bond2.cashflows(), pricer);
        double cachedPrice2 = indexedCoupon ? 97.955904 : 97.955904;
        price = bond2.cleanPrice();
        if (Math.abs(price - cachedPrice2) > 1.0E-6) {
            Assert.fail((String)("failed to reproduce cached price:\n    calculated: " + price + "\n" + "    expected:   " + cachedPrice2 + "\n" + "    error:      " + (price - cachedPrice2)));
        }
        double[] spreads = new double[]{0.001, 0.0012, 0.0014, 0.0016};
        FloatingRateBond bond3 = new FloatingRateBond(1, vars.faceAmount, sch, index, new ActualActual(ActualActual.Convention.ISMA), BusinessDayConvention.ModifiedFollowing, 1, new Array(0), new Array(spreads), new Array(0), new Array(0), false, 100.0, new Date(30, Month.November, 2004));
        bond3.setPricingEngine(bondEngine2);
        PricerSetter.setCouponPricer(bond3.cashflows(), pricer);
        double cachedPrice3 = indexedCoupon ? 98.495458 : 98.495459;
        price = bond3.cleanPrice();
        if (Math.abs(price - cachedPrice3) > 1.0E-6) {
            Assert.fail((String)("failed to reproduce cached price:\n    calculated: " + price + "\n" + "    expected:   " + cachedPrice3 + "\n" + "    error:      " + (price - cachedPrice3)));
        }
    }

    @Test
    public void testBrazilianCached() {
        QL.info("Testing Brazilian public bond prices against cached values...");
        Target calendar = new Target();
        Date today = calendar.adjust(new Date(6, Month.June, 2007));
        Settings settings = new Settings();
        settings.setEvaluationDate(today);
        double faceAmount = 1000.0;
        boolean settlementDays = true;
        Date[] maturityDates = new Date[]{new Date(1, Month.January, 2008), new Date(1, Month.January, 2010), new Date(1, Month.July, 2010), new Date(1, Month.January, 2012), new Date(1, Month.January, 2014), new Date(1, Month.January, 2017)};
        double[] yields = new double[]{0.114614, 0.105726, 0.105328, 0.104283, 0.103218, 0.102948};
        double[] prices = new double[]{1034.63031372, 1030.09919487, 1029.9830716, 1028.13585068, 1028.33383817, 1026.19716497};
        double tolerance = 1.0E-4;
        InterestRate[] couponRates = new InterestRate[]{new InterestRate(0.1, new Thirty360(), Compounding.Compounded, Frequency.Annual)};
        for (int bondIndex = 0; bondIndex < maturityDates.length; ++bondIndex) {
            InterestRate yield = new InterestRate(yields[bondIndex], new Business252(new Brazil()), Compounding.Compounded, Frequency.Annual);
            Schedule schedule = new Schedule(new Date(1, Month.January, 2007), maturityDates[bondIndex], new Period(Frequency.Semiannual), new Brazil(Brazil.Market.SETTLEMENT), BusinessDayConvention.Unadjusted, BusinessDayConvention.Unadjusted, DateGeneration.Rule.Backward, false);
            Leg cashflows = new FixedRateLeg(schedule, new Actual360()).withNotionals(1000.0).withCouponRates(couponRates).withPaymentAdjustment(BusinessDayConvention.ModifiedFollowing).Leg();
            cashflows.add(new SimpleCashFlow(1000.0, cashflows.last().date()));
            Bond bond = new Bond(1, new Brazil(Brazil.Market.SETTLEMENT), 1000.0, cashflows.last().date(), new Date(1, Month.January, 2007), cashflows);
            double cachedPrice = prices[bondIndex];
            double price = 1000.0 * bond.dirtyPrice(yield.rate(), yield.dayCounter(), yield.compounding(), yield.frequency(), today) / 100.0;
            if (!(Math.abs(price - cachedPrice) > 1.0E-4)) continue;
            Assert.fail((String)("failed to reproduce cached price:\n    calculated: " + price + "\n" + "    expected:   " + cachedPrice + "\n" + "    error:      " + (price - cachedPrice) + "\n"));
        }
    }

    private class CommonVars {
        Calendar calendar;
        Date today;
        double faceAmount;
        SavedSettings backup = new SavedSettings();

        public CommonVars() {
            this.calendar = new Target();
            this.today = this.calendar.adjust(Date.todaysDate());
            new Settings().setEvaluationDate(this.today);
            this.faceAmount = 1000000.0;
        }
    }
}

