/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.testsuite.instruments;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import org.jquantlib.QL;
import org.jquantlib.Settings;
import org.jquantlib.daycounters.Actual360;
import org.jquantlib.daycounters.DayCounter;
import org.jquantlib.exercise.AmericanExercise;
import org.jquantlib.exercise.Exercise;
import org.jquantlib.instruments.Option;
import org.jquantlib.instruments.PlainVanillaPayoff;
import org.jquantlib.instruments.StrikedTypePayoff;
import org.jquantlib.instruments.VanillaOption;
import org.jquantlib.pricingengines.PricingEngine;
import org.jquantlib.pricingengines.vanilla.BaroneAdesiWhaleyApproximationEngine;
import org.jquantlib.pricingengines.vanilla.BjerksundStenslandApproximationEngine;
import org.jquantlib.pricingengines.vanilla.JuQuadraticApproximationEngine;
import org.jquantlib.pricingengines.vanilla.finitedifferences.FDAmericanEngine;
import org.jquantlib.pricingengines.vanilla.finitedifferences.FDShoutEngine;
import org.jquantlib.processes.BlackScholesMertonProcess;
import org.jquantlib.processes.GeneralizedBlackScholesProcess;
import org.jquantlib.quotes.Handle;
import org.jquantlib.quotes.SimpleQuote;
import org.jquantlib.termstructures.BlackVolTermStructure;
import org.jquantlib.termstructures.YieldTermStructure;
import org.jquantlib.testsuite.util.Utilities;
import org.jquantlib.time.Date;
import org.jquantlib.time.Period;
import org.jquantlib.time.TimeUnit;
import org.junit.Assert;
import org.junit.Test;

public class AmericanOptionTest {
    public AmericanOptionTest() {
        QL.info("::::: " + this.getClass().getSimpleName() + " :::::");
    }

    @Test
    public void testBjerksundStenslandValues() {
        QL.info("Testing Bjerksund and Stensland approximation for American options...");
        AmericanOptionData[] values = new AmericanOptionData[]{new AmericanOptionData(Option.Type.Call, 40.0, 42.0, 0.08, 0.04, 0.75, 0.35, 5.2704), new AmericanOptionData(Option.Type.Put, 40.0, 36.0, 0.0, 0.06, 1.0, 0.2, 4.4531)};
        Date today = new Settings().evaluationDate();
        Actual360 dc = new Actual360();
        SimpleQuote spot = new SimpleQuote(0.0);
        SimpleQuote qRate = new SimpleQuote(0.0);
        YieldTermStructure qTS = Utilities.flatRate(today, qRate, (DayCounter)dc);
        SimpleQuote rRate = new SimpleQuote(0.0);
        YieldTermStructure rTS = Utilities.flatRate(today, rRate, (DayCounter)dc);
        SimpleQuote vol = new SimpleQuote(0.0);
        BlackVolTermStructure volTS = Utilities.flatVol(today, vol, (DayCounter)dc);
        double tolerance = 1.0E-4;
        for (AmericanOptionData value : values) {
            PlainVanillaPayoff payoff = new PlainVanillaPayoff(value.type, value.strike);
            int daysToExpiry = (int)(value.t * 360.0 + 0.5);
            Date exDate = today.clone().addAssign(daysToExpiry);
            AmericanExercise exercise = new AmericanExercise(today, exDate);
            spot.setValue(value.s);
            qRate.setValue(value.q);
            rRate.setValue(value.r);
            vol.setValue(value.v);
            BlackScholesMertonProcess stochProcess = new BlackScholesMertonProcess(new Handle<SimpleQuote>(spot), new Handle<YieldTermStructure>(qTS), new Handle<YieldTermStructure>(rTS), new Handle<BlackVolTermStructure>(volTS));
            BjerksundStenslandApproximationEngine engine = new BjerksundStenslandApproximationEngine(stochProcess);
            VanillaOption option = new VanillaOption(payoff, exercise);
            option.setPricingEngine(engine);
            double calculated = option.NPV();
            double error = Math.abs(calculated - value.result);
            if (!(error > 1.0E-4)) continue;
            this.reportFailure("value", payoff, exercise, value.s, value.q, value.r, today, value.v, value.result, calculated, error, 1.0E-4);
        }
    }

    @Test
    public void testBaroneAdesiWhaley() {
        QL.info("Testing Barone-Adesi and Whaley approximation for American options...");
        AmericanOptionData[] values = new AmericanOptionData[]{new AmericanOptionData(Option.Type.Call, 100.0, 90.0, 0.1, 0.1, 0.1, 0.15, 0.0206), new AmericanOptionData(Option.Type.Call, 100.0, 100.0, 0.1, 0.1, 0.1, 0.15, 1.8771), new AmericanOptionData(Option.Type.Call, 100.0, 110.0, 0.1, 0.1, 0.1, 0.15, 10.0089), new AmericanOptionData(Option.Type.Call, 100.0, 90.0, 0.1, 0.1, 0.1, 0.25, 0.3159), new AmericanOptionData(Option.Type.Call, 100.0, 100.0, 0.1, 0.1, 0.1, 0.25, 3.128), new AmericanOptionData(Option.Type.Call, 100.0, 110.0, 0.1, 0.1, 0.1, 0.25, 10.3919), new AmericanOptionData(Option.Type.Call, 100.0, 90.0, 0.1, 0.1, 0.1, 0.35, 0.9495), new AmericanOptionData(Option.Type.Call, 100.0, 100.0, 0.1, 0.1, 0.1, 0.35, 4.3777), new AmericanOptionData(Option.Type.Call, 100.0, 110.0, 0.1, 0.1, 0.1, 0.35, 11.1679), new AmericanOptionData(Option.Type.Call, 100.0, 90.0, 0.1, 0.1, 0.5, 0.15, 0.8208), new AmericanOptionData(Option.Type.Call, 100.0, 100.0, 0.1, 0.1, 0.5, 0.15, 4.0842), new AmericanOptionData(Option.Type.Call, 100.0, 110.0, 0.1, 0.1, 0.5, 0.15, 10.8087), new AmericanOptionData(Option.Type.Call, 100.0, 90.0, 0.1, 0.1, 0.5, 0.25, 2.7437), new AmericanOptionData(Option.Type.Call, 100.0, 100.0, 0.1, 0.1, 0.5, 0.25, 6.8015), new AmericanOptionData(Option.Type.Call, 100.0, 110.0, 0.1, 0.1, 0.5, 0.25, 13.017), new AmericanOptionData(Option.Type.Call, 100.0, 90.0, 0.1, 0.1, 0.5, 0.35, 5.0063), new AmericanOptionData(Option.Type.Call, 100.0, 100.0, 0.1, 0.1, 0.5, 0.35, 9.5106), new AmericanOptionData(Option.Type.Call, 100.0, 110.0, 0.1, 0.1, 0.5, 0.35, 15.5689), new AmericanOptionData(Option.Type.Put, 100.0, 90.0, 0.1, 0.1, 0.1, 0.15, 10.0), new AmericanOptionData(Option.Type.Put, 100.0, 100.0, 0.1, 0.1, 0.1, 0.15, 1.877), new AmericanOptionData(Option.Type.Put, 100.0, 110.0, 0.1, 0.1, 0.1, 0.15, 0.041), new AmericanOptionData(Option.Type.Put, 100.0, 90.0, 0.1, 0.1, 0.1, 0.25, 10.2533), new AmericanOptionData(Option.Type.Put, 100.0, 100.0, 0.1, 0.1, 0.1, 0.25, 3.1277), new AmericanOptionData(Option.Type.Put, 100.0, 110.0, 0.1, 0.1, 0.1, 0.25, 0.4562), new AmericanOptionData(Option.Type.Put, 100.0, 90.0, 0.1, 0.1, 0.1, 0.35, 10.8787), new AmericanOptionData(Option.Type.Put, 100.0, 100.0, 0.1, 0.1, 0.1, 0.35, 4.3777), new AmericanOptionData(Option.Type.Put, 100.0, 110.0, 0.1, 0.1, 0.1, 0.35, 1.2402), new AmericanOptionData(Option.Type.Put, 100.0, 90.0, 0.1, 0.1, 0.5, 0.15, 10.5595), new AmericanOptionData(Option.Type.Put, 100.0, 100.0, 0.1, 0.1, 0.5, 0.15, 4.0842), new AmericanOptionData(Option.Type.Put, 100.0, 110.0, 0.1, 0.1, 0.5, 0.15, 1.0822), new AmericanOptionData(Option.Type.Put, 100.0, 90.0, 0.1, 0.1, 0.5, 0.25, 12.4419), new AmericanOptionData(Option.Type.Put, 100.0, 100.0, 0.1, 0.1, 0.5, 0.25, 6.8014), new AmericanOptionData(Option.Type.Put, 100.0, 110.0, 0.1, 0.1, 0.5, 0.25, 3.3226), new AmericanOptionData(Option.Type.Put, 100.0, 90.0, 0.1, 0.1, 0.5, 0.35, 14.6945), new AmericanOptionData(Option.Type.Put, 100.0, 100.0, 0.1, 0.1, 0.5, 0.35, 9.5104), new AmericanOptionData(Option.Type.Put, 100.0, 110.0, 0.1, 0.1, 0.5, 0.35, 5.8823)};
        Date today = new Settings().evaluationDate();
        Actual360 dc = new Actual360();
        SimpleQuote spot = new SimpleQuote(0.0);
        SimpleQuote qRate = new SimpleQuote(0.0);
        YieldTermStructure qTS = Utilities.flatRate(today, qRate, (DayCounter)dc);
        SimpleQuote rRate = new SimpleQuote(0.0);
        YieldTermStructure rTS = Utilities.flatRate(today, rRate, (DayCounter)dc);
        SimpleQuote vol = new SimpleQuote(0.0);
        BlackVolTermStructure volTS = Utilities.flatVol(today, vol, (DayCounter)dc);
        double tolerance = 0.003;
        for (AmericanOptionData value : values) {
            PlainVanillaPayoff payoff = new PlainVanillaPayoff(value.type, value.strike);
            Date exDate = today.add(this.timeToDays(value.t));
            AmericanExercise exercise = new AmericanExercise(today, exDate);
            spot.setValue(value.s);
            qRate.setValue(value.q);
            rRate.setValue(value.r);
            vol.setValue(value.v);
            BlackScholesMertonProcess stochProcess = new BlackScholesMertonProcess(new Handle<SimpleQuote>(spot), new Handle<YieldTermStructure>(qTS), new Handle<YieldTermStructure>(rTS), new Handle<BlackVolTermStructure>(volTS));
            BaroneAdesiWhaleyApproximationEngine engine = new BaroneAdesiWhaleyApproximationEngine(stochProcess);
            VanillaOption option = new VanillaOption(payoff, exercise);
            option.setPricingEngine(engine);
            double calculated = option.NPV();
            double error = Math.abs(calculated - value.result);
            if (!(error > 0.003)) continue;
            this.reportFailure("value", payoff, exercise, value.s, value.q, value.r, today, value.v, value.result, calculated, error, 0.003);
        }
    }

    @Test
    public void testJu() {
        AmericanOptionData[] juValues = new AmericanOptionData[]{new AmericanOptionData(Option.Type.Put, 35.0, 40.0, 0.0, 0.0488, 0.0833, 0.2, 0.006), new AmericanOptionData(Option.Type.Put, 35.0, 40.0, 0.0, 0.0488, 0.3333, 0.2, 0.201), new AmericanOptionData(Option.Type.Put, 35.0, 40.0, 0.0, 0.0488, 0.5833, 0.2, 0.433), new AmericanOptionData(Option.Type.Put, 40.0, 40.0, 0.0, 0.0488, 0.0833, 0.2, 0.851), new AmericanOptionData(Option.Type.Put, 40.0, 40.0, 0.0, 0.0488, 0.3333, 0.2, 1.576), new AmericanOptionData(Option.Type.Put, 40.0, 40.0, 0.0, 0.0488, 0.5833, 0.2, 1.984), new AmericanOptionData(Option.Type.Put, 45.0, 40.0, 0.0, 0.0488, 0.0833, 0.2, 5.0), new AmericanOptionData(Option.Type.Put, 45.0, 40.0, 0.0, 0.0488, 0.3333, 0.2, 5.084), new AmericanOptionData(Option.Type.Put, 45.0, 40.0, 0.0, 0.0488, 0.5833, 0.2, 5.26), new AmericanOptionData(Option.Type.Put, 35.0, 40.0, 0.0, 0.0488, 0.0833, 0.3, 0.078), new AmericanOptionData(Option.Type.Put, 35.0, 40.0, 0.0, 0.0488, 0.3333, 0.3, 0.697), new AmericanOptionData(Option.Type.Put, 35.0, 40.0, 0.0, 0.0488, 0.5833, 0.3, 1.218), new AmericanOptionData(Option.Type.Put, 40.0, 40.0, 0.0, 0.0488, 0.0833, 0.3, 1.309), new AmericanOptionData(Option.Type.Put, 40.0, 40.0, 0.0, 0.0488, 0.3333, 0.3, 2.477), new AmericanOptionData(Option.Type.Put, 40.0, 40.0, 0.0, 0.0488, 0.5833, 0.3, 3.161), new AmericanOptionData(Option.Type.Put, 45.0, 40.0, 0.0, 0.0488, 0.0833, 0.3, 5.059), new AmericanOptionData(Option.Type.Put, 45.0, 40.0, 0.0, 0.0488, 0.3333, 0.3, 5.699), new AmericanOptionData(Option.Type.Put, 45.0, 40.0, 0.0, 0.0488, 0.5833, 0.3, 6.231), new AmericanOptionData(Option.Type.Put, 35.0, 40.0, 0.0, 0.0488, 0.0833, 0.4, 0.247), new AmericanOptionData(Option.Type.Put, 35.0, 40.0, 0.0, 0.0488, 0.3333, 0.4, 1.344), new AmericanOptionData(Option.Type.Put, 35.0, 40.0, 0.0, 0.0488, 0.5833, 0.4, 2.15), new AmericanOptionData(Option.Type.Put, 40.0, 40.0, 0.0, 0.0488, 0.0833, 0.4, 1.767), new AmericanOptionData(Option.Type.Put, 40.0, 40.0, 0.0, 0.0488, 0.3333, 0.4, 3.381), new AmericanOptionData(Option.Type.Put, 40.0, 40.0, 0.0, 0.0488, 0.5833, 0.4, 4.342), new AmericanOptionData(Option.Type.Put, 45.0, 40.0, 0.0, 0.0488, 0.0833, 0.4, 5.288), new AmericanOptionData(Option.Type.Put, 45.0, 40.0, 0.0, 0.0488, 0.3333, 0.4, 6.501), new AmericanOptionData(Option.Type.Put, 45.0, 40.0, 0.0, 0.0488, 0.5833, 0.4, 7.367), new AmericanOptionData(Option.Type.Call, 100.0, 80.0, 0.07, 0.03, 3.0, 0.2, 2.605), new AmericanOptionData(Option.Type.Call, 100.0, 90.0, 0.07, 0.03, 3.0, 0.2, 5.182), new AmericanOptionData(Option.Type.Call, 100.0, 100.0, 0.07, 0.03, 3.0, 0.2, 9.065), new AmericanOptionData(Option.Type.Call, 100.0, 110.0, 0.07, 0.03, 3.0, 0.2, 14.43), new AmericanOptionData(Option.Type.Call, 100.0, 120.0, 0.07, 0.03, 3.0, 0.2, 21.398), new AmericanOptionData(Option.Type.Call, 100.0, 80.0, 0.07, 0.03, 3.0, 0.4, 11.336), new AmericanOptionData(Option.Type.Call, 100.0, 90.0, 0.07, 0.03, 3.0, 0.4, 15.711), new AmericanOptionData(Option.Type.Call, 100.0, 100.0, 0.07, 0.03, 3.0, 0.4, 20.76), new AmericanOptionData(Option.Type.Call, 100.0, 110.0, 0.07, 0.03, 3.0, 0.4, 26.44), new AmericanOptionData(Option.Type.Call, 100.0, 120.0, 0.07, 0.03, 3.0, 0.4, 32.709), new AmericanOptionData(Option.Type.Call, 100.0, 80.0, 0.03, 0.07, 3.0, 0.3, 12.177), new AmericanOptionData(Option.Type.Call, 100.0, 90.0, 0.03, 0.07, 3.0, 0.3, 17.411), new AmericanOptionData(Option.Type.Call, 100.0, 100.0, 0.03, 0.07, 3.0, 0.3, 23.402), new AmericanOptionData(Option.Type.Call, 100.0, 110.0, 0.03, 0.07, 3.0, 0.3, 30.028), new AmericanOptionData(Option.Type.Call, 100.0, 120.0, 0.03, 0.07, 3.0, 0.3, 37.177)};
        QL.info("Testing Ju approximation for American options...");
        Date today = new Settings().evaluationDate();
        Actual360 dc = new Actual360();
        SimpleQuote spot = new SimpleQuote(0.0);
        SimpleQuote qRate = new SimpleQuote(0.0);
        YieldTermStructure qTS = Utilities.flatRate(today, qRate, (DayCounter)dc);
        SimpleQuote rRate = new SimpleQuote(0.0);
        YieldTermStructure rTS = Utilities.flatRate(today, rRate, (DayCounter)dc);
        SimpleQuote vol = new SimpleQuote(0.0);
        BlackVolTermStructure volTS = Utilities.flatVol(today, vol, (DayCounter)dc);
        double tolerance = 0.001;
        for (AmericanOptionData juValue : juValues) {
            PlainVanillaPayoff payoff = new PlainVanillaPayoff(juValue.type, juValue.strike);
            Date exDate = today.add(this.timeToDays(juValue.t));
            AmericanExercise exercise = new AmericanExercise(today, exDate);
            spot.setValue(juValue.s);
            qRate.setValue(juValue.q);
            rRate.setValue(juValue.r);
            vol.setValue(juValue.v);
            BlackScholesMertonProcess stochProcess = new BlackScholesMertonProcess(new Handle<SimpleQuote>(spot), new Handle<YieldTermStructure>(qTS), new Handle<YieldTermStructure>(rTS), new Handle<BlackVolTermStructure>(volTS));
            JuQuadraticApproximationEngine engine = new JuQuadraticApproximationEngine(stochProcess);
            VanillaOption option = new VanillaOption(payoff, exercise);
            option.setPricingEngine(engine);
            double calculated = option.NPV();
            double error = Math.abs(calculated - juValue.result);
            if (!(error > 0.001)) continue;
            this.reportFailure("value", payoff, exercise, juValue.s, juValue.q, juValue.r, today, juValue.v, juValue.result, calculated, error, 0.001);
        }
    }

    @Test
    public void testFdValues() {
        QL.info("Testing finite-difference engine for American options...");
        AmericanOptionData[] juValues = new AmericanOptionData[]{new AmericanOptionData(Option.Type.Put, 35.0, 40.0, 0.0, 0.0488, 0.0833, 0.2, 0.006), new AmericanOptionData(Option.Type.Put, 35.0, 40.0, 0.0, 0.0488, 0.3333, 0.2, 0.201), new AmericanOptionData(Option.Type.Put, 35.0, 40.0, 0.0, 0.0488, 0.5833, 0.2, 0.433), new AmericanOptionData(Option.Type.Put, 40.0, 40.0, 0.0, 0.0488, 0.0833, 0.2, 0.851), new AmericanOptionData(Option.Type.Put, 40.0, 40.0, 0.0, 0.0488, 0.3333, 0.2, 1.576), new AmericanOptionData(Option.Type.Put, 40.0, 40.0, 0.0, 0.0488, 0.5833, 0.2, 1.984), new AmericanOptionData(Option.Type.Put, 45.0, 40.0, 0.0, 0.0488, 0.0833, 0.2, 5.0), new AmericanOptionData(Option.Type.Put, 45.0, 40.0, 0.0, 0.0488, 0.3333, 0.2, 5.084), new AmericanOptionData(Option.Type.Put, 45.0, 40.0, 0.0, 0.0488, 0.5833, 0.2, 5.26), new AmericanOptionData(Option.Type.Put, 35.0, 40.0, 0.0, 0.0488, 0.0833, 0.3, 0.078), new AmericanOptionData(Option.Type.Put, 35.0, 40.0, 0.0, 0.0488, 0.3333, 0.3, 0.697), new AmericanOptionData(Option.Type.Put, 35.0, 40.0, 0.0, 0.0488, 0.5833, 0.3, 1.218), new AmericanOptionData(Option.Type.Put, 40.0, 40.0, 0.0, 0.0488, 0.0833, 0.3, 1.309), new AmericanOptionData(Option.Type.Put, 40.0, 40.0, 0.0, 0.0488, 0.3333, 0.3, 2.477), new AmericanOptionData(Option.Type.Put, 40.0, 40.0, 0.0, 0.0488, 0.5833, 0.3, 3.161), new AmericanOptionData(Option.Type.Put, 45.0, 40.0, 0.0, 0.0488, 0.0833, 0.3, 5.059), new AmericanOptionData(Option.Type.Put, 45.0, 40.0, 0.0, 0.0488, 0.3333, 0.3, 5.699), new AmericanOptionData(Option.Type.Put, 45.0, 40.0, 0.0, 0.0488, 0.5833, 0.3, 6.231), new AmericanOptionData(Option.Type.Put, 35.0, 40.0, 0.0, 0.0488, 0.0833, 0.4, 0.247), new AmericanOptionData(Option.Type.Put, 35.0, 40.0, 0.0, 0.0488, 0.3333, 0.4, 1.344), new AmericanOptionData(Option.Type.Put, 35.0, 40.0, 0.0, 0.0488, 0.5833, 0.4, 2.15), new AmericanOptionData(Option.Type.Put, 40.0, 40.0, 0.0, 0.0488, 0.0833, 0.4, 1.767), new AmericanOptionData(Option.Type.Put, 40.0, 40.0, 0.0, 0.0488, 0.3333, 0.4, 3.381), new AmericanOptionData(Option.Type.Put, 40.0, 40.0, 0.0, 0.0488, 0.5833, 0.4, 4.342), new AmericanOptionData(Option.Type.Put, 45.0, 40.0, 0.0, 0.0488, 0.0833, 0.4, 5.288), new AmericanOptionData(Option.Type.Put, 45.0, 40.0, 0.0, 0.0488, 0.3333, 0.4, 6.501), new AmericanOptionData(Option.Type.Put, 45.0, 40.0, 0.0, 0.0488, 0.5833, 0.4, 7.367), new AmericanOptionData(Option.Type.Call, 100.0, 80.0, 0.07, 0.03, 3.0, 0.2, 2.605), new AmericanOptionData(Option.Type.Call, 100.0, 90.0, 0.07, 0.03, 3.0, 0.2, 5.182), new AmericanOptionData(Option.Type.Call, 100.0, 100.0, 0.07, 0.03, 3.0, 0.2, 9.065), new AmericanOptionData(Option.Type.Call, 100.0, 110.0, 0.07, 0.03, 3.0, 0.2, 14.43), new AmericanOptionData(Option.Type.Call, 100.0, 120.0, 0.07, 0.03, 3.0, 0.2, 21.398), new AmericanOptionData(Option.Type.Call, 100.0, 80.0, 0.07, 0.03, 3.0, 0.4, 11.336), new AmericanOptionData(Option.Type.Call, 100.0, 90.0, 0.07, 0.03, 3.0, 0.4, 15.711), new AmericanOptionData(Option.Type.Call, 100.0, 100.0, 0.07, 0.03, 3.0, 0.4, 20.76), new AmericanOptionData(Option.Type.Call, 100.0, 110.0, 0.07, 0.03, 3.0, 0.4, 26.44), new AmericanOptionData(Option.Type.Call, 100.0, 120.0, 0.07, 0.03, 3.0, 0.4, 32.709), new AmericanOptionData(Option.Type.Call, 100.0, 80.0, 0.03, 0.07, 3.0, 0.3, 12.177), new AmericanOptionData(Option.Type.Call, 100.0, 90.0, 0.03, 0.07, 3.0, 0.3, 17.411), new AmericanOptionData(Option.Type.Call, 100.0, 100.0, 0.03, 0.07, 3.0, 0.3, 23.402), new AmericanOptionData(Option.Type.Call, 100.0, 110.0, 0.03, 0.07, 3.0, 0.3, 30.028), new AmericanOptionData(Option.Type.Call, 100.0, 120.0, 0.03, 0.07, 3.0, 0.3, 37.177)};
        Date today = new Settings().evaluationDate();
        double tolerance = 0.08;
        for (AmericanOptionData juValue : juValues) {
            Actual360 dc = new Actual360();
            SimpleQuote spot = new SimpleQuote(0.0);
            SimpleQuote qRate = new SimpleQuote(0.0);
            YieldTermStructure qTS = Utilities.flatRate(today, qRate, (DayCounter)dc);
            SimpleQuote rRate = new SimpleQuote(0.0);
            YieldTermStructure rTS = Utilities.flatRate(today, rRate, (DayCounter)dc);
            SimpleQuote vol = new SimpleQuote(0.0);
            BlackVolTermStructure volTS = Utilities.flatVol(today, vol, (DayCounter)dc);
            PlainVanillaPayoff payoff = new PlainVanillaPayoff(juValue.type, juValue.strike);
            Date exDate = today.add(this.timeToDays(juValue.t));
            AmericanExercise exercise = new AmericanExercise(today, exDate);
            spot.setValue(juValue.s);
            qRate.setValue(juValue.q);
            rRate.setValue(juValue.r);
            vol.setValue(juValue.v);
            BlackScholesMertonProcess stochProcess = new BlackScholesMertonProcess(new Handle<SimpleQuote>(spot), new Handle<YieldTermStructure>(qTS), new Handle<YieldTermStructure>(rTS), new Handle<BlackVolTermStructure>(volTS));
            FDAmericanEngine engine = new FDAmericanEngine(stochProcess, 100, 100);
            VanillaOption option = new VanillaOption(payoff, exercise);
            option.setPricingEngine(engine);
            double calculated = option.NPV();
            double error = Math.abs(calculated - juValue.result);
            if (!(error > 0.08)) continue;
            this.reportFailure("value", payoff, exercise, juValue.s, juValue.q, juValue.r, today, juValue.v, juValue.result, calculated, error, 0.08);
        }
    }

    @Test
    public void testFdAmericanGreeks() {
        QL.info("Testing Greeks (delta, gamma, theta for American options using FDAmericanEngine");
        this.testFdGreeks(FDAmericanEngine.class);
    }

    @Test
    public void testFdShoutGreeks() {
        QL.info("Testing Greeks (delta, gamma, theta for American options using FDShoutEngine");
        this.testFdGreeks(FDShoutEngine.class);
    }

    private void testFdGreeks(Class<? extends PricingEngine> klass) {
        HashMap<String, Double> calculated = new HashMap<String, Double>();
        HashMap<String, Double> expected = new HashMap<String, Double>();
        HashMap<String, Double> tolerance = new HashMap<String, Double>();
        tolerance.put("delta", 7.0E-4);
        tolerance.put("gamma", 2.0E-4);
        tolerance.put("theta", 1.0E-4);
        Option.Type[] types = new Option.Type[]{Option.Type.Call, Option.Type.Put};
        double[] strikes = new double[]{50.0, 99.5, 100.0, 100.5, 150.0};
        double[] underlyings = new double[]{100.0};
        double[] qRates = new double[]{0.04, 0.05, 0.06};
        double[] rRates = new double[]{0.01, 0.05, 0.15};
        int[] years = new int[]{1, 2};
        double[] vols = new double[]{0.11, 0.5, 1.2};
        Actual360 dc = new Actual360();
        Date today = new Settings().evaluationDate();
        SimpleQuote spot = new SimpleQuote(0.0);
        SimpleQuote qRate = new SimpleQuote(0.0);
        YieldTermStructure qTS = Utilities.flatRate(today, qRate, (DayCounter)dc);
        SimpleQuote rRate = new SimpleQuote(0.0);
        YieldTermStructure rTS = Utilities.flatRate(today, rRate, (DayCounter)dc);
        SimpleQuote vol = new SimpleQuote(0.0);
        BlackVolTermStructure volTS = Utilities.flatVol(today, vol, (DayCounter)dc);
        for (Option.Type type : types) {
            for (double strike : strikes) {
                for (int year : years) {
                    Date exDate = today.add(new Period(year, TimeUnit.Years));
                    AmericanExercise exercise = new AmericanExercise(today, exDate);
                    PlainVanillaPayoff payoff = new PlainVanillaPayoff(type, strike);
                    BlackScholesMertonProcess stochProcess = new BlackScholesMertonProcess(new Handle<SimpleQuote>(spot), new Handle<YieldTermStructure>(qTS), new Handle<YieldTermStructure>(rTS), new Handle<BlackVolTermStructure>(volTS));
                    PricingEngine engine = null;
                    try {
                        Constructor<? extends PricingEngine> c = klass.getConstructor(GeneralizedBlackScholesProcess.class);
                        engine = c.newInstance(stochProcess);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        Assert.fail((String)"failed to create pricing engine");
                    }
                    VanillaOption option = new VanillaOption(payoff, exercise);
                    option.setPricingEngine(engine);
                    for (double u : underlyings) {
                        for (double q : qRates) {
                            for (double r : rRates) {
                                for (double v : vols) {
                                    spot.setValue(u);
                                    qRate.setValue(q);
                                    rRate.setValue(r);
                                    vol.setValue(v);
                                    double value = option.NPV();
                                    double delta = option.delta();
                                    double gamma = option.gamma();
                                    calculated.put("delta", delta);
                                    calculated.put("gamma", gamma);
                                    if (!(value > spot.value() * 1.0E-5)) continue;
                                    double du = u * 1.0E-4;
                                    spot.setValue(u + du);
                                    double value_p = option.NPV();
                                    double delta_p = option.delta();
                                    spot.setValue(u - du);
                                    double value_m = option.NPV();
                                    double delta_m = option.delta();
                                    spot.setValue(u);
                                    expected.put("delta", (value_p - value_m) / (2.0 * du));
                                    expected.put("gamma", (delta_p - delta_m) / (2.0 * du));
                                    for (Map.Entry greek : calculated.entrySet()) {
                                        double expct = (Double)expected.get(greek.getKey());
                                        double calcl = (Double)calculated.get(greek.getKey());
                                        double tol = (Double)tolerance.get(greek.getKey());
                                        double error = Utilities.relativeError(expct, calcl, u);
                                        if (!(error > tol)) continue;
                                        this.reportFailure((String)greek.getKey(), payoff, exercise, u, q, r, today, v, expct, calcl, error, tol);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    private void reportFailure(String greekName, StrikedTypePayoff payoff, Exercise exercise, double s, double q, double r, Date today, double v, double expected, double calculated, double error, double tolerance) {
        StringBuilder sb = new StringBuilder();
        sb.append((Object)exercise.type()).append(' ');
        sb.append((Object)payoff.optionType()).append(" option with ").append(payoff.getClass().getSimpleName()).append(" payoff:\n");
        sb.append("    spot value:     ").append(s).append('\n');
        sb.append("    strike:         ").append(payoff.strike()).append('\n');
        sb.append("    dividend yield: ").append(q).append('\n');
        sb.append("    risk-free rate: ").append(r).append('\n');
        sb.append("    reference date: ").append(today).append('\n');
        sb.append("    maturity:       ").append(exercise.lastDate()).append('\n');
        sb.append("    volatility:     ").append(v).append('\n');
        sb.append("    expected ").append(greekName).append(":    ").append(expected).append('\n');
        sb.append("    calculated ").append(greekName).append(":  ").append(calculated).append('\n');
        sb.append("    error:     ").append(error).append('\n');
        sb.append("    tolerance: ").append(tolerance).append('\n');
        Assert.fail((String)sb.toString());
    }

    private int timeToDays(double t) {
        return (int)(t * 360.0 + 0.5);
    }

    private class AmericanOptionData {
        private final Option.Type type;
        private final double strike;
        private final double s;
        private final double q;
        private final double r;
        private final double t;
        private final double v;
        private final double result;

        public AmericanOptionData(Option.Type type, double strike, double s, double q, double r, double t, double v, double result) {
            this.type = type;
            this.strike = strike;
            this.s = s;
            this.q = q;
            this.r = r;
            this.t = t;
            this.v = v;
            this.result = result;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("Type: " + (Object)((Object)this.type));
            builder.append(" Strike: " + this.strike);
            builder.append(" Spot: " + this.s);
            builder.append(" DividendYield: " + this.q);
            builder.append(" Riskfree: " + this.r);
            builder.append(" TTm: " + this.t);
            builder.append(" Vol: " + this.v);
            builder.append(" result: " + this.result);
            return builder.toString();
        }
    }
}

