/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.testsuite.calendars;

import java.util.ArrayList;
import org.jquantlib.lang.annotation.QualityAssurance;
import org.jquantlib.testsuite.calendars.CalendarUtil;
import org.jquantlib.time.Date;
import org.jquantlib.time.Month;
import org.jquantlib.time.calendars.UnitedStates;
import org.junit.Test;

@QualityAssurance(quality=QualityAssurance.Quality.Q3_DOCUMENTATION, version=QualityAssurance.Version.V097, reviewers={"Richard Gomes"})
public class UnitedStatesCalendarTest {
    public UnitedStatesCalendarTest() {
        System.out.println("::::: " + this.getClass().getSimpleName() + " :::::");
    }

    @Test
    public void testUnitedStatesNYSEYear2004() {
        int year = 2004;
        System.out.println("Testing " + (Object)((Object)UnitedStates.Market.NYSE) + " holiday list for the year " + 2004 + "...");
        ArrayList<Date> expectedHol = new ArrayList<Date>();
        expectedHol.add(new Date(1, Month.January, 2004));
        expectedHol.add(new Date(19, Month.January, 2004));
        expectedHol.add(new Date(16, Month.February, 2004));
        expectedHol.add(new Date(9, Month.April, 2004));
        expectedHol.add(new Date(31, Month.May, 2004));
        expectedHol.add(new Date(5, Month.July, 2004));
        expectedHol.add(new Date(6, Month.September, 2004));
        expectedHol.add(new Date(25, Month.November, 2004));
        expectedHol.add(new Date(24, Month.December, 2004));
        expectedHol.add(new Date(11, Month.June, 2004));
        UnitedStates nyse = new UnitedStates(UnitedStates.Market.NYSE);
        CalendarUtil cbt = new CalendarUtil();
        cbt.checkHolidayList(expectedHol, nyse, 2004);
    }

    @Test
    public void testUnitedStatesNYSEYear2005() {
        int year = 2005;
        System.out.println("Testing " + (Object)((Object)UnitedStates.Market.NYSE) + " holiday list for the year " + 2005 + "...");
        ArrayList<Date> expectedHol = new ArrayList<Date>();
        expectedHol.add(new Date(17, Month.January, 2005));
        expectedHol.add(new Date(21, Month.February, 2005));
        expectedHol.add(new Date(25, Month.March, 2005));
        expectedHol.add(new Date(30, Month.May, 2005));
        expectedHol.add(new Date(4, Month.July, 2005));
        expectedHol.add(new Date(5, Month.September, 2005));
        expectedHol.add(new Date(24, Month.November, 2005));
        expectedHol.add(new Date(26, Month.December, 2005));
        UnitedStates nyse = new UnitedStates(UnitedStates.Market.NYSE);
        CalendarUtil cbt = new CalendarUtil();
        cbt.checkHolidayList(expectedHol, nyse, 2005);
    }

    @Test
    public void testUnitedStatesNYSEYear2006() {
        int year = 2006;
        System.out.println("Testing " + (Object)((Object)UnitedStates.Market.NYSE) + " holiday list for the year " + 2006 + "...");
        ArrayList<Date> expectedHol = new ArrayList<Date>();
        expectedHol.add(new Date(2, Month.January, 2006));
        expectedHol.add(new Date(16, Month.January, 2006));
        expectedHol.add(new Date(20, Month.February, 2006));
        expectedHol.add(new Date(14, Month.April, 2006));
        expectedHol.add(new Date(29, Month.May, 2006));
        expectedHol.add(new Date(4, Month.July, 2006));
        expectedHol.add(new Date(4, Month.September, 2006));
        expectedHol.add(new Date(23, Month.November, 2006));
        expectedHol.add(new Date(25, Month.December, 2006));
        UnitedStates nyse = new UnitedStates(UnitedStates.Market.NYSE);
        CalendarUtil cbt = new CalendarUtil();
        cbt.checkHolidayList(expectedHol, nyse, 2006);
    }

    @Test
    public void testUnitedStatesNYSEYear2007() {
        int year = 2007;
        System.out.println("Testing " + (Object)((Object)UnitedStates.Market.NYSE) + " holiday list for the year " + 2007 + "...");
        ArrayList<Date> expectedHol = new ArrayList<Date>();
        expectedHol.add(new Date(1, Month.January, 2007));
        expectedHol.add(new Date(2, Month.January, 2007));
        expectedHol.add(new Date(15, Month.January, 2007));
        expectedHol.add(new Date(19, Month.February, 2007));
        expectedHol.add(new Date(6, Month.April, 2007));
        expectedHol.add(new Date(28, Month.May, 2007));
        expectedHol.add(new Date(4, Month.July, 2007));
        expectedHol.add(new Date(3, Month.September, 2007));
        expectedHol.add(new Date(22, Month.November, 2007));
        expectedHol.add(new Date(25, Month.December, 2007));
        UnitedStates nyse = new UnitedStates(UnitedStates.Market.NYSE);
        CalendarUtil cbt = new CalendarUtil();
        cbt.checkHolidayList(expectedHol, nyse, 2007);
    }

    @Test
    public void testUnitedStatesNYSEYear2008() {
        int year = 2008;
        System.out.println("Testing " + (Object)((Object)UnitedStates.Market.NYSE) + " holiday list for the year " + 2008 + "...");
        ArrayList<Date> expectedHol = new ArrayList<Date>();
        expectedHol.add(new Date(1, Month.January, 2008));
        expectedHol.add(new Date(21, Month.January, 2008));
        expectedHol.add(new Date(18, Month.February, 2008));
        expectedHol.add(new Date(21, Month.March, 2008));
        expectedHol.add(new Date(26, Month.May, 2008));
        expectedHol.add(new Date(4, Month.July, 2008));
        expectedHol.add(new Date(1, Month.September, 2008));
        expectedHol.add(new Date(27, Month.November, 2008));
        expectedHol.add(new Date(25, Month.December, 2008));
        UnitedStates nyse = new UnitedStates(UnitedStates.Market.NYSE);
        CalendarUtil cbt = new CalendarUtil();
        cbt.checkHolidayList(expectedHol, nyse, 2008);
    }

    @Test
    public void testUnitedStatesNYSEYear2009() {
        int year = 2009;
        System.out.println("Testing " + (Object)((Object)UnitedStates.Market.NYSE) + " holiday list for the year " + 2009 + "...");
        ArrayList<Date> expectedHol = new ArrayList<Date>();
        expectedHol.add(new Date(1, Month.January, 2009));
        expectedHol.add(new Date(19, Month.January, 2009));
        expectedHol.add(new Date(16, Month.February, 2009));
        expectedHol.add(new Date(10, Month.April, 2009));
        expectedHol.add(new Date(25, Month.May, 2009));
        expectedHol.add(new Date(3, Month.July, 2009));
        expectedHol.add(new Date(7, Month.September, 2009));
        expectedHol.add(new Date(26, Month.November, 2009));
        expectedHol.add(new Date(25, Month.December, 2009));
        UnitedStates nyse = new UnitedStates(UnitedStates.Market.NYSE);
        CalendarUtil cbt = new CalendarUtil();
        cbt.checkHolidayList(expectedHol, nyse, 2009);
    }

    @Test
    public void testUnitedStatesNYSEYear2010() {
        int year = 2010;
        System.out.println("Testing " + (Object)((Object)UnitedStates.Market.NYSE) + " holiday list for the year " + 2010 + "...");
        ArrayList<Date> expectedHol = new ArrayList<Date>();
        expectedHol.add(new Date(1, Month.January, 2010));
        expectedHol.add(new Date(18, Month.January, 2010));
        expectedHol.add(new Date(15, Month.February, 2010));
        expectedHol.add(new Date(2, Month.April, 2010));
        expectedHol.add(new Date(31, Month.May, 2010));
        expectedHol.add(new Date(5, Month.July, 2010));
        expectedHol.add(new Date(6, Month.September, 2010));
        expectedHol.add(new Date(25, Month.November, 2010));
        expectedHol.add(new Date(24, Month.December, 2010));
        UnitedStates nyse = new UnitedStates(UnitedStates.Market.NYSE);
        CalendarUtil cbt = new CalendarUtil();
        cbt.checkHolidayList(expectedHol, nyse, 2010);
    }

    @Test
    public void testUnitedStatesGBondYear2004() {
        int year = 2004;
        System.out.println("Testing " + (Object)((Object)UnitedStates.Market.GOVERNMENTBOND) + " holiday list for the year " + 2004 + "...");
        ArrayList<Date> expectedHol = new ArrayList<Date>();
        expectedHol.add(new Date(1, Month.January, 2004));
        expectedHol.add(new Date(19, Month.January, 2004));
        expectedHol.add(new Date(16, Month.February, 2004));
        expectedHol.add(new Date(9, Month.April, 2004));
        expectedHol.add(new Date(31, Month.May, 2004));
        expectedHol.add(new Date(5, Month.July, 2004));
        expectedHol.add(new Date(6, Month.September, 2004));
        expectedHol.add(new Date(11, Month.October, 2004));
        expectedHol.add(new Date(25, Month.November, 2004));
        expectedHol.add(new Date(11, Month.November, 2004));
        expectedHol.add(new Date(24, Month.December, 2004));
        UnitedStates govtBond = new UnitedStates(UnitedStates.Market.GOVERNMENTBOND);
        CalendarUtil cbt = new CalendarUtil();
        cbt.checkHolidayList(expectedHol, govtBond, 2004);
    }

    @Test
    public void testUnitedStatesGBondYear2005() {
        int year = 2005;
        System.out.println("Testing " + (Object)((Object)UnitedStates.Market.GOVERNMENTBOND) + " holiday list for the year " + 2005 + "...");
        ArrayList<Date> expectedHol = new ArrayList<Date>();
        expectedHol.add(new Date(17, Month.January, 2005));
        expectedHol.add(new Date(21, Month.February, 2005));
        expectedHol.add(new Date(25, Month.March, 2005));
        expectedHol.add(new Date(30, Month.May, 2005));
        expectedHol.add(new Date(4, Month.July, 2005));
        expectedHol.add(new Date(5, Month.September, 2005));
        expectedHol.add(new Date(10, Month.October, 2005));
        expectedHol.add(new Date(11, Month.November, 2005));
        expectedHol.add(new Date(24, Month.November, 2005));
        expectedHol.add(new Date(26, Month.December, 2005));
        UnitedStates govtBond = new UnitedStates(UnitedStates.Market.GOVERNMENTBOND);
        CalendarUtil cbt = new CalendarUtil();
        cbt.checkHolidayList(expectedHol, govtBond, 2005);
    }

    @Test
    public void testUnitedStatesGBondYear2006() {
        int year = 2006;
        System.out.println("Testing " + (Object)((Object)UnitedStates.Market.GOVERNMENTBOND) + " holiday list for the year " + 2006 + "...");
        ArrayList<Date> expectedHol = new ArrayList<Date>();
        expectedHol.add(new Date(2, Month.January, 2006));
        expectedHol.add(new Date(16, Month.January, 2006));
        expectedHol.add(new Date(20, Month.February, 2006));
        expectedHol.add(new Date(14, Month.April, 2006));
        expectedHol.add(new Date(29, Month.May, 2006));
        expectedHol.add(new Date(4, Month.July, 2006));
        expectedHol.add(new Date(4, Month.September, 2006));
        expectedHol.add(new Date(9, Month.October, 2006));
        expectedHol.add(new Date(10, Month.November, 2006));
        expectedHol.add(new Date(23, Month.November, 2006));
        expectedHol.add(new Date(25, Month.December, 2006));
        UnitedStates govtBond = new UnitedStates(UnitedStates.Market.GOVERNMENTBOND);
        CalendarUtil cbt = new CalendarUtil();
        cbt.checkHolidayList(expectedHol, govtBond, 2006);
    }

    @Test
    public void testUnitedStatesGBondYear2007() {
        int year = 2007;
        System.out.println("Testing " + (Object)((Object)UnitedStates.Market.GOVERNMENTBOND) + " holiday list for the year " + 2007 + "...");
        ArrayList<Date> expectedHol = new ArrayList<Date>();
        expectedHol.add(new Date(1, Month.January, 2007));
        expectedHol.add(new Date(15, Month.January, 2007));
        expectedHol.add(new Date(19, Month.February, 2007));
        expectedHol.add(new Date(6, Month.April, 2007));
        expectedHol.add(new Date(28, Month.May, 2007));
        expectedHol.add(new Date(4, Month.July, 2007));
        expectedHol.add(new Date(3, Month.September, 2007));
        expectedHol.add(new Date(8, Month.October, 2007));
        expectedHol.add(new Date(12, Month.November, 2007));
        expectedHol.add(new Date(22, Month.November, 2007));
        expectedHol.add(new Date(25, Month.December, 2007));
        UnitedStates govtBond = new UnitedStates(UnitedStates.Market.GOVERNMENTBOND);
        CalendarUtil cbt = new CalendarUtil();
        cbt.checkHolidayList(expectedHol, govtBond, 2007);
    }

    @Test
    public void testUnitedStatesGBondYear2008() {
        int year = 2008;
        System.out.println("Testing " + (Object)((Object)UnitedStates.Market.GOVERNMENTBOND) + " holiday list for the year " + 2008 + "...");
        ArrayList<Date> expectedHol = new ArrayList<Date>();
        expectedHol.add(new Date(1, Month.January, 2008));
        expectedHol.add(new Date(21, Month.January, 2008));
        expectedHol.add(new Date(18, Month.February, 2008));
        expectedHol.add(new Date(21, Month.March, 2008));
        expectedHol.add(new Date(26, Month.May, 2008));
        expectedHol.add(new Date(4, Month.July, 2008));
        expectedHol.add(new Date(1, Month.September, 2008));
        expectedHol.add(new Date(13, Month.October, 2008));
        expectedHol.add(new Date(11, Month.November, 2008));
        expectedHol.add(new Date(27, Month.November, 2008));
        expectedHol.add(new Date(25, Month.December, 2008));
        UnitedStates govtBond = new UnitedStates(UnitedStates.Market.GOVERNMENTBOND);
        CalendarUtil cbt = new CalendarUtil();
        cbt.checkHolidayList(expectedHol, govtBond, 2008);
    }

    @Test
    public void testUnitedStatesGBondYear2009() {
        int year = 2009;
        System.out.println("Testing " + (Object)((Object)UnitedStates.Market.GOVERNMENTBOND) + " holiday list for the year " + 2009 + "...");
        ArrayList<Date> expectedHol = new ArrayList<Date>();
        expectedHol.add(new Date(1, Month.January, 2009));
        expectedHol.add(new Date(19, Month.January, 2009));
        expectedHol.add(new Date(16, Month.February, 2009));
        expectedHol.add(new Date(10, Month.April, 2009));
        expectedHol.add(new Date(25, Month.May, 2009));
        expectedHol.add(new Date(3, Month.July, 2009));
        expectedHol.add(new Date(7, Month.September, 2009));
        expectedHol.add(new Date(12, Month.October, 2009));
        expectedHol.add(new Date(11, Month.November, 2009));
        expectedHol.add(new Date(26, Month.November, 2009));
        expectedHol.add(new Date(25, Month.December, 2009));
        UnitedStates govtBond = new UnitedStates(UnitedStates.Market.GOVERNMENTBOND);
        CalendarUtil cbt = new CalendarUtil();
        cbt.checkHolidayList(expectedHol, govtBond, 2009);
    }

    @Test
    public void testUnitedStatesGBondYear2010() {
        int year = 2010;
        System.out.println("Testing " + (Object)((Object)UnitedStates.Market.GOVERNMENTBOND) + " holiday list for the year " + 2010 + "...");
        ArrayList<Date> expectedHol = new ArrayList<Date>();
        expectedHol.add(new Date(1, Month.January, 2010));
        expectedHol.add(new Date(18, Month.January, 2010));
        expectedHol.add(new Date(15, Month.February, 2010));
        expectedHol.add(new Date(2, Month.April, 2010));
        expectedHol.add(new Date(31, Month.May, 2010));
        expectedHol.add(new Date(5, Month.July, 2010));
        expectedHol.add(new Date(6, Month.September, 2010));
        expectedHol.add(new Date(11, Month.October, 2010));
        expectedHol.add(new Date(11, Month.November, 2010));
        expectedHol.add(new Date(25, Month.November, 2010));
        expectedHol.add(new Date(24, Month.December, 2010));
        UnitedStates govtBond = new UnitedStates(UnitedStates.Market.GOVERNMENTBOND);
        CalendarUtil cbt = new CalendarUtil();
        cbt.checkHolidayList(expectedHol, govtBond, 2010);
    }

    @Test
    public void testUnitedStatesNERCYear2004() {
        int year = 2004;
        System.out.println("Testing " + (Object)((Object)UnitedStates.Market.NERC) + " holiday list for the year " + 2004 + "...");
        ArrayList<Date> expectedHol = new ArrayList<Date>();
        expectedHol.add(new Date(1, Month.January, 2004));
        expectedHol.add(new Date(31, Month.May, 2004));
        expectedHol.add(new Date(5, Month.July, 2004));
        expectedHol.add(new Date(6, Month.September, 2004));
        expectedHol.add(new Date(25, Month.November, 2004));
        UnitedStates nerc = new UnitedStates(UnitedStates.Market.NERC);
        CalendarUtil cbt = new CalendarUtil();
        cbt.checkHolidayList(expectedHol, nerc, 2004);
    }

    @Test
    public void testUnitedStatesNERCYear2005() {
        int year = 2005;
        System.out.println("Testing " + (Object)((Object)UnitedStates.Market.NERC) + " holiday list for the year " + 2005 + "...");
        ArrayList<Date> expectedHol = new ArrayList<Date>();
        expectedHol.add(new Date(30, Month.May, 2005));
        expectedHol.add(new Date(4, Month.July, 2005));
        expectedHol.add(new Date(5, Month.September, 2005));
        expectedHol.add(new Date(24, Month.November, 2005));
        expectedHol.add(new Date(26, Month.December, 2005));
        UnitedStates nerc = new UnitedStates(UnitedStates.Market.NERC);
        CalendarUtil cbt = new CalendarUtil();
        cbt.checkHolidayList(expectedHol, nerc, 2005);
    }

    @Test
    public void testUnitedStatesNERCYear2006() {
        int year = 2006;
        System.out.println("Testing " + (Object)((Object)UnitedStates.Market.NERC) + " holiday list for the year " + 2006 + "...");
        ArrayList<Date> expectedHol = new ArrayList<Date>();
        expectedHol.add(new Date(2, Month.January, 2006));
        expectedHol.add(new Date(29, Month.May, 2006));
        expectedHol.add(new Date(4, Month.July, 2006));
        expectedHol.add(new Date(23, Month.November, 2006));
        expectedHol.add(new Date(4, Month.September, 2006));
        expectedHol.add(new Date(25, Month.December, 2006));
        UnitedStates nerc = new UnitedStates(UnitedStates.Market.NERC);
        CalendarUtil cbt = new CalendarUtil();
        cbt.checkHolidayList(expectedHol, nerc, 2006);
    }

    @Test
    public void testUnitedStatesNERCYear2007() {
        int year = 2007;
        System.out.println("Testing " + (Object)((Object)UnitedStates.Market.NERC) + " holiday list for the year " + 2007 + "...");
        ArrayList<Date> expectedHol = new ArrayList<Date>();
        expectedHol.add(new Date(1, Month.January, 2007));
        expectedHol.add(new Date(28, Month.May, 2007));
        expectedHol.add(new Date(4, Month.July, 2007));
        expectedHol.add(new Date(3, Month.September, 2007));
        expectedHol.add(new Date(22, Month.November, 2007));
        expectedHol.add(new Date(25, Month.December, 2007));
        UnitedStates nerc = new UnitedStates(UnitedStates.Market.NERC);
        CalendarUtil cbt = new CalendarUtil();
        cbt.checkHolidayList(expectedHol, nerc, 2007);
    }

    @Test
    public void testUnitedStatesNERCYear2008() {
        int year = 2008;
        System.out.println("Testing " + (Object)((Object)UnitedStates.Market.NERC) + " holiday list for the year " + 2008 + "...");
        ArrayList<Date> expectedHol = new ArrayList<Date>();
        expectedHol.add(new Date(1, Month.January, 2008));
        expectedHol.add(new Date(26, Month.May, 2008));
        expectedHol.add(new Date(4, Month.July, 2008));
        expectedHol.add(new Date(1, Month.September, 2008));
        expectedHol.add(new Date(27, Month.November, 2008));
        expectedHol.add(new Date(25, Month.December, 2008));
        UnitedStates nerc = new UnitedStates(UnitedStates.Market.NERC);
        CalendarUtil cbt = new CalendarUtil();
        cbt.checkHolidayList(expectedHol, nerc, 2008);
    }

    @Test
    public void testUnitedStatesNERCYear2009() {
        int year = 2009;
        System.out.println("Testing " + (Object)((Object)UnitedStates.Market.NERC) + " holiday list for the year " + 2009 + "...");
        ArrayList<Date> expectedHol = new ArrayList<Date>();
        expectedHol.add(new Date(1, Month.January, 2009));
        expectedHol.add(new Date(25, Month.May, 2009));
        expectedHol.add(new Date(7, Month.September, 2009));
        expectedHol.add(new Date(26, Month.November, 2009));
        expectedHol.add(new Date(25, Month.December, 2009));
        UnitedStates nerc = new UnitedStates(UnitedStates.Market.NERC);
        CalendarUtil cbt = new CalendarUtil();
        cbt.checkHolidayList(expectedHol, nerc, 2009);
    }

    @Test
    public void testUnitedStatesNERCYear2010() {
        int year = 2010;
        System.out.println("Testing " + (Object)((Object)UnitedStates.Market.NERC) + " holiday list for the year " + 2010 + "...");
        ArrayList<Date> expectedHol = new ArrayList<Date>();
        expectedHol.add(new Date(1, Month.January, 2010));
        expectedHol.add(new Date(31, Month.May, 2010));
        expectedHol.add(new Date(5, Month.July, 2010));
        expectedHol.add(new Date(6, Month.September, 2010));
        expectedHol.add(new Date(25, Month.November, 2010));
        UnitedStates nerc = new UnitedStates(UnitedStates.Market.NERC);
        CalendarUtil cbt = new CalendarUtil();
        cbt.checkHolidayList(expectedHol, nerc, 2010);
    }

    public void testUnitedStatesSettlementYear2004() {
        int year = 2004;
        System.out.println("Testing " + (Object)((Object)UnitedStates.Market.SETTLEMENT) + " holiday list for the year " + 2004 + "...");
        ArrayList<Date> expectedHol = new ArrayList<Date>();
        expectedHol.add(new Date(1, Month.January, 2004));
        expectedHol.add(new Date(2, Month.January, 2004));
        expectedHol.add(new Date(3, Month.January, 2004));
        expectedHol.add(new Date(19, Month.January, 2004));
        expectedHol.add(new Date(16, Month.February, 2004));
        expectedHol.add(new Date(9, Month.April, 2004));
        expectedHol.add(new Date(31, Month.May, 2004));
        expectedHol.add(new Date(4, Month.July, 2004));
        expectedHol.add(new Date(6, Month.September, 2004));
        expectedHol.add(new Date(11, Month.October, 2004));
        expectedHol.add(new Date(25, Month.November, 2004));
        expectedHol.add(new Date(11, Month.November, 2004));
        expectedHol.add(new Date(24, Month.December, 2004));
        expectedHol.add(new Date(25, Month.December, 2004));
        UnitedStates settlement = new UnitedStates(UnitedStates.Market.SETTLEMENT);
        CalendarUtil cbt = new CalendarUtil();
        cbt.checkHolidayList(expectedHol, settlement, 2004);
    }

    @Test
    public void testUnitedStatesSettlementYear2005() {
        int year = 2005;
        System.out.println("Testing " + (Object)((Object)UnitedStates.Market.SETTLEMENT) + " holiday list for the year " + 2005 + "...");
        ArrayList<Date> expectedHol = new ArrayList<Date>();
        expectedHol.add(new Date(17, Month.January, 2005));
        expectedHol.add(new Date(21, Month.February, 2005));
        expectedHol.add(new Date(30, Month.May, 2005));
        expectedHol.add(new Date(4, Month.July, 2005));
        expectedHol.add(new Date(5, Month.September, 2005));
        expectedHol.add(new Date(10, Month.October, 2005));
        expectedHol.add(new Date(11, Month.November, 2005));
        expectedHol.add(new Date(24, Month.November, 2005));
        expectedHol.add(new Date(26, Month.December, 2005));
        UnitedStates settlement = new UnitedStates(UnitedStates.Market.SETTLEMENT);
        CalendarUtil cbt = new CalendarUtil();
        cbt.checkHolidayList(expectedHol, settlement, 2005);
    }

    @Test
    public void testUnitedStatesSettlementYear2006() {
        int year = 2006;
        System.out.println("Testing " + (Object)((Object)UnitedStates.Market.SETTLEMENT) + " holiday list for the year " + 2006 + "...");
        ArrayList<Date> expectedHol = new ArrayList<Date>();
        expectedHol.add(new Date(2, Month.January, 2006));
        expectedHol.add(new Date(16, Month.January, 2006));
        expectedHol.add(new Date(20, Month.February, 2006));
        expectedHol.add(new Date(29, Month.May, 2006));
        expectedHol.add(new Date(4, Month.July, 2006));
        expectedHol.add(new Date(4, Month.September, 2006));
        expectedHol.add(new Date(9, Month.October, 2006));
        expectedHol.add(new Date(10, Month.November, 2006));
        expectedHol.add(new Date(23, Month.November, 2006));
        expectedHol.add(new Date(25, Month.December, 2006));
        UnitedStates settlement = new UnitedStates(UnitedStates.Market.SETTLEMENT);
        CalendarUtil cbt = new CalendarUtil();
        cbt.checkHolidayList(expectedHol, settlement, 2006);
    }

    @Test
    public void testUnitedStatesSettlementYear2007() {
        int year = 2007;
        System.out.println("Testing " + (Object)((Object)UnitedStates.Market.SETTLEMENT) + " holiday list for the year " + 2007 + "...");
        ArrayList<Date> expectedHol = new ArrayList<Date>();
        expectedHol.add(new Date(1, Month.January, 2007));
        expectedHol.add(new Date(15, Month.January, 2007));
        expectedHol.add(new Date(19, Month.February, 2007));
        expectedHol.add(new Date(28, Month.May, 2007));
        expectedHol.add(new Date(4, Month.July, 2007));
        expectedHol.add(new Date(3, Month.September, 2007));
        expectedHol.add(new Date(8, Month.October, 2007));
        expectedHol.add(new Date(12, Month.November, 2007));
        expectedHol.add(new Date(22, Month.November, 2007));
        expectedHol.add(new Date(25, Month.December, 2007));
        UnitedStates settlement = new UnitedStates(UnitedStates.Market.SETTLEMENT);
        CalendarUtil cbt = new CalendarUtil();
        cbt.checkHolidayList(expectedHol, settlement, 2007);
    }

    @Test
    public void testUnitedStatesSettlementYear2008() {
        int year = 2008;
        System.out.println("Testing " + (Object)((Object)UnitedStates.Market.SETTLEMENT) + " holiday list for the year " + 2008 + "...");
        ArrayList<Date> expectedHol = new ArrayList<Date>();
        expectedHol.add(new Date(1, Month.January, 2008));
        expectedHol.add(new Date(21, Month.January, 2008));
        expectedHol.add(new Date(18, Month.February, 2008));
        expectedHol.add(new Date(26, Month.May, 2008));
        expectedHol.add(new Date(4, Month.July, 2008));
        expectedHol.add(new Date(1, Month.September, 2008));
        expectedHol.add(new Date(13, Month.October, 2008));
        expectedHol.add(new Date(11, Month.November, 2008));
        expectedHol.add(new Date(27, Month.November, 2008));
        expectedHol.add(new Date(25, Month.December, 2008));
        UnitedStates settlement = new UnitedStates(UnitedStates.Market.SETTLEMENT);
        CalendarUtil cbt = new CalendarUtil();
        cbt.checkHolidayList(expectedHol, settlement, 2008);
    }

    @Test
    public void testUnitedStatesSettlementYear2009() {
        int year = 2009;
        System.out.println("Testing " + (Object)((Object)UnitedStates.Market.SETTLEMENT) + " holiday list for the year " + 2009 + "...");
        ArrayList<Date> expectedHol = new ArrayList<Date>();
        expectedHol.add(new Date(1, Month.January, 2009));
        expectedHol.add(new Date(19, Month.January, 2009));
        expectedHol.add(new Date(16, Month.February, 2009));
        expectedHol.add(new Date(25, Month.May, 2009));
        expectedHol.add(new Date(3, Month.July, 2009));
        expectedHol.add(new Date(7, Month.September, 2009));
        expectedHol.add(new Date(12, Month.October, 2009));
        expectedHol.add(new Date(11, Month.November, 2009));
        expectedHol.add(new Date(26, Month.November, 2009));
        expectedHol.add(new Date(25, Month.December, 2009));
        UnitedStates settlement = new UnitedStates(UnitedStates.Market.SETTLEMENT);
        CalendarUtil cbt = new CalendarUtil();
        cbt.checkHolidayList(expectedHol, settlement, 2009);
    }

    @Test
    public void testUnitedStatesSettlementYear2010() {
        int year = 2010;
        System.out.println("Testing " + (Object)((Object)UnitedStates.Market.SETTLEMENT) + " holiday list for the year " + 2010 + "...");
        ArrayList<Date> expectedHol = new ArrayList<Date>();
        expectedHol.add(new Date(1, Month.January, 2010));
        expectedHol.add(new Date(18, Month.January, 2010));
        expectedHol.add(new Date(15, Month.February, 2010));
        expectedHol.add(new Date(31, Month.May, 2010));
        expectedHol.add(new Date(5, Month.July, 2010));
        expectedHol.add(new Date(6, Month.September, 2010));
        expectedHol.add(new Date(11, Month.October, 2010));
        expectedHol.add(new Date(11, Month.November, 2010));
        expectedHol.add(new Date(25, Month.November, 2010));
        expectedHol.add(new Date(24, Month.December, 2010));
        expectedHol.add(new Date(31, Month.December, 2010));
        UnitedStates settlement = new UnitedStates(UnitedStates.Market.SETTLEMENT);
        CalendarUtil cbt = new CalendarUtil();
        cbt.checkHolidayList(expectedHol, settlement, 2010);
    }
}

