/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.testsuite.calendars;

import java.util.ArrayList;
import org.jquantlib.QL;
import org.jquantlib.testsuite.calendars.CalendarUtil;
import org.jquantlib.time.Calendar;
import org.jquantlib.time.Date;
import org.jquantlib.time.Month;
import org.jquantlib.time.calendars.Poland;
import org.junit.Test;

public class PolandCalendarTest {
    private final Calendar settlement;

    public PolandCalendarTest() {
        QL.info("::::: " + this.getClass().getSimpleName() + " :::::");
        this.settlement = new Poland();
    }

    @Test
    public void testPolandSettlementHolidaysYear2004() {
        int year = 2004;
        QL.info("Testing " + this.settlement.name() + " holidays list for the year " + 2004 + "...");
        ArrayList<Date> expectedHol = new ArrayList<Date>();
        expectedHol.add(new Date(1, Month.January, 2004));
        expectedHol.add(new Date(12, Month.April, 2004));
        expectedHol.add(new Date(3, Month.May, 2004));
        expectedHol.add(new Date(10, Month.June, 2004));
        expectedHol.add(new Date(1, Month.November, 2004));
        expectedHol.add(new Date(11, Month.November, 2004));
        CalendarUtil cbt = new CalendarUtil();
        cbt.checkHolidayList(expectedHol, this.settlement, 2004);
    }

    @Test
    public void testPolandSettlementHolidaysYear2005() {
        int year = 2005;
        QL.info("Testing " + this.settlement.name() + " holidays list for the year " + 2005 + "...");
        ArrayList<Date> expectedHol = new ArrayList<Date>();
        expectedHol.add(new Date(28, Month.March, 2005));
        expectedHol.add(new Date(3, Month.May, 2005));
        expectedHol.add(new Date(26, Month.May, 2005));
        expectedHol.add(new Date(15, Month.August, 2005));
        expectedHol.add(new Date(1, Month.November, 2005));
        expectedHol.add(new Date(11, Month.November, 2005));
        expectedHol.add(new Date(26, Month.December, 2005));
        CalendarUtil cbt = new CalendarUtil();
        cbt.checkHolidayList(expectedHol, this.settlement, 2005);
    }

    @Test
    public void testPolandSettlementHolidaysYear2006() {
        int year = 2006;
        QL.info("Testing " + this.settlement.name() + " holidays list for the year " + 2006 + "...");
        ArrayList<Date> expectedHol = new ArrayList<Date>();
        expectedHol.add(new Date(17, Month.April, 2006));
        expectedHol.add(new Date(1, Month.May, 2006));
        expectedHol.add(new Date(3, Month.May, 2006));
        expectedHol.add(new Date(15, Month.June, 2006));
        expectedHol.add(new Date(15, Month.August, 2006));
        expectedHol.add(new Date(1, Month.November, 2006));
        expectedHol.add(new Date(25, Month.December, 2006));
        expectedHol.add(new Date(26, Month.December, 2006));
        CalendarUtil cbt = new CalendarUtil();
        cbt.checkHolidayList(expectedHol, this.settlement, 2006);
    }

    @Test
    public void testPolandSettlementHolidaysYear2007() {
        int year = 2007;
        QL.info("Testing " + this.settlement.name() + " holidays list for the year " + 2007 + "...");
        ArrayList<Date> expectedHol = new ArrayList<Date>();
        expectedHol.add(new Date(1, Month.January, 2007));
        expectedHol.add(new Date(9, Month.April, 2007));
        expectedHol.add(new Date(1, Month.May, 2007));
        expectedHol.add(new Date(3, Month.May, 2007));
        expectedHol.add(new Date(7, Month.June, 2007));
        expectedHol.add(new Date(15, Month.August, 2007));
        expectedHol.add(new Date(1, Month.November, 2007));
        expectedHol.add(new Date(25, Month.December, 2007));
        expectedHol.add(new Date(26, Month.December, 2007));
        CalendarUtil cbt = new CalendarUtil();
        cbt.checkHolidayList(expectedHol, this.settlement, 2007);
    }

    @Test
    public void testPolandSettlementHolidaysYear2008() {
        int year = 2008;
        QL.info("Testing " + this.settlement.name() + " holidays list for the year " + 2008 + "...");
        ArrayList<Date> expectedHol = new ArrayList<Date>();
        expectedHol.add(new Date(1, Month.January, 2008));
        expectedHol.add(new Date(24, Month.March, 2008));
        expectedHol.add(new Date(1, Month.May, 2008));
        expectedHol.add(new Date(22, Month.May, 2008));
        expectedHol.add(new Date(15, Month.August, 2008));
        expectedHol.add(new Date(11, Month.November, 2008));
        expectedHol.add(new Date(25, Month.December, 2008));
        expectedHol.add(new Date(26, Month.December, 2008));
        CalendarUtil cbt = new CalendarUtil();
        cbt.checkHolidayList(expectedHol, this.settlement, 2008);
    }

    @Test
    public void testPolandSettlementHolidaysYear2009() {
        int year = 2009;
        QL.info("Testing " + this.settlement.name() + " holidays list for the year " + 2009 + "...");
        ArrayList<Date> expectedHol = new ArrayList<Date>();
        expectedHol.add(new Date(1, Month.January, 2009));
        expectedHol.add(new Date(13, Month.April, 2009));
        expectedHol.add(new Date(1, Month.May, 2009));
        expectedHol.add(new Date(11, Month.June, 2009));
        expectedHol.add(new Date(11, Month.November, 2009));
        expectedHol.add(new Date(25, Month.December, 2009));
        CalendarUtil cbt = new CalendarUtil();
        cbt.checkHolidayList(expectedHol, this.settlement, 2009);
    }

    @Test
    public void testPolandSettlementHolidaysYear2010() {
        int year = 2010;
        QL.info("Testing " + this.settlement.name() + " holidays list for the year " + 2010 + "...");
        ArrayList<Date> expectedHol = new ArrayList<Date>();
        expectedHol.add(new Date(1, Month.January, 2010));
        expectedHol.add(new Date(5, Month.April, 2010));
        expectedHol.add(new Date(3, Month.May, 2010));
        expectedHol.add(new Date(3, Month.June, 2010));
        expectedHol.add(new Date(1, Month.November, 2010));
        expectedHol.add(new Date(11, Month.November, 2010));
        CalendarUtil cbt = new CalendarUtil();
        cbt.checkHolidayList(expectedHol, this.settlement, 2010);
    }

    @Test
    public void testPolandSettlementHolidaysYear2011() {
        int year = 2011;
        QL.info("Testing " + this.settlement.name() + " holidays list for the year " + 2011 + "...");
        ArrayList<Date> expectedHol = new ArrayList<Date>();
        expectedHol.add(new Date(25, Month.April, 2011));
        expectedHol.add(new Date(3, Month.May, 2011));
        expectedHol.add(new Date(23, Month.June, 2011));
        expectedHol.add(new Date(15, Month.August, 2011));
        expectedHol.add(new Date(1, Month.November, 2011));
        expectedHol.add(new Date(11, Month.November, 2011));
        expectedHol.add(new Date(26, Month.December, 2011));
        CalendarUtil cbt = new CalendarUtil();
        cbt.checkHolidayList(expectedHol, this.settlement, 2011);
    }

    @Test
    public void testPolandSettlementHolidaysYear2012() {
        int year = 2012;
        QL.info("Testing " + this.settlement.name() + " holidays list for the year " + 2012 + "...");
        ArrayList<Date> expectedHol = new ArrayList<Date>();
        expectedHol.add(new Date(9, Month.April, 2012));
        expectedHol.add(new Date(1, Month.May, 2012));
        expectedHol.add(new Date(3, Month.May, 2012));
        expectedHol.add(new Date(7, Month.June, 2012));
        expectedHol.add(new Date(15, Month.August, 2012));
        expectedHol.add(new Date(1, Month.November, 2012));
        expectedHol.add(new Date(25, Month.December, 2012));
        expectedHol.add(new Date(26, Month.December, 2012));
        CalendarUtil cbt = new CalendarUtil();
        cbt.checkHolidayList(expectedHol, this.settlement, 2012);
    }
}

