/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.testsuite.calendars;

import java.util.ArrayList;
import org.jquantlib.QL;
import org.jquantlib.testsuite.calendars.CalendarUtil;
import org.jquantlib.time.Calendar;
import org.jquantlib.time.Date;
import org.jquantlib.time.Month;
import org.jquantlib.time.calendars.Italy;
import org.junit.Test;

public class ItalyCalendarTest {
    private final Calendar cExchange;
    private final Calendar cSettlement;

    public ItalyCalendarTest() {
        QL.info("::::: " + this.getClass().getSimpleName() + " :::::");
        this.cExchange = new Italy(Italy.Market.Exchange);
        this.cSettlement = new Italy(Italy.Market.Settlement);
    }

    @Test
    public void testItalyYear2004() {
        int year = 2004;
        QL.info("Testing Italy holiday list for the year 2004");
        ArrayList<Date> expectedHol = new ArrayList<Date>();
        expectedHol.add(new Date(1, Month.January, 2004));
        Date goodFriday = new Date(9, Month.April, 2004);
        expectedHol.add(goodFriday);
        expectedHol.add(new Date(12, Month.April, 2004));
        Date christmasEve = new Date(24, Month.December, 2004);
        expectedHol.add(christmasEve);
        Date newYearEve = new Date(31, Month.December, 2004);
        expectedHol.add(newYearEve);
        CalendarUtil cbt = new CalendarUtil();
        cbt.checkHolidayList(expectedHol, this.cExchange, 2004);
        expectedHol.remove(goodFriday);
        expectedHol.remove(christmasEve);
        expectedHol.remove(newYearEve);
        expectedHol.add(new Date(6, Month.January, 2004));
        expectedHol.add(new Date(2, Month.June, 2004));
        expectedHol.add(new Date(1, Month.November, 2004));
        expectedHol.add(new Date(8, Month.December, 2004));
        cbt.checkHolidayList(expectedHol, this.cSettlement, 2004);
    }

    @Test
    public void testItalyYear2006() {
        int year = 2006;
        QL.info("Testing Italy holiday list for the year 2006");
        ArrayList<Date> expectedHol = new ArrayList<Date>();
        Date goodFriday = new Date(14, Month.April, 2006);
        expectedHol.add(goodFriday);
        expectedHol.add(new Date(17, Month.April, 2006));
        expectedHol.add(new Date(1, Month.May, 2006));
        expectedHol.add(new Date(15, Month.August, 2006));
        expectedHol.add(new Date(25, Month.December, 2006));
        expectedHol.add(new Date(26, Month.December, 2006));
        CalendarUtil cbt = new CalendarUtil();
        cbt.checkHolidayList(expectedHol, this.cExchange, 2006);
        expectedHol.remove(goodFriday);
        expectedHol.add(new Date(6, Month.January, 2006));
        expectedHol.add(new Date(25, Month.April, 2006));
        expectedHol.add(new Date(2, Month.June, 2006));
        expectedHol.add(new Date(1, Month.November, 2006));
        expectedHol.add(new Date(8, Month.December, 2006));
        cbt.checkHolidayList(expectedHol, this.cSettlement, 2006);
    }

    @Test
    public void testItalyYear2007() {
        int year = 2007;
        QL.info("Testing Italy holiday list for the year 2007");
        ArrayList<Date> expectedHol = new ArrayList<Date>();
        expectedHol.add(new Date(1, Month.January, 2007));
        Date goodFriday = new Date(6, Month.April, 2007);
        expectedHol.add(goodFriday);
        expectedHol.add(new Date(9, Month.April, 2007));
        expectedHol.add(new Date(1, Month.May, 2007));
        expectedHol.add(new Date(15, Month.August, 2007));
        Date christmasEve = new Date(24, Month.December, 2007);
        expectedHol.add(christmasEve);
        expectedHol.add(new Date(25, Month.December, 2007));
        expectedHol.add(new Date(26, Month.December, 2007));
        Date newYearEve = new Date(31, Month.December, 2007);
        expectedHol.add(newYearEve);
        CalendarUtil cbt = new CalendarUtil();
        cbt.checkHolidayList(expectedHol, this.cExchange, 2007);
        expectedHol.remove(goodFriday);
        expectedHol.remove(christmasEve);
        expectedHol.remove(newYearEve);
        expectedHol.add(new Date(25, Month.April, 2007));
        expectedHol.add(new Date(1, Month.November, 2007));
        cbt.checkHolidayList(expectedHol, this.cSettlement, 2007);
    }

    @Test
    public void testItalyYear2008() {
        int year = 2008;
        QL.info("Testing Italy holiday list for the year 2008");
        ArrayList<Date> expectedHol = new ArrayList<Date>();
        expectedHol.add(new Date(1, Month.January, 2008));
        Date goodFriday = new Date(21, Month.March, 2008);
        expectedHol.add(goodFriday);
        expectedHol.add(new Date(24, Month.March, 2008));
        expectedHol.add(new Date(1, Month.May, 2008));
        expectedHol.add(new Date(15, Month.August, 2008));
        Date christmasEve = new Date(24, Month.December, 2008);
        expectedHol.add(christmasEve);
        expectedHol.add(new Date(25, Month.December, 2008));
        expectedHol.add(new Date(26, Month.December, 2008));
        Date newYearEve = new Date(31, Month.December, 2008);
        expectedHol.add(newYearEve);
        CalendarUtil cbt = new CalendarUtil();
        cbt.checkHolidayList(expectedHol, this.cExchange, 2008);
        expectedHol.remove(goodFriday);
        expectedHol.remove(christmasEve);
        expectedHol.remove(newYearEve);
        expectedHol.add(new Date(25, Month.April, 2008));
        expectedHol.add(new Date(2, Month.June, 2008));
        expectedHol.add(new Date(8, Month.December, 2008));
        cbt.checkHolidayList(expectedHol, this.cSettlement, 2008);
    }

    @Test
    public void testItalyYear2009() {
        int year = 2009;
        QL.info("Testing Italy holiday list for the year 2009");
        ArrayList<Date> expectedHol = new ArrayList<Date>();
        expectedHol.add(new Date(1, Month.January, 2009));
        Date goodFriday = new Date(10, Month.April, 2009);
        expectedHol.add(goodFriday);
        expectedHol.add(new Date(13, Month.April, 2009));
        expectedHol.add(new Date(1, Month.May, 2009));
        Date christmasEve = new Date(24, Month.December, 2009);
        expectedHol.add(christmasEve);
        expectedHol.add(new Date(25, Month.December, 2009));
        Date newYearEve = new Date(31, Month.December, 2009);
        expectedHol.add(newYearEve);
        CalendarUtil cbt = new CalendarUtil();
        cbt.checkHolidayList(expectedHol, this.cExchange, 2009);
        expectedHol.remove(goodFriday);
        expectedHol.remove(christmasEve);
        expectedHol.remove(newYearEve);
        expectedHol.add(new Date(6, Month.January, 2009));
        expectedHol.add(new Date(2, Month.June, 2009));
        expectedHol.add(new Date(8, Month.December, 2009));
        cbt.checkHolidayList(expectedHol, this.cSettlement, 2009);
    }

    @Test
    public void testItalyYear2010() {
        int year = 2010;
        QL.info("Testing Italy holiday list for the year 2010");
        ArrayList<Date> expectedHol = new ArrayList<Date>();
        expectedHol.add(new Date(1, Month.January, 2010));
        Date goodFriday = new Date(2, Month.April, 2010);
        expectedHol.add(goodFriday);
        expectedHol.add(new Date(5, Month.April, 2010));
        Date christmasEve = new Date(24, Month.December, 2010);
        expectedHol.add(christmasEve);
        Date newYearEve = new Date(31, Month.December, 2010);
        expectedHol.add(newYearEve);
        CalendarUtil cbt = new CalendarUtil();
        cbt.checkHolidayList(expectedHol, this.cExchange, 2010);
        expectedHol.remove(goodFriday);
        expectedHol.remove(christmasEve);
        expectedHol.remove(newYearEve);
        expectedHol.add(new Date(6, Month.January, 2010));
        expectedHol.add(new Date(2, Month.June, 2010));
        expectedHol.add(new Date(1, Month.November, 2010));
        expectedHol.add(new Date(8, Month.December, 2010));
        cbt.checkHolidayList(expectedHol, this.cSettlement, 2010);
    }

    @Test
    public void testItalyYear2011() {
        int year = 2011;
        QL.info("Testing Italy holiday list for the year 2011");
        ArrayList<Date> expectedHol = new ArrayList<Date>();
        Date goodFriday = new Date(22, Month.April, 2011);
        expectedHol.add(goodFriday);
        expectedHol.add(new Date(25, Month.April, 2011));
        expectedHol.add(new Date(15, Month.August, 2011));
        expectedHol.add(new Date(26, Month.December, 2011));
        CalendarUtil cbt = new CalendarUtil();
        cbt.checkHolidayList(expectedHol, this.cExchange, 2011);
        expectedHol.remove(goodFriday);
        expectedHol.add(new Date(6, Month.January, 2011));
        expectedHol.add(new Date(2, Month.June, 2011));
        expectedHol.add(new Date(1, Month.November, 2011));
        expectedHol.add(new Date(8, Month.December, 2011));
        cbt.checkHolidayList(expectedHol, this.cSettlement, 2011);
    }

    @Test
    public void testItalyYear2012() {
        int year = 2012;
        QL.info("Testing Italy holiday list for the year 2012");
        ArrayList<Date> expectedHol = new ArrayList<Date>();
        Date goodFriday = new Date(6, Month.April, 2012);
        expectedHol.add(goodFriday);
        expectedHol.add(new Date(9, Month.April, 2012));
        expectedHol.add(new Date(1, Month.May, 2012));
        expectedHol.add(new Date(15, Month.August, 2012));
        Date christmasEve = new Date(24, Month.December, 2012);
        expectedHol.add(christmasEve);
        expectedHol.add(new Date(25, Month.December, 2012));
        expectedHol.add(new Date(26, Month.December, 2012));
        Date newYearEve = new Date(31, Month.December, 2012);
        expectedHol.add(newYearEve);
        CalendarUtil cbt = new CalendarUtil();
        cbt.checkHolidayList(expectedHol, this.cExchange, 2012);
        expectedHol.remove(goodFriday);
        expectedHol.remove(christmasEve);
        expectedHol.remove(newYearEve);
        expectedHol.add(new Date(6, Month.January, 2012));
        expectedHol.add(new Date(25, Month.April, 2012));
        expectedHol.add(new Date(1, Month.November, 2012));
        cbt.checkHolidayList(expectedHol, this.cSettlement, 2012);
    }
}

