/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.testsuite.calendars;

import java.util.Vector;
import org.jquantlib.QL;
import org.jquantlib.testsuite.calendars.CalendarUtil;
import org.jquantlib.time.Calendar;
import org.jquantlib.time.Date;
import org.jquantlib.time.Month;
import org.jquantlib.time.calendars.India;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class IndiaCalendarTest {
    private Calendar c = null;

    public IndiaCalendarTest() {
        QL.info("::::: " + this.getClass().getSimpleName() + " :::::");
    }

    @Before
    public void setup() {
        this.c = new India(India.Market.NSE);
    }

    @Test
    public void testIndiaNseHolidaysYear2005() {
        int year = 2005;
        QL.info("Testing " + (Object)((Object)India.Market.NSE) + " holidays list for the year " + 2005 + "...");
        Vector<Date> expectedHol = new Vector<Date>();
        expectedHol.add(new Date(21, Month.January, 2005));
        expectedHol.add(new Date(26, Month.January, 2005));
        expectedHol.add(new Date(25, Month.March, 2005));
        expectedHol.add(new Date(14, Month.April, 2005));
        expectedHol.add(new Date(15, Month.August, 2005));
        expectedHol.add(new Date(7, Month.September, 2005));
        expectedHol.add(new Date(12, Month.October, 2005));
        expectedHol.add(new Date(1, Month.November, 2005));
        expectedHol.add(new Date(3, Month.November, 2005));
        expectedHol.add(new Date(15, Month.November, 2005));
        CalendarUtil cbt = new CalendarUtil();
        cbt.checkHolidayList(expectedHol, this.c, 2005);
    }

    @Test
    public void testIndiaNseHolidaysYear2006() {
        int year = 2006;
        QL.info("Testing " + (Object)((Object)India.Market.NSE) + " holidays list for the year " + 2006 + "...");
        Vector<Date> expectedHol = new Vector<Date>();
        expectedHol.add(new Date(11, Month.January, 2006));
        expectedHol.add(new Date(26, Month.January, 2006));
        expectedHol.add(new Date(9, Month.February, 2006));
        expectedHol.add(new Date(15, Month.March, 2006));
        expectedHol.add(new Date(6, Month.April, 2006));
        expectedHol.add(new Date(11, Month.April, 2006));
        expectedHol.add(new Date(14, Month.April, 2006));
        expectedHol.add(new Date(1, Month.May, 2006));
        expectedHol.add(new Date(15, Month.August, 2006));
        expectedHol.add(new Date(2, Month.October, 2006));
        expectedHol.add(new Date(24, Month.October, 2006));
        expectedHol.add(new Date(25, Month.October, 2006));
        expectedHol.add(new Date(25, Month.December, 2006));
        CalendarUtil cbt = new CalendarUtil();
        cbt.checkHolidayList(expectedHol, this.c, 2006);
    }

    @Test
    public void testIndiaNseHolidaysYear2007() {
        int year = 2007;
        QL.info("Testing " + (Object)((Object)India.Market.NSE) + " holidays list for the year " + 2007 + "...");
        Vector<Date> expectedHol = new Vector<Date>();
        expectedHol.add(new Date(1, Month.January, 2007));
        expectedHol.add(new Date(26, Month.January, 2007));
        expectedHol.add(new Date(30, Month.January, 2007));
        expectedHol.add(new Date(16, Month.February, 2007));
        expectedHol.add(new Date(27, Month.March, 2007));
        expectedHol.add(new Date(6, Month.April, 2007));
        expectedHol.add(new Date(1, Month.May, 2007));
        expectedHol.add(new Date(2, Month.May, 2007));
        expectedHol.add(new Date(15, Month.August, 2007));
        expectedHol.add(new Date(2, Month.October, 2007));
        expectedHol.add(new Date(9, Month.November, 2007));
        expectedHol.add(new Date(21, Month.December, 2007));
        expectedHol.add(new Date(25, Month.December, 2007));
        CalendarUtil cbt = new CalendarUtil();
        cbt.checkHolidayList(expectedHol, this.c, 2007);
    }

    @Test
    public void testIndiaNseHolidaysYear2008() {
        int year = 2008;
        QL.info("Testing " + (Object)((Object)India.Market.NSE) + " holidays list for the year " + 2008 + "...");
        Vector<Date> expectedHol = new Vector<Date>();
        expectedHol.add(new Date(6, Month.March, 2008));
        expectedHol.add(new Date(20, Month.March, 2008));
        expectedHol.add(new Date(21, Month.March, 2008));
        expectedHol.add(new Date(14, Month.April, 2008));
        expectedHol.add(new Date(18, Month.April, 2008));
        expectedHol.add(new Date(1, Month.May, 2008));
        expectedHol.add(new Date(19, Month.May, 2008));
        expectedHol.add(new Date(15, Month.August, 2008));
        expectedHol.add(new Date(3, Month.September, 2008));
        expectedHol.add(new Date(2, Month.October, 2008));
        expectedHol.add(new Date(9, Month.October, 2008));
        expectedHol.add(new Date(28, Month.October, 2008));
        expectedHol.add(new Date(30, Month.October, 2008));
        expectedHol.add(new Date(13, Month.November, 2008));
        expectedHol.add(new Date(9, Month.December, 2008));
        expectedHol.add(new Date(25, Month.December, 2008));
        CalendarUtil cbt = new CalendarUtil();
        cbt.checkHolidayList(expectedHol, this.c, 2008);
    }

    @Test
    public void testIndiaNseHolidaysYear2009() {
        int year = 2009;
        QL.info("Testing " + (Object)((Object)India.Market.NSE) + " holidays list for the year " + 2009 + "...");
        Vector<Date> expectedHol = new Vector<Date>();
        expectedHol.add(new Date(26, Month.January, 2009));
        expectedHol.add(new Date(10, Month.April, 2009));
        expectedHol.add(new Date(14, Month.April, 2009));
        expectedHol.add(new Date(2, Month.October, 2009));
        expectedHol.add(new Date(25, Month.December, 2009));
        CalendarUtil cbt = new CalendarUtil();
        cbt.checkHolidayList(expectedHol, this.c, 2009);
    }

    @After
    public void destroy() {
        this.c = null;
    }
}

