/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.testsuite.calendars;

import org.jquantlib.QL;
import org.jquantlib.time.BusinessDayConvention;
import org.jquantlib.time.Calendar;
import org.jquantlib.time.Date;
import org.jquantlib.time.Month;
import org.jquantlib.time.Period;
import org.jquantlib.time.TimeUnit;
import org.jquantlib.time.calendars.Japan;
import org.jquantlib.time.calendars.JointCalendar;
import org.jquantlib.time.calendars.NullCalendar;
import org.jquantlib.time.calendars.Target;
import org.jquantlib.time.calendars.UnitedKingdom;
import org.jquantlib.time.calendars.UnitedStates;
import org.junit.Assert;
import org.junit.Test;

public class CalendarTest {
    public CalendarTest() {
        QL.info("::::: " + this.getClass().getSimpleName() + " :::::");
    }

    @Test
    public void testAdvance() {
        NullCalendar nullCalendar = new NullCalendar();
        Date d = new Date(11, Month.October, 2009);
        Date dCopy = d.clone();
        Assert.assertEquals((Object)dCopy, (Object)d);
        Date advancedDate = nullCalendar.advance(d, new Period(3, TimeUnit.Months));
        Assert.assertEquals((Object)dCopy, (Object)d);
        Assert.assertFalse((boolean)advancedDate.equals(d));
    }

    @Test
    public void testEndOfMonth() {
        QL.info("Testing end-of-month calculation...");
        Target c = new Target();
        Date counter = Date.minDate();
        Date last = Date.maxDate().sub(new Period(2, TimeUnit.Months));
        while (counter.le(last)) {
            Date eom = c.endOfMonth(counter);
            if (!c.isEndOfMonth(eom)) {
                Assert.fail((String)String.format("%s %s %s is not the last business day in %s according to %s", new Object[]{eom.weekday(), eom.dayOfMonth(), eom.month(), eom.year(), c.name()}));
            }
            if (eom.month() != counter.month()) {
                Assert.fail((String)String.format("%s is not the same month as %s", eom, counter));
            }
            counter.addAssign(1);
        }
    }

    @Test
    public void testAdjust_ModifiedFollowing() {
        System.out.println("Testing BusinessDayConvention.ModifiedFollowing");
        final class Entry {
            public Date date;
            public Date expected;

            Entry(Date d, Date e) {
                this.date = d;
                this.expected = e;
            }
        }
        Entry[] entries = new Entry[]{new Entry(new Date(28, 5, 2009), new Date(28, 5, 2009)), new Entry(new Date(29, 5, 2009), new Date(29, 5, 2009)), new Entry(new Date(30, 5, 2009), new Date(29, 5, 2009)), new Entry(new Date(31, 5, 2009), new Date(29, 5, 2009)), new Entry(new Date(1, 6, 2009), new Date(1, 6, 2009)), new Entry(new Date(2, 6, 2009), new Date(2, 6, 2009)), new Entry(new Date(3, 6, 2009), new Date(3, 6, 2009)), new Entry(new Date(23, 1, 1973), new Date(23, 1, 1973)), new Entry(new Date(24, 1, 1973), new Date(24, 1, 1973)), new Entry(new Date(25, 1, 1973), new Date(26, 1, 1973)), new Entry(new Date(26, 1, 1973), new Date(26, 1, 1973))};
        UnitedStates unitedStatesCalendar = new UnitedStates(UnitedStates.Market.NYSE);
        for (Entry entry : entries) {
            Date result = unitedStatesCalendar.adjust(entry.date, BusinessDayConvention.ModifiedFollowing);
            System.out.println("adjusted is " + result.isoDate() + "  ::  expected is " + entry.expected.isoDate());
            Assert.assertEquals((Object)result, (Object)entry.expected);
        }
    }

    @Test
    public void testAdjust_ModifiedPreceeding() {
        System.out.println("Testing BusinessDayConvention.ModifiedPreceding");
        final class Entry {
            public Date date;
            public Date expected;

            Entry(Date d, Date e) {
                this.date = d;
                this.expected = e;
            }
        }
        Entry[] entries = new Entry[]{new Entry(new Date(28, 5, 2009), new Date(28, 5, 2009)), new Entry(new Date(29, 5, 2009), new Date(29, 5, 2009)), new Entry(new Date(30, 5, 2009), new Date(29, 5, 2009)), new Entry(new Date(31, 5, 2009), new Date(29, 5, 2009)), new Entry(new Date(1, 6, 2009), new Date(1, 6, 2009)), new Entry(new Date(2, 6, 2009), new Date(2, 6, 2009)), new Entry(new Date(3, 6, 2009), new Date(3, 6, 2009)), new Entry(new Date(23, 1, 1973), new Date(23, 1, 1973)), new Entry(new Date(24, 1, 1973), new Date(24, 1, 1973)), new Entry(new Date(25, 1, 1973), new Date(24, 1, 1973)), new Entry(new Date(26, 1, 1973), new Date(26, 1, 1973))};
        UnitedStates unitedStatesCalendar = new UnitedStates(UnitedStates.Market.NYSE);
        for (Entry entry : entries) {
            Date result = unitedStatesCalendar.adjust(entry.date, BusinessDayConvention.ModifiedPreceding);
            System.out.println("adjusted is " + result.isoDate() + "  ::  expected is " + entry.expected.isoDate());
            Assert.assertEquals((Object)result, (Object)entry.expected);
        }
    }

    @Test
    public void testJointCalendars() {
        System.out.println("Testing joint calendars...");
        Target c1 = new Target();
        UnitedKingdom c2 = new UnitedKingdom();
        UnitedStates c3 = new UnitedStates(UnitedStates.Market.NYSE);
        Japan c4 = new Japan();
        JointCalendar c12h = new JointCalendar((Calendar)c1, (Calendar)c2, JointCalendar.JointCalendarRule.JoinHolidays);
        JointCalendar c12b = new JointCalendar((Calendar)c1, (Calendar)c2, JointCalendar.JointCalendarRule.JoinBusinessDays);
        JointCalendar c123h = new JointCalendar((Calendar)c1, (Calendar)c2, (Calendar)c3, JointCalendar.JointCalendarRule.JoinHolidays);
        JointCalendar c123b = new JointCalendar((Calendar)c1, (Calendar)c2, (Calendar)c3, JointCalendar.JointCalendarRule.JoinBusinessDays);
        JointCalendar c1234h = new JointCalendar(c1, (Calendar)c2, (Calendar)c3, (Calendar)c4, JointCalendar.JointCalendarRule.JoinHolidays);
        JointCalendar c1234b = new JointCalendar(c1, (Calendar)c2, (Calendar)c3, (Calendar)c4, JointCalendar.JointCalendarRule.JoinBusinessDays);
        Date firstDate = Date.todaysDate();
        Date endDate = firstDate.add(new Period(1, TimeUnit.Years));
        Date d = firstDate;
        while (d.lt(endDate)) {
            boolean b1 = c1.isBusinessDay(d);
            boolean b2 = c2.isBusinessDay(d);
            boolean b3 = c3.isBusinessDay(d);
            boolean b4 = c4.isBusinessDay(d);
            if ((b1 && b2) != c12h.isBusinessDay(d)) {
                Assert.fail((String)("At date " + d + ":\n" + "    inconsistency between joint calendar " + c12h.name() + " (joining holidays)\n" + "    and its components"));
            }
            if ((b1 || b2) != c12b.isBusinessDay(d)) {
                Assert.fail((String)("At date " + d + ":\n" + "    inconsistency between joint calendar " + c12b.name() + " (joining business days)\n" + "    and its components"));
            }
            if ((b1 && b2 && b3) != c123h.isBusinessDay(d)) {
                Assert.fail((String)("At date " + d + ":\n" + "    inconsistency between joint calendar " + c123h.name() + " (joining holidays)\n" + "    and its components"));
            }
            if ((b1 || b2 || b3) != c123b.isBusinessDay(d)) {
                Assert.fail((String)("At date " + d + ":\n" + "    inconsistency between joint calendar " + c123b.name() + " (joining business days)\n" + "    and its components"));
            }
            if ((b1 && b2 && b3 && b4) != c1234h.isBusinessDay(d)) {
                Assert.fail((String)("At date " + d + ":\n" + "    inconsistency between joint calendar " + c1234h.name() + " (joining holidays)\n" + "    and its components"));
            }
            if ((b1 || b2 || b3 || b4) != c1234b.isBusinessDay(d)) {
                Assert.fail((String)("At date " + d + ":\n" + "    inconsistency between joint calendar " + c1234b.name() + " (joining business days)\n" + "    and its components"));
            }
            d.inc();
        }
    }
}

