/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.termstructures.yieldcurves;

import org.jquantlib.daycounters.DayCounter;
import org.jquantlib.quotes.Handle;
import org.jquantlib.quotes.Quote;
import org.jquantlib.quotes.SimpleQuote;
import org.jquantlib.termstructures.AbstractYieldTermStructure;
import org.jquantlib.termstructures.Compounding;
import org.jquantlib.termstructures.InterestRate;
import org.jquantlib.time.Calendar;
import org.jquantlib.time.Date;
import org.jquantlib.time.Frequency;
import org.jquantlib.time.calendars.NullCalendar;

public class FlatForward
extends AbstractYieldTermStructure {
    private final Handle<? extends Quote> forward;
    private final Compounding compounding;
    private final Frequency frequency;
    private InterestRate rate;

    public FlatForward(Date referenceDate, Handle<? extends Quote> forward, DayCounter dayCounter, Compounding compounding, Frequency frequency) {
        super(referenceDate, (Calendar)new NullCalendar(), dayCounter);
        this.compounding = compounding;
        this.frequency = frequency;
        this.forward = forward;
        this.forward.addObserver(this);
        this.updateRate();
    }

    public FlatForward(Date referenceDate, Handle<? extends Quote> forward, DayCounter dayCounter, Compounding compounding) {
        this(referenceDate, forward, dayCounter, compounding, Frequency.Annual);
    }

    public FlatForward(Date referenceDate, Handle<? extends Quote> forward, DayCounter dayCounter) {
        this(referenceDate, forward, dayCounter, Compounding.Continuous);
    }

    public FlatForward(Date referenceDate, double forward, DayCounter dayCounter, Compounding compounding, Frequency frequency) {
        super(referenceDate, (Calendar)new NullCalendar(), dayCounter);
        this.forward = new Handle<SimpleQuote>(new SimpleQuote(forward));
        this.compounding = compounding;
        this.frequency = frequency;
        this.updateRate();
    }

    public FlatForward(Date referenceDate, double forward, DayCounter dayCounter, Compounding compounding) {
        this(referenceDate, forward, dayCounter, compounding, Frequency.Annual);
    }

    public FlatForward(Date referenceDate, double forward, DayCounter dayCounter) {
        this(referenceDate, forward, dayCounter, Compounding.Continuous);
    }

    public FlatForward(int settlementDays, Calendar calendar, Handle<? extends Quote> forward, DayCounter dayCounter, Compounding compounding, Frequency frequency) {
        super(settlementDays, calendar, dayCounter);
        this.compounding = compounding;
        this.frequency = frequency;
        this.forward = forward;
        this.forward.addObserver(this);
        this.updateRate();
    }

    public FlatForward(int settlementDays, Calendar calendar, Handle<? extends Quote> forward, DayCounter dayCounter) {
        this(settlementDays, calendar, forward, dayCounter, Compounding.Continuous);
    }

    public FlatForward(int settlementDays, Calendar calendar, Handle<? extends Quote> forward, DayCounter dayCounter, Compounding compounding) {
        this(settlementDays, calendar, forward, dayCounter, compounding, Frequency.Annual);
    }

    public FlatForward(int settlementDays, Calendar calendar, double forward, DayCounter dayCounter, Compounding compounding, Frequency frequency) {
        super(settlementDays, calendar, dayCounter);
        this.forward = new Handle<SimpleQuote>(new SimpleQuote(forward));
        this.compounding = compounding;
        this.frequency = frequency;
        this.updateRate();
    }

    public FlatForward(int settlementDays, Calendar calendar, double forward, DayCounter dayCounter) {
        this(settlementDays, calendar, forward, dayCounter, Compounding.Continuous);
    }

    public FlatForward(int settlementDays, Calendar calendar, double forward, DayCounter dayCounter, Compounding compounding) {
        this(settlementDays, calendar, forward, dayCounter, compounding, Frequency.Annual);
    }

    public final Compounding compounding() {
        return this.compounding;
    }

    public final Frequency compoundingFrequency() {
        return this.frequency;
    }

    private void updateRate() {
        this.rate = new InterestRate(this.forward.currentLink().value(), this.dayCounter(), this.compounding, this.frequency);
    }

    @Override
    protected final double discountImpl(double t) {
        return this.rate.discountFactor(t);
    }

    @Override
    public final Date maxDate() {
        return Date.maxDate();
    }

    @Override
    public void update() {
        this.updateRate();
        super.update();
    }
}

