/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.termstructures.yieldcurves;

import org.jquantlib.QL;
import org.jquantlib.currencies.Currency;
import org.jquantlib.daycounters.DayCounter;
import org.jquantlib.indexes.IborIndex;
import org.jquantlib.quotes.Handle;
import org.jquantlib.quotes.Quote;
import org.jquantlib.quotes.RelinkableHandle;
import org.jquantlib.termstructures.YieldTermStructure;
import org.jquantlib.termstructures.yieldcurves.RelativeDateRateHelper;
import org.jquantlib.time.BusinessDayConvention;
import org.jquantlib.time.Calendar;
import org.jquantlib.time.Date;
import org.jquantlib.time.Period;
import org.jquantlib.time.TimeUnit;
import org.jquantlib.util.PolymorphicVisitor;
import org.jquantlib.util.Visitor;

public class DepositRateHelper
extends RelativeDateRateHelper {
    private static final String TS_NOT_SET = "term structure not set";
    private Date fixingDate;
    private final IborIndex iborIndex;
    private final RelinkableHandle<YieldTermStructure> termStructureHandle = new RelinkableHandle<Object>(null);

    public DepositRateHelper(Handle<Quote> rate, Period tenor, int fixingDays, Calendar calendar, BusinessDayConvention convention, boolean endOfMonth, DayCounter dayCounter) {
        super(rate);
        this.iborIndex = new IborIndex("no-fix", tenor, fixingDays, new Currency(), calendar, convention, endOfMonth, dayCounter, this.termStructureHandle);
        this.initializeDates();
    }

    public DepositRateHelper(double rate, Period tenor, int fixingDays, Calendar calendar, BusinessDayConvention convention, boolean endOfMonth, DayCounter dayCounter) {
        super(rate);
        QL.validateExperimentalMode();
        this.iborIndex = new IborIndex("no-fix", tenor, fixingDays, new Currency(), calendar, convention, endOfMonth, dayCounter, this.termStructureHandle);
        this.initializeDates();
    }

    public DepositRateHelper(Handle<Quote> rate, IborIndex iborIndex) {
        super(rate);
        QL.validateExperimentalMode();
        this.iborIndex = new IborIndex("no-fix", iborIndex.tenor(), iborIndex.fixingDays(), new Currency(), iborIndex.fixingCalendar(), iborIndex.businessDayConvention(), iborIndex.endOfMonth(), iborIndex.dayCounter(), this.termStructureHandle);
        this.initializeDates();
    }

    public DepositRateHelper(double rate, IborIndex i) {
        super(rate);
        QL.validateExperimentalMode();
        this.iborIndex = new IborIndex("no-fix", i.tenor(), i.fixingDays(), new Currency(), i.fixingCalendar(), i.businessDayConvention(), i.endOfMonth(), i.dayCounter(), this.termStructureHandle);
        this.initializeDates();
    }

    @Override
    public double impliedQuote() {
        QL.require(this.termStructure != null, TS_NOT_SET);
        return this.iborIndex.fixing(this.fixingDate, true);
    }

    @Override
    public void setTermStructure(YieldTermStructure term) {
        this.termStructureHandle.linkTo(term, false);
        super.setTermStructure(term);
    }

    @Override
    protected void initializeDates() {
        this.earliestDate = this.iborIndex.fixingCalendar().advance(this.evaluationDate, this.iborIndex.fixingDays(), TimeUnit.Days);
        this.latestDate = this.iborIndex.maturityDate(this.earliestDate);
        this.fixingDate = this.iborIndex.fixingDate(this.earliestDate);
    }

    @Override
    public void accept(PolymorphicVisitor pv) {
        Visitor<?> v;
        Visitor<?> visitor = v = pv != null ? pv.visitor(this.getClass()) : null;
        if (v != null) {
            v.visit(this);
        } else {
            super.accept(pv);
        }
    }
}

