/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.termstructures.volatilities;

import org.jquantlib.QL;
import org.jquantlib.daycounters.DayCounter;
import org.jquantlib.termstructures.AbstractTermStructure;
import org.jquantlib.time.BusinessDayConvention;
import org.jquantlib.time.Calendar;
import org.jquantlib.time.Date;
import org.jquantlib.time.Period;

public abstract class VolatilityTermStructure
extends AbstractTermStructure {
    private final BusinessDayConvention bdc;

    public VolatilityTermStructure(Calendar cal, BusinessDayConvention bdc) {
        this(cal, bdc, new DayCounter());
    }

    public VolatilityTermStructure(Calendar cal, BusinessDayConvention bdc, DayCounter dc) {
        super(dc);
        this.bdc = bdc;
        this.calendar = cal;
    }

    public VolatilityTermStructure(Date referenceDate, Calendar cal, BusinessDayConvention bdc) {
        this(referenceDate, cal, bdc, new DayCounter());
    }

    public VolatilityTermStructure(Date referenceDate, Calendar cal, BusinessDayConvention bdc, DayCounter dc) {
        super(referenceDate, cal, dc);
        this.bdc = bdc;
    }

    public VolatilityTermStructure(int settlementDays, Calendar cal, BusinessDayConvention bdc) {
        this(settlementDays, cal, bdc, new DayCounter());
    }

    public VolatilityTermStructure(int settlementDays, Calendar cal, BusinessDayConvention bdc, DayCounter dc) {
        super(settlementDays, cal, dc);
        this.bdc = bdc;
    }

    public BusinessDayConvention businessDayConvention() {
        return this.bdc;
    }

    public Date optionDateFromTenor(Period p) {
        return this.calendar().advance(this.referenceDate(), p, this.businessDayConvention());
    }

    public abstract double minStrike();

    public abstract double maxStrike();

    protected void checkStrike(double strike, boolean extrapolate) {
        QL.require(extrapolate || this.allowsExtrapolation() || strike >= this.minStrike() && strike <= this.maxStrike(), "strike is outside the curve domain");
    }
}

