/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.termstructures.volatilities;

import org.jquantlib.QL;
import org.jquantlib.daycounters.DayCounter;
import org.jquantlib.math.interpolations.Interpolation;
import org.jquantlib.math.interpolations.Interpolation2D;
import org.jquantlib.math.interpolations.factories.Bilinear;
import org.jquantlib.math.matrixutilities.Array;
import org.jquantlib.math.matrixutilities.Matrix;
import org.jquantlib.termstructures.BlackVarianceTermStructure;
import org.jquantlib.time.Date;
import org.jquantlib.util.PolymorphicVisitor;
import org.jquantlib.util.Visitor;

public class BlackVarianceSurface
extends BlackVarianceTermStructure {
    private final DayCounter dayCounter;
    private final Date maxDate;
    private final Array times;
    private Array strikes;
    private final Matrix variances;
    private Interpolation2D varianceSurface;
    private final Extrapolation lowerExtrapolation;
    private final Extrapolation upperExtrapolation;
    private final Interpolation2D.Interpolator2D factory;

    public BlackVarianceSurface(Date referenceDate, Date[] dates, Array strikes, Matrix blackVolMatrix, DayCounter dayCounter) {
        this(referenceDate, dates, strikes, blackVolMatrix, dayCounter, Extrapolation.InterpolatorDefaultExtrapolation, Extrapolation.InterpolatorDefaultExtrapolation);
    }

    public BlackVarianceSurface(Date referenceDate, Date[] dates, Array strikes, Matrix blackVolMatrix, DayCounter dayCounter, Extrapolation lowerExtrapolation, Extrapolation upperExtrapolation) {
        super(referenceDate);
        QL.require(dates.length == blackVolMatrix.columns(), "mismatch between date vector and vol matrix colums");
        QL.require(strikes.size() == blackVolMatrix.rows(), "mismatch between money-strike vector and vol matrix rows");
        QL.require(dates[0].gt(referenceDate), "cannot have dates[0] <= referenceDate");
        this.dayCounter = dayCounter;
        this.maxDate = dates[dates.length - 1];
        this.strikes = strikes.clone();
        this.lowerExtrapolation = lowerExtrapolation;
        this.upperExtrapolation = upperExtrapolation;
        this.times = new Array(dates.length + 1);
        this.variances = new Matrix(strikes.size(), dates.length + 1);
        this.strikes = new Array(strikes.size() + 1);
        for (int i = 1; i < strikes.size() + 1; ++i) {
            this.strikes.set(i, strikes.get(i - 1));
        }
        for (int j = 1; j <= blackVolMatrix.columns(); ++j) {
            this.times.set(j, this.timeFromReference(dates[j - 1]));
            QL.require(this.times.get(j) > this.times.get(j - 1), "dates must be sorted unique!");
            for (int i = 0; i < blackVolMatrix.rows(); ++i) {
                double elem = blackVolMatrix.get(i, j - 1);
                double ijvar = this.times.get(j) * elem * elem;
                this.variances.set(i, j, ijvar);
                QL.require(ijvar >= this.variances.get(i, j - 1), "variance must be non-decreasing");
            }
        }
        this.factory = new Bilinear();
    }

    public void setInterpolation(Interpolation.Interpolator i) {
        this.varianceSurface = this.factory.interpolate(this.times, this.strikes, this.variances);
        this.varianceSurface.enableExtrapolation();
        this.varianceSurface.update();
        this.notifyObservers();
    }

    @Override
    public final DayCounter dayCounter() {
        return this.dayCounter;
    }

    @Override
    public final Date maxDate() {
        return this.maxDate;
    }

    @Override
    public final double minStrike() {
        return this.strikes.first();
    }

    @Override
    public final double maxStrike() {
        return this.strikes.last();
    }

    @Override
    protected final double blackVarianceImpl(double t, double strike) {
        if (t == 0.0) {
            return 0.0;
        }
        if (strike < this.strikes.first() && this.lowerExtrapolation == Extrapolation.ConstantExtrapolation) {
            strike = this.strikes.first();
        }
        if (strike > this.strikes.last() && this.upperExtrapolation == Extrapolation.ConstantExtrapolation) {
            strike = this.strikes.last();
        }
        if (t <= this.times.last()) {
            return this.varianceSurface.op(t, strike);
        }
        double lastTime = this.times.last();
        return this.varianceSurface.op(lastTime, strike) * t / lastTime;
    }

    @Override
    public void accept(PolymorphicVisitor pv) {
        Visitor<?> v;
        Visitor<?> visitor = v = pv != null ? pv.visitor(this.getClass()) : null;
        if (v != null) {
            v.visit(this);
        } else {
            super.accept(pv);
        }
    }

    public static enum Extrapolation {
        ConstantExtrapolation,
        InterpolatorDefaultExtrapolation;

    }
}

