/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.termstructures;

import org.jquantlib.daycounters.DayCounter;
import org.jquantlib.lang.annotation.Natural;
import org.jquantlib.lang.annotation.Rate;
import org.jquantlib.lang.annotation.Time;
import org.jquantlib.quotes.Handle;
import org.jquantlib.termstructures.InflationTermStructure;
import org.jquantlib.termstructures.YieldTermStructure;
import org.jquantlib.time.Calendar;
import org.jquantlib.time.Date;
import org.jquantlib.time.Frequency;
import org.jquantlib.time.Period;

public abstract class ZeroInflationTermStructure
extends InflationTermStructure {
    public ZeroInflationTermStructure(DayCounter dayCounter, Period lag, Frequency frequency, @Rate double baseZeroRate, Handle<YieldTermStructure> yTS) {
        super(lag, frequency, baseZeroRate, yTS, dayCounter);
    }

    public ZeroInflationTermStructure(Date referenceDate, Calendar calendar, DayCounter dayCounter, Period lag, Frequency frequency, @Rate double baseZeroRate, Handle<YieldTermStructure> yTS) {
        super(referenceDate, lag, frequency, baseZeroRate, yTS, calendar, dayCounter);
    }

    public ZeroInflationTermStructure(@Natural int settlementDays, Calendar calendar, DayCounter dayCounter, Period lag, Frequency frequency, @Rate double baseZeroRate, Handle<YieldTermStructure> yTS) {
        super(settlementDays, calendar, lag, frequency, baseZeroRate, yTS, dayCounter);
    }

    public double zeroRate(Date date) {
        return this.zeroRate(date, false);
    }

    public double zeroRate(Date date, boolean extrapolate) {
        this.checkRange(date, extrapolate);
        return this.zeroRateImpl(this.timeFromReference(date));
    }

    public double zeroRate(@Time double time) {
        return this.zeroRate(time, false);
    }

    public double zeroRate(@Time double time, boolean extrapolate) {
        this.checkRange(time, extrapolate);
        return this.zeroRateImpl(time);
    }

    protected abstract double zeroRateImpl(@Time double var1);
}

