/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.termstructures;

import java.util.Arrays;
import org.jquantlib.QL;
import org.jquantlib.math.matrixutilities.Array;
import org.jquantlib.math.optimization.Constraint;
import org.jquantlib.math.optimization.CostFunction;
import org.jquantlib.math.optimization.EndCriteria;
import org.jquantlib.math.optimization.LevenbergMarquardt;
import org.jquantlib.math.optimization.NoConstraint;
import org.jquantlib.math.optimization.PositiveConstraint;
import org.jquantlib.termstructures.BootstrapHelperSorter;
import org.jquantlib.termstructures.YieldTermStructure;
import org.jquantlib.termstructures.yieldcurves.PiecewiseYieldCurve;
import org.jquantlib.time.Date;
import org.jquantlib.util.Observer;

public class LocalBootstrap<Curve extends PiecewiseYieldCurve> {
    private Curve ts_;
    private final int localisation_;
    private final boolean forcePositive_;
    private boolean validCurve_;

    public LocalBootstrap() {
        this(2, true);
    }

    public LocalBootstrap(int localisation) {
        this(localisation, true);
    }

    public LocalBootstrap(int localisation, boolean forcePositive) {
        QL.validateExperimentalMode();
        this.validCurve_ = false;
        this.ts_ = null;
        this.localisation_ = localisation;
        this.forcePositive_ = forcePositive;
    }

    public void setup(Curve ts) {
        this.ts_ = ts;
        int n = ((PiecewiseYieldCurve)this.ts_).instruments().length;
        QL.require(n >= ((PiecewiseYieldCurve)ts).interpolator().requiredPoints(), "not enough instruments: %d provided, %d required", n, ((PiecewiseYieldCurve)ts).interpolator().requiredPoints());
        QL.require(n > this.localisation_, "not enough instruments: %d provided, %d required.", n, this.localisation_);
        for (int i = 0; i < n; ++i) {
            ((PiecewiseYieldCurve)this.ts_).instruments()[i].addObserver((Observer)this.ts_);
        }
    }

    public void calculate() {
        int i;
        this.validCurve_ = false;
        int nInsts = ((PiecewiseYieldCurve)this.ts_).instruments().length;
        Arrays.sort(((PiecewiseYieldCurve)this.ts_).instruments(), new BootstrapHelperSorter());
        for (i = 1; i < nInsts; ++i) {
            Date m2;
            Date m1 = ((PiecewiseYieldCurve)this.ts_).instruments()[i - 1].latestDate();
            QL.require(m1 != (m2 = ((PiecewiseYieldCurve)this.ts_).instruments()[i].latestDate()), "two instruments have the same maturity");
        }
        for (i = 0; i < nInsts; ++i) {
            QL.require(((PiecewiseYieldCurve)this.ts_).instruments()[i].quoteIsValid(), " instrument #%d (maturity: %s) has infalic quote", i + 1, ((PiecewiseYieldCurve)this.ts_).instruments()[i].latestDate());
        }
        for (i = 0; i < nInsts; ++i) {
            ((PiecewiseYieldCurve)this.ts_).instruments()[i].setTermStructure(this.ts_);
        }
        if (this.validCurve_) {
            QL.ensure(((PiecewiseYieldCurve)this.ts_).data().length == nInsts + 1, "dimension mismatch: expected %d, actual %d", nInsts + 1, ((PiecewiseYieldCurve)this.ts_).data().length);
        } else {
            double[] data = new double[nInsts + 1];
            data[0] = ((PiecewiseYieldCurve)this.ts_).traits().initialValue((YieldTermStructure)this.ts_);
            ((PiecewiseYieldCurve)this.ts_).setData(data);
        }
        Date[] dates = new Date[nInsts + 1];
        dates[0] = ((PiecewiseYieldCurve)this.ts_).traits().initialDate((YieldTermStructure)this.ts_);
        ((PiecewiseYieldCurve)this.ts_).setDates(dates);
        double[] times = new double[nInsts + 1];
        times[0] = ((PiecewiseYieldCurve)this.ts_).timeFromReference(((PiecewiseYieldCurve)this.ts_).dates()[0]);
        ((PiecewiseYieldCurve)this.ts_).setTimes(times);
        for (int i2 = 0; i2 < nInsts; ++i2) {
            ((PiecewiseYieldCurve)this.ts_).dates()[i2 + 1] = ((PiecewiseYieldCurve)this.ts_).instruments()[i2].latestDate();
            ((PiecewiseYieldCurve)this.ts_).times()[i2 + 1] = ((PiecewiseYieldCurve)this.ts_).timeFromReference(((PiecewiseYieldCurve)this.ts_).dates()[i2 + 1]);
            if (this.validCurve_) continue;
            ((PiecewiseYieldCurve)this.ts_).data()[i2 + 1] = ((PiecewiseYieldCurve)this.ts_).data()[i2];
        }
        LevenbergMarquardt solver = new LevenbergMarquardt(((PiecewiseYieldCurve)this.ts_).accuracy(), ((PiecewiseYieldCurve)this.ts_).accuracy(), ((PiecewiseYieldCurve)this.ts_).accuracy());
        EndCriteria endCriteria = new EndCriteria(100, 10, 0.0, ((PiecewiseYieldCurve)this.ts_).accuracy(), 0.0);
        Constraint solverConstraint = this.forcePositive_ ? new PositiveConstraint() : new NoConstraint();
        int iInst = this.localisation_ - 1;
        this.validCurve_ = true;
    }

    private class PenaltyFunction
    extends CostFunction {
        private final int initialIndex;
        private final int rateHelpersStart;
        private final int rateHelpersEnd;
        private final int penaltylocalisation;

        private PenaltyFunction(int initialIndex, int rateHelpersStart, int rateHelpersEnd) {
            this.initialIndex = initialIndex;
            this.rateHelpersStart = rateHelpersStart;
            this.rateHelpersEnd = rateHelpersEnd;
            this.penaltylocalisation = rateHelpersEnd - rateHelpersStart;
        }

        @Override
        public double value(Array x) {
            int i = this.initialIndex;
            int guessIt = 0;
            while (guessIt < x.size()) {
                LocalBootstrap.this.ts_.traits().updateGuess(LocalBootstrap.this.ts_.data(), guessIt, i);
                ++guessIt;
                ++i;
            }
            LocalBootstrap.this.ts_.interpolation().update();
            double penalty = 0.0;
            for (int j = this.rateHelpersStart; j != this.rateHelpersEnd; ++j) {
                penalty += Math.abs(LocalBootstrap.this.ts_.instruments()[j].quoteError());
            }
            return penalty;
        }

        @Override
        public Array values(Array x) {
            int guessIt = 0;
            int i = this.initialIndex;
            while (guessIt < x.size()) {
                LocalBootstrap.this.ts_.traits().updateGuess(LocalBootstrap.this.ts_.data(), x.get(guessIt), i);
                ++guessIt;
                ++i;
            }
            LocalBootstrap.this.ts_.interpolation().update();
            Array penalties = new Array(this.penaltylocalisation);
            int instIterator = this.rateHelpersStart;
            int penIt = 0;
            while (instIterator != this.rateHelpersEnd) {
                penalties.set(penIt, Math.abs(LocalBootstrap.this.ts_.instruments()[instIterator].quoteError()));
                ++instIterator;
                ++penIt;
            }
            return penalties;
        }
    }
}

