/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.termstructures;

import org.jquantlib.daycounters.Actual365Fixed;
import org.jquantlib.daycounters.DayCounter;
import org.jquantlib.lang.annotation.Natural;
import org.jquantlib.lang.annotation.Rate;
import org.jquantlib.lang.exceptions.LibraryException;
import org.jquantlib.quotes.Handle;
import org.jquantlib.termstructures.AbstractTermStructure;
import org.jquantlib.termstructures.YieldTermStructure;
import org.jquantlib.time.Calendar;
import org.jquantlib.time.Date;
import org.jquantlib.time.Frequency;
import org.jquantlib.time.Month;
import org.jquantlib.time.Period;
import org.jquantlib.time.calendars.NullCalendar;
import org.jquantlib.util.Pair;

public abstract class InflationTermStructure
extends AbstractTermStructure {
    protected Handle<YieldTermStructure> nominalTermStructure;
    protected Period lag;
    protected Frequency frequency;
    @Rate
    protected double baseRate;

    public InflationTermStructure(Period lag, Frequency frequency, @Rate double baseRate, Handle<YieldTermStructure> yTS) {
        this(lag, frequency, baseRate, yTS, new Actual365Fixed());
    }

    public InflationTermStructure(Period lag, Frequency frequency, @Rate double baseRate, Handle<YieldTermStructure> yTS, DayCounter dayCounter) {
        super(dayCounter);
        this.nominalTermStructure = yTS;
        this.lag = lag;
        this.frequency = frequency;
        this.baseRate = baseRate;
        this.nominalTermStructure.addObserver(this);
    }

    public InflationTermStructure(Date referenceDate, Period lag, Frequency frequency, @Rate double baseRate, Handle<YieldTermStructure> yTS) {
        this(referenceDate, lag, frequency, baseRate, yTS, new NullCalendar(), (DayCounter)new Actual365Fixed());
    }

    public InflationTermStructure(Date referenceDate, Period lag, Frequency frequency, @Rate double baseRate, Handle<YieldTermStructure> yTS, Calendar calendar, DayCounter dayCounter) {
        super(referenceDate, calendar, dayCounter);
        this.nominalTermStructure = yTS;
        this.lag = lag;
        this.frequency = frequency;
        this.baseRate = baseRate;
        this.nominalTermStructure.addObserver(this);
    }

    public InflationTermStructure(@Natural int settlementDays, Calendar calendar, Period lag, Frequency frequency, @Rate double baseRate, Handle<YieldTermStructure> yTS) {
        this(settlementDays, calendar, lag, frequency, baseRate, yTS, (DayCounter)new Actual365Fixed());
    }

    public InflationTermStructure(@Natural int settlementDays, Calendar calendar, Period lag, Frequency frequency, @Rate double baseRate, Handle<YieldTermStructure> yTS, DayCounter dayCounter) {
        super(settlementDays, calendar, dayCounter);
        this.nominalTermStructure = yTS;
        this.lag = lag;
        this.frequency = frequency;
        this.baseRate = baseRate;
        this.nominalTermStructure.addObserver(this);
    }

    public Period lag() {
        return this.lag;
    }

    public Frequency frequency() {
        return this.frequency;
    }

    public Handle<YieldTermStructure> nominalTermStructure() {
        return this.nominalTermStructure;
    }

    public double baseRate() {
        return this.baseRate;
    }

    public Date baseDate() {
        return new Date(0L);
    }

    @Override
    public Date maxDate() {
        return new Date(0L);
    }

    protected void setBaseRate(@Rate double r) {
        this.baseRate = r;
    }

    public static Pair<Date, Date> inflationPeriod(Date date, Frequency frequency) {
        Month endMonth;
        Month startMonth;
        Month month = date.month();
        int year = date.year();
        switch (frequency) {
            case Annual: {
                startMonth = Month.January;
                endMonth = Month.December;
                break;
            }
            case Semiannual: {
                startMonth = Month.valueOf(6 * (month.value() - 1) / 6 + 1);
                endMonth = Month.valueOf(startMonth.value() + 5);
                break;
            }
            case Quarterly: {
                startMonth = Month.valueOf(3 * (month.value() - 1) / 3 + 1);
                endMonth = Month.valueOf(startMonth.value() + 2);
                break;
            }
            case Monthly: {
                startMonth = endMonth = month;
                break;
            }
            default: {
                throw new LibraryException("Frequency not handled: " + (Object)((Object)frequency));
            }
        }
        Date startDate = new Date(1, startMonth, year);
        Date endDate = Date.endOfMonth(new Date(1, endMonth, year));
        return new Pair<Date, Date>(startDate, endDate);
    }
}

