/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.termstructures;

import org.jquantlib.daycounters.DayCounter;
import org.jquantlib.termstructures.BlackVolTermStructure;
import org.jquantlib.time.BusinessDayConvention;
import org.jquantlib.time.Calendar;
import org.jquantlib.time.Date;
import org.jquantlib.util.PolymorphicVisitor;
import org.jquantlib.util.Visitor;

public abstract class BlackVarianceTermStructure
extends BlackVolTermStructure {
    public BlackVarianceTermStructure() {
        this(new Calendar(), BusinessDayConvention.Following, new DayCounter());
    }

    public BlackVarianceTermStructure(Calendar cal) {
        this(cal, BusinessDayConvention.Following, new DayCounter());
    }

    public BlackVarianceTermStructure(Calendar cal, BusinessDayConvention bdc) {
        this(cal, bdc, new DayCounter());
    }

    public BlackVarianceTermStructure(Calendar cal, BusinessDayConvention bdc, DayCounter dc) {
        super(cal, bdc, dc);
    }

    public BlackVarianceTermStructure(Date referenceDate) {
        this(referenceDate, new Calendar(), BusinessDayConvention.Following, new DayCounter());
    }

    public BlackVarianceTermStructure(Date referenceDate, Calendar cal) {
        this(referenceDate, cal, BusinessDayConvention.Following, new DayCounter());
    }

    public BlackVarianceTermStructure(Date referenceDate, Calendar cal, BusinessDayConvention bdc) {
        this(referenceDate, cal, bdc, new DayCounter());
    }

    public BlackVarianceTermStructure(Date referenceDate, Calendar cal, BusinessDayConvention bdc, DayCounter dc) {
        super(referenceDate, cal, bdc, dc);
    }

    public BlackVarianceTermStructure(int settlementDays, Calendar cal) {
        this(settlementDays, cal, BusinessDayConvention.Following, new DayCounter());
    }

    public BlackVarianceTermStructure(int settlementDays, Calendar cal, BusinessDayConvention bdc) {
        this(settlementDays, cal, bdc, new DayCounter());
    }

    public BlackVarianceTermStructure(int settlementDays, Calendar cal, BusinessDayConvention bdc, DayCounter dc) {
        super(settlementDays, cal, bdc, dc);
    }

    @Override
    protected final double blackVolImpl(double maturity, double strike) {
        double m = maturity;
        double nonZeroMaturity = m == 0.0 ? 1.0E-5 : m;
        double var = this.blackVarianceImpl(nonZeroMaturity, strike);
        return Math.sqrt(var / nonZeroMaturity);
    }

    @Override
    public void accept(PolymorphicVisitor pv) {
        Visitor<?> v;
        Visitor<?> visitor = v = pv != null ? pv.visitor(this.getClass()) : null;
        if (v != null) {
            v.visit(this);
        } else {
            super.accept(pv);
        }
    }
}

