/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.processes;

import org.jquantlib.QL;
import org.jquantlib.math.Constants;
import org.jquantlib.processes.StochasticProcess1D;

public class OrnsteinUhlenbeckProcess
extends StochasticProcess1D {
    private static final String NEGATIVE_SPEED_GIVEN = "negative speed given";
    private static final String NEGATIVE_VOLATILITY_GIVEN = "negative volatilty given";
    private final double x0_;
    private final double speed_;
    private final double level_;
    private final double volatility_;

    public OrnsteinUhlenbeckProcess(double speed, double vol) {
        this(speed, vol, 0.0, 0.0);
    }

    public OrnsteinUhlenbeckProcess(double speed, double vol, double x0) {
        this(speed, vol, x0, 0.0);
    }

    public OrnsteinUhlenbeckProcess(double speed, double vol, double x0, double level) {
        QL.require(speed >= 0.0, NEGATIVE_SPEED_GIVEN);
        QL.require(vol >= 0.0, NEGATIVE_VOLATILITY_GIVEN);
        this.x0_ = x0;
        this.speed_ = speed;
        this.level_ = level;
        this.volatility_ = vol;
    }

    public double speed() {
        return this.speed_;
    }

    public double volatility() {
        return this.volatility_;
    }

    public double level() {
        return this.level_;
    }

    @Override
    public double x0() {
        return this.x0_;
    }

    @Override
    public double drift(double t, double x) {
        return this.speed_ * (this.level_ - x);
    }

    @Override
    public double diffusion(double t, double x) {
        return this.volatility_;
    }

    @Override
    public double expectation(double t0, double x0, double dt) {
        return this.level_ + (x0 - this.level_) * Math.exp(-this.speed_ * dt);
    }

    @Override
    public double stdDeviation(double t0, double x0, double dt) {
        return Math.sqrt(this.variance(t0, x0, dt));
    }

    @Override
    public double variance(double t0, double x0, double dt) {
        if (this.speed_ < Math.sqrt(Constants.QL_EPSILON)) {
            return this.volatility_ * this.volatility_ * dt;
        }
        return 0.5 * this.volatility_ * this.volatility_ / this.speed_ * (1.0 - Math.exp(-2.0 * this.speed_ * dt));
    }
}

