/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.processes;

import org.jquantlib.lang.exceptions.LibraryException;
import org.jquantlib.processes.BlackScholesMertonProcess;
import org.jquantlib.processes.EulerDiscretization;
import org.jquantlib.processes.GeneralizedBlackScholesProcess;
import org.jquantlib.processes.StochasticProcess1D;
import org.jquantlib.quotes.Handle;
import org.jquantlib.quotes.Quote;
import org.jquantlib.termstructures.BlackVolTermStructure;
import org.jquantlib.termstructures.YieldTermStructure;
import org.jquantlib.time.Date;

public class Merton76Process
extends StochasticProcess1D {
    private final GeneralizedBlackScholesProcess blackProcess;
    private final Handle<? extends Quote> jumpIntensity;
    private final Handle<? extends Quote> logMeanJump;
    private final Handle<? extends Quote> logJumpVolatility;

    public Merton76Process(Handle<? extends Quote> stateVariable, Handle<YieldTermStructure> dividendTS, Handle<YieldTermStructure> riskFreeTS, Handle<BlackVolTermStructure> blackVolTS, Handle<? extends Quote> jumpInt, Handle<? extends Quote> logJMean, Handle<? extends Quote> logJVol) {
        this.blackProcess = new BlackScholesMertonProcess(stateVariable, dividendTS, riskFreeTS, blackVolTS, new EulerDiscretization());
        this.jumpIntensity = jumpInt;
        this.logJumpVolatility = logJVol;
        this.logMeanJump = logJMean;
        this.blackProcess.addObserver(this);
        this.jumpIntensity.addObserver(this);
        this.logJumpVolatility.addObserver(this);
        this.logMeanJump.addObserver(this);
    }

    public Handle<? extends Quote> stateVariable() {
        return this.blackProcess.stateVariable();
    }

    public Handle<YieldTermStructure> dividendYield() {
        return this.blackProcess.dividendYield();
    }

    public Handle<YieldTermStructure> riskFreeRate() {
        return this.blackProcess.riskFreeRate();
    }

    public Handle<BlackVolTermStructure> blackVolatility() {
        return this.blackProcess.blackVolatility();
    }

    public Handle<? extends Quote> jumpIntensity() {
        return this.jumpIntensity;
    }

    public Handle<? extends Quote> logMeanJump() {
        return this.logMeanJump;
    }

    public Handle<? extends Quote> logJumpVolatility() {
        return this.logJumpVolatility;
    }

    @Override
    public double x0() {
        return this.blackProcess.x0();
    }

    @Override
    public double drift(double t, double x) {
        throw new LibraryException("not implemented");
    }

    @Override
    public double diffusion(double t, double x) {
        throw new LibraryException("not implemented");
    }

    @Override
    public double apply(double x, double y) {
        throw new LibraryException("not implemented");
    }

    @Override
    public double time(Date d) {
        return this.blackProcess.time(d);
    }
}

