/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.processes;

import java.util.ArrayList;
import java.util.List;
import org.jquantlib.QL;
import org.jquantlib.cashflow.IborCoupon;
import org.jquantlib.daycounters.DayCounter;
import org.jquantlib.indexes.IborIndex;
import org.jquantlib.math.matrixutilities.Array;
import org.jquantlib.math.matrixutilities.Matrix;
import org.jquantlib.processes.EulerDiscretization;
import org.jquantlib.processes.LfmCovarianceParameterization;
import org.jquantlib.processes.StochasticProcess;
import org.jquantlib.time.Date;

public class LiborForwardModelProcess
extends StochasticProcess {
    private static final String wrong_number_of_cashflows = "wrong number of cashflows";
    private static final String irregular_coupon_types = "irregular coupon types are not suppported";
    private final int size_;
    private final IborIndex index_;
    private LfmCovarianceParameterization lfmParam_;
    private final Array initialValues_;
    private final List<Double> fixingTimes_;
    private final List<Date> fixingDates_;
    private final List<Double> accrualStartTimes_;
    private final List<Double> accrualEndTimes_;
    private final List<Double> accrualPeriod_;
    private final Array m1;
    private final Array m2;

    public LiborForwardModelProcess(int size, IborIndex index) {
        super(new EulerDiscretization());
        if (System.getProperty("EXPERIMENTAL") == null) {
            throw new UnsupportedOperationException("Work in progress");
        }
        this.size_ = size;
        this.index_ = index;
        this.initialValues_ = new Array(this.size_);
        this.fixingDates_ = new ArrayList<Date>(this.size_);
        this.fixingTimes_ = new ArrayList<Double>(this.size_);
        this.accrualStartTimes_ = new ArrayList<Double>(this.size_);
        this.accrualEndTimes_ = new ArrayList<Double>(this.size_);
        this.accrualPeriod_ = new ArrayList<Double>(this.size_);
        this.m1 = new Array(this.size_);
        this.m2 = new Array(this.size_);
        DayCounter dayCounter = this.index_.dayCounter();
        List flows = null;
        QL.require(this.size_ == flows.size(), wrong_number_of_cashflows);
        Date settlement = this.index_.termStructure().currentLink().referenceDate();
        Date startDate = ((IborCoupon)flows.get(0)).fixingDate();
        for (int i = 0; i < this.size_; ++i) {
            IborCoupon coupon = (IborCoupon)flows.get(i);
            QL.require(coupon.date().eq(coupon.accrualEndDate()), irregular_coupon_types);
            this.initialValues_.set(i, coupon.rate());
            this.accrualPeriod_.set(i, coupon.accrualPeriod());
            this.fixingDates_.set(i, coupon.fixingDate());
            this.fixingTimes_.set(i, dayCounter.yearFraction(startDate, coupon.fixingDate()));
            this.accrualStartTimes_.set(i, dayCounter.yearFraction(settlement, coupon.accrualStartDate()));
            this.accrualEndTimes_.set(i, dayCounter.yearFraction(settlement, coupon.accrualEndDate()));
        }
    }

    public void setCovarParam(LfmCovarianceParameterization param) {
        this.lfmParam_ = param;
    }

    public LfmCovarianceParameterization covarParam() {
        return this.lfmParam_;
    }

    public IborIndex index() {
        return this.index_;
    }

    @Override
    public Array initialValues() {
        return this.initialValues_.clone();
    }

    @Override
    public int size() {
        return 0;
    }

    @Override
    public Array drift(double t, Array x) {
        Array f = new Array(this.size_);
        Matrix covariance = this.lfmParam_.covariance(t, x);
        boolean m = false;
        for (int k = 0; k < this.size_; ++k) {
            this.m1.set(k, this.accrualPeriod_.get(k) * x.get(k) / (1.0 + this.accrualPeriod_.get(k) * x.get(k)));
            double value = this.m1.innerProduct(covariance.constRangeCol(k), 0, k + 1 - 0) - 0.5 * covariance.get(k, k);
            f.set(k, value);
        }
        return f;
    }

    @Override
    public Matrix diffusion(double t, Array x) {
        return this.lfmParam_.diffusion(t, x);
    }

    @Override
    public Matrix covariance(double t, Array x, double dt) {
        return this.lfmParam_.covariance(dt, x).mul(this.lfmParam_.covariance(dt, x).mulAssign(dt));
    }

    @Override
    public Array apply(Array x0, Array dx) {
        Array tmp = new Array(this.size_);
        for (int k = 0; k < this.size_; ++k) {
            tmp.set(k, x0.get(k) * Math.exp(dx.get(k)));
        }
        return tmp;
    }

    @Override
    public Array evolve(double t0, Array x0, double dt, Array dw) {
        throw new UnsupportedOperationException("work in progress");
    }
}

