/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.processes;

import org.jquantlib.lang.exceptions.LibraryException;
import org.jquantlib.math.Constants;
import org.jquantlib.math.distributions.CumulativeNormalDistribution;
import org.jquantlib.math.matrixutilities.Array;
import org.jquantlib.math.matrixutilities.Matrix;
import org.jquantlib.processes.StochasticProcess;
import org.jquantlib.quotes.Handle;
import org.jquantlib.quotes.Quote;
import org.jquantlib.quotes.RelinkableHandle;
import org.jquantlib.quotes.SimpleQuote;
import org.jquantlib.termstructures.Compounding;
import org.jquantlib.termstructures.YieldTermStructure;
import org.jquantlib.time.Date;

public class HestonProcess
extends StochasticProcess {
    private final Handle<YieldTermStructure> riskFreeRate_;
    private final Handle<YieldTermStructure> dividendYield_;
    private final Handle<Quote> s0_;
    private final RelinkableHandle<Quote> v0_;
    private final RelinkableHandle<Quote> kappa_;
    private final RelinkableHandle<Quote> theta_;
    private final RelinkableHandle<Quote> sigma_;
    private final RelinkableHandle<Quote> rho_;
    private final Discretization discretization_;
    private double s0v_;
    private double v0v_;
    private double kappav_;
    private double thetav_;
    private double sigmav_;
    private double rhov_;
    private double sqrhov_;

    public HestonProcess(Handle<YieldTermStructure> riskFreeRate, Handle<YieldTermStructure> dividendYield, Handle<Quote> s0, double v0, double kappa, double theta, double sigma, double rho) {
        this(riskFreeRate, dividendYield, s0, v0, kappa, theta, sigma, rho, Discretization.FullTruncation);
    }

    public HestonProcess(Handle<YieldTermStructure> riskFreeRate, Handle<YieldTermStructure> dividendYield, Handle<Quote> s0, double v0, double kappa, double theta, double sigma, double rho, Discretization d) {
        if (System.getProperty("EXPERIMENTAL") == null) {
            throw new UnsupportedOperationException("Work in progress");
        }
        this.riskFreeRate_ = riskFreeRate;
        this.dividendYield_ = dividendYield;
        this.s0_ = s0;
        this.v0_ = new RelinkableHandle<SimpleQuote>(new SimpleQuote(v0));
        this.kappa_ = new RelinkableHandle<SimpleQuote>(new SimpleQuote(kappa));
        this.theta_ = new RelinkableHandle<SimpleQuote>(new SimpleQuote(theta));
        this.sigma_ = new RelinkableHandle<SimpleQuote>(new SimpleQuote(sigma));
        this.rho_ = new RelinkableHandle<SimpleQuote>(new SimpleQuote(rho));
        this.discretization_ = d;
        this.riskFreeRate_.addObserver(this);
        this.dividendYield_.addObserver(this);
        this.s0_.addObserver(this);
    }

    @Override
    public void update() {
        this.s0v_ = this.s0_.currentLink().value();
        this.v0v_ = ((Quote)this.v0_.currentLink()).value();
        this.kappav_ = ((Quote)this.kappa_.currentLink()).value();
        this.thetav_ = ((Quote)this.theta_.currentLink()).value();
        this.sigmav_ = ((Quote)this.sigma_.currentLink()).value();
        this.rhov_ = ((Quote)this.rho_.currentLink()).value();
        this.sqrhov_ = Math.sqrt(1.0 - this.rhov_ * this.rhov_);
    }

    public final RelinkableHandle<Quote> v0() {
        return this.v0_;
    }

    public final RelinkableHandle<Quote> rho() {
        return this.rho_;
    }

    public final RelinkableHandle<Quote> kappa() {
        return this.kappa_;
    }

    public final RelinkableHandle<Quote> theta() {
        return this.theta_;
    }

    public final RelinkableHandle<Quote> sigma() {
        return this.sigma_;
    }

    public final Handle<Quote> s0() {
        return this.s0_;
    }

    public final Handle<YieldTermStructure> dividendYield() {
        return this.dividendYield_;
    }

    public Handle<YieldTermStructure> riskFreeRate() {
        return this.riskFreeRate_;
    }

    @Override
    public Array initialValues() {
        return new Array(new double[]{this.s0v_, this.v0v_});
    }

    @Override
    public int size() {
        return 2;
    }

    @Override
    public final double time(Date d) {
        return this.riskFreeRate_.currentLink().dayCounter().yearFraction(this.riskFreeRate_.currentLink().referenceDate(), d);
    }

    @Override
    public Array drift(double t, Array x) {
        double x1 = x.get(1);
        double vol = x1 > 0.0 ? Math.sqrt(x1) : (this.discretization_ == Discretization.PartialTruncation ? -Math.sqrt(-x1) : 0.0);
        double[] result = new double[]{this.riskFreeRate_.currentLink().forwardRate(t, t, Compounding.Continuous).rate() - this.dividendYield_.currentLink().forwardRate(t, t, Compounding.Continuous).rate() - 0.5 * vol * vol, this.kappav_ * (this.thetav_ - (this.discretization_ == Discretization.PartialTruncation ? x1 : vol * vol))};
        return new Array(result);
    }

    @Override
    public Matrix diffusion(double time, Array x) {
        double x1 = x.get(1);
        double vol = x1 > 0.0 ? Math.sqrt(x1) : (this.discretization_ == Discretization.Reflection ? -Math.sqrt(-x1) : 0.0);
        double sigma2 = this.sigmav_ * vol;
        Matrix result = new Matrix(2, 2);
        result.set(0, 0, vol);
        result.set(0, 1, 0.0);
        result.set(1, 0, this.rhov_ * sigma2);
        result.set(1, 1, this.sqrhov_ * sigma2);
        return result;
    }

    @Override
    public Array apply(Array x0, Array dx) {
        double[] tmp = new double[]{x0.get(0) * Math.exp(dx.get(0)), x0.get(1) + dx.get(1)};
        return new Array(tmp);
    }

    @Override
    public Array evolve(double t0, Array x0, double dt, Array dw) {
        double[] retVal = new double[2];
        double sdt = Math.sqrt(dt);
        double x00 = x0.get(0);
        double x01 = x0.get(1);
        double dw0 = dw.get(0);
        double dw1 = dw.get(1);
        switch (this.discretization_) {
            case PartialTruncation: {
                double vol = x01 > 0.0 ? Math.sqrt(x01) : 0.0;
                double vol2 = this.sigmav_ * vol;
                double mu = this.riskFreeRate_.currentLink().forwardRate(t0, t0, Compounding.Continuous).rate() - this.dividendYield_.currentLink().forwardRate(t0, t0, Compounding.Continuous).rate() - 0.5 * vol * vol;
                double nu = this.kappav_ * (this.thetav_ - x01);
                retVal[0] = x00 * Math.exp(mu * dt + vol * dw0 * sdt);
                retVal[1] = x01 + nu * dt + vol2 * sdt * (this.rhov_ * dw0 + this.sqrhov_ * dw1);
                break;
            }
            case FullTruncation: {
                double vol = x01 > 0.0 ? Math.sqrt(x01) : 0.0;
                double vol2 = this.sigmav_ * vol;
                double mu = this.riskFreeRate_.currentLink().forwardRate(t0, t0, Compounding.Continuous).rate() - this.dividendYield_.currentLink().forwardRate(t0, t0, Compounding.Continuous).rate() - 0.5 * vol * vol;
                double nu = this.kappav_ * (this.thetav_ - vol * vol);
                retVal[0] = x00 * Math.exp(mu * dt + vol * dw0 * sdt);
                retVal[1] = x01 + nu * dt + vol2 * sdt * (this.rhov_ * dw0 + this.sqrhov_ * dw1);
                break;
            }
            case Reflection: {
                double vol = Math.sqrt(Math.abs(x01));
                double vol2 = this.sigmav_ * vol;
                double mu = this.riskFreeRate_.currentLink().forwardRate(t0, t0, Compounding.Continuous).rate() - this.dividendYield_.currentLink().forwardRate(t0, t0, Compounding.Continuous).rate() - 0.5 * vol * vol;
                double nu = this.kappav_ * (this.thetav_ - vol * vol);
                retVal[0] = x00 * Math.exp(mu * dt + vol * dw0 * sdt);
                retVal[1] = vol * vol + nu * dt + vol2 * sdt * (this.rhov_ * dw0 + this.sqrhov_ * dw1);
                break;
            }
            case ExactVariance: {
                double vol = x01 > 0.0 ? Math.sqrt(x01) : 0.0;
                double mu = this.riskFreeRate_.currentLink().forwardRate(t0, t0, Compounding.Continuous).rate() - this.dividendYield_.currentLink().forwardRate(t0, t0, Compounding.Continuous).rate() - 0.5 * vol * vol;
                double df = 4.0 * this.thetav_ * this.kappav_ / (this.sigmav_ * this.sigmav_);
                double ncp = 4.0 * this.kappav_ * Math.exp(-this.kappav_ * dt) / (this.sigmav_ * this.sigmav_ * (1.0 - Math.exp(-this.kappav_ * dt))) * x01;
                double p = new CumulativeNormalDistribution().op(dw1);
                if (p < 0.0) {
                    p = 0.0;
                } else if (p >= 1.0) {
                    p = 1.0 - Constants.QL_EPSILON;
                }
                retVal[1] = this.sigmav_ * this.sigmav_ * (1.0 - Math.exp(-this.kappav_ * dt)) / (4.0 * this.kappav_);
                throw new UnsupportedOperationException("Work in progress");
            }
            default: {
                throw new LibraryException("unknown discretization schema");
            }
        }
        return new Array(retVal);
    }

    private static enum Discretization {
        PartialTruncation,
        FullTruncation,
        Reflection,
        ExactVariance;

    }
}

