/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.pricingengines.vanilla.finitedifferences;

import java.util.ArrayList;
import org.jquantlib.QL;
import org.jquantlib.cashflow.Dividend;
import org.jquantlib.cashflow.Event;
import org.jquantlib.instruments.DividendVanillaOption;
import org.jquantlib.pricingengines.PricingEngine;
import org.jquantlib.pricingengines.vanilla.finitedifferences.FDMultiPeriodEngine;
import org.jquantlib.processes.GeneralizedBlackScholesProcess;
import org.jquantlib.time.Date;

public abstract class FDDividendEngineBase
extends FDMultiPeriodEngine {
    public FDDividendEngineBase(GeneralizedBlackScholesProcess process) {
        this(process, 100, 100, false);
    }

    public FDDividendEngineBase(GeneralizedBlackScholesProcess process, int timeSteps) {
        this(process, timeSteps, 100, false);
    }

    public FDDividendEngineBase(GeneralizedBlackScholesProcess process, int timeSteps, int gridPoints) {
        this(process, timeSteps, gridPoints, false);
    }

    public FDDividendEngineBase(GeneralizedBlackScholesProcess process, int timeSteps, int gridPoints, boolean timeDependent) {
        super(process, timeSteps, gridPoints, timeDependent);
    }

    @Override
    protected void setupArguments(PricingEngine.Arguments args) {
        QL.require(DividendVanillaOption.ArgumentsImpl.class.isAssignableFrom(args.getClass()), "Unexpected type for type parameter");
        DividendVanillaOption.ArgumentsImpl arguments = (DividendVanillaOption.ArgumentsImpl)args;
        ArrayList<Event> events = new ArrayList<Event>(arguments.cashFlow.size());
        for (Dividend dividend : arguments.cashFlow) {
            events.add(dividend);
        }
        super.setupArguments(args, events);
    }

    protected double getDividendAmount(int i) {
        Dividend dividend = (Dividend)this.events.get(i);
        if (dividend != null) {
            return dividend.amount();
        }
        return 0.0;
    }

    protected double getDiscountedDividend(int i) {
        double dividend = this.getDividendAmount(i);
        Date date = ((Event)this.events.get(i)).date();
        double discount = this.process.riskFreeRate().currentLink().discount(date) / this.process.dividendYield().currentLink().discount(date);
        return dividend * discount;
    }

    @Override
    protected abstract void setGridLimits();

    @Override
    protected abstract void executeIntermediateStep(int var1);
}

