/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.pricingengines.vanilla;

import java.lang.reflect.Constructor;
import org.jquantlib.QL;
import org.jquantlib.daycounters.DayCounter;
import org.jquantlib.experimental.lattices.ExtendedTian;
import org.jquantlib.instruments.OneAssetOption;
import org.jquantlib.instruments.Option;
import org.jquantlib.instruments.PlainVanillaPayoff;
import org.jquantlib.instruments.VanillaOption;
import org.jquantlib.lang.exceptions.LibraryException;
import org.jquantlib.math.matrixutilities.Array;
import org.jquantlib.methods.lattices.BlackScholesLattice;
import org.jquantlib.methods.lattices.Tree;
import org.jquantlib.pricingengines.vanilla.DiscretizedVanillaOption;
import org.jquantlib.processes.GeneralizedBlackScholesProcess;
import org.jquantlib.processes.StochasticProcess1D;
import org.jquantlib.quotes.Handle;
import org.jquantlib.termstructures.BlackVolTermStructure;
import org.jquantlib.termstructures.Compounding;
import org.jquantlib.termstructures.YieldTermStructure;
import org.jquantlib.termstructures.volatilities.BlackConstantVol;
import org.jquantlib.termstructures.yieldcurves.FlatForward;
import org.jquantlib.time.Calendar;
import org.jquantlib.time.Date;
import org.jquantlib.time.Frequency;
import org.jquantlib.time.TimeGrid;

public class BinomialVanillaEngine<T extends Tree>
extends VanillaOption.EngineImpl {
    private final GeneralizedBlackScholesProcess process;
    private final int timeSteps_;
    private final OneAssetOption.ArgumentsImpl a;
    private final OneAssetOption.ResultsImpl r;
    private final Option.GreeksImpl greeks;
    private final Option.MoreGreeksImpl moreGreeks;
    private final Class<? extends Tree> classT;

    public BinomialVanillaEngine(Class<? extends Tree> classT, GeneralizedBlackScholesProcess process, int timeSteps) {
        this.classT = classT;
        QL.require(timeSteps > 0, "timeSteps must be positive");
        this.timeSteps_ = timeSteps;
        this.a = (OneAssetOption.ArgumentsImpl)this.arguments_;
        this.r = (OneAssetOption.ResultsImpl)this.results_;
        this.greeks = this.r.greeks();
        this.moreGreeks = this.r.moreGreeks();
        this.process = process;
        this.process.addObserver(this);
    }

    private Object getTreeInstance(StochasticProcess1D bs, double maturity, int timeSteps, double strike) {
        try {
            if (this.classT == ExtendedTian.class) {
                Constructor<? extends Tree> c = this.classT.getConstructor(StochasticProcess1D.class, Double.TYPE, Integer.TYPE);
                return this.classT.cast(c.newInstance(bs, maturity, timeSteps));
            }
            Constructor<? extends Tree> c = this.classT.getConstructor(StochasticProcess1D.class, Double.TYPE, Integer.TYPE, Double.TYPE);
            return this.classT.cast(c.newInstance(bs, maturity, timeSteps, strike));
        }
        catch (Exception e) {
            throw new LibraryException(e);
        }
    }

    @Override
    public void calculate() {
        DayCounter rfdc = this.process.riskFreeRate().currentLink().dayCounter();
        DayCounter divdc = this.process.dividendYield().currentLink().dayCounter();
        DayCounter voldc = this.process.blackVolatility().currentLink().dayCounter();
        Calendar volcal = this.process.blackVolatility().currentLink().calendar();
        double s0 = this.process.stateVariable().currentLink().value();
        QL.require(s0 > 0.0, "negative or null underlying given");
        double v = this.process.blackVolatility().currentLink().blackVol(this.a.exercise.lastDate(), s0);
        Date maturityDate = this.a.exercise.lastDate();
        double rRate = this.process.riskFreeRate().currentLink().zeroRate(maturityDate, rfdc, Compounding.Continuous, Frequency.NoFrequency).rate();
        double qRate = this.process.dividendYield().currentLink().zeroRate(maturityDate, divdc, Compounding.Continuous, Frequency.NoFrequency).rate();
        Date referenceDate = this.process.riskFreeRate().currentLink().referenceDate();
        Handle<YieldTermStructure> flatRiskFree = new Handle<YieldTermStructure>(new FlatForward(referenceDate, rRate, rfdc));
        Handle<YieldTermStructure> flatDividends = new Handle<YieldTermStructure>(new FlatForward(referenceDate, qRate, divdc));
        Handle<BlackVolTermStructure> flatVol = new Handle<BlackVolTermStructure>(new BlackConstantVol(referenceDate, volcal, v, voldc));
        PlainVanillaPayoff payoff = (PlainVanillaPayoff)this.a.payoff;
        QL.require(payoff != null, "non-plain payoff given");
        double maturity = rfdc.yearFraction(referenceDate, maturityDate);
        GeneralizedBlackScholesProcess bs = new GeneralizedBlackScholesProcess(this.process.stateVariable(), flatDividends, flatRiskFree, flatVol);
        TimeGrid grid = new TimeGrid(maturity, this.timeSteps_);
        Tree tree = (Tree)this.getTreeInstance(bs, maturity, this.timeSteps_, payoff.strike());
        BlackScholesLattice<Tree> lattice = new BlackScholesLattice<Tree>(tree, rRate, maturity, this.timeSteps_);
        DiscretizedVanillaOption option = new DiscretizedVanillaOption(this.a, this.process, grid);
        option.initialize(lattice, maturity);
        option.rollback(grid.at(2));
        Array va2 = option.values();
        QL.require(va2.size() == 3, "expect 3 nodes in grid at second step");
        double p2h = va2.get(2);
        double s2 = lattice.underlying(2, 2);
        option.rollback(grid.at(1));
        Array va = option.values();
        QL.require(va.size() == 2, "expect 2 nodes in grid at first step");
        double p1 = va.get(1);
        option.rollback(0.0);
        double p0 = option.presentValue();
        double s1 = lattice.underlying(1, 1);
        double delta0 = (p1 - p0) / (s1 - s0);
        double delta1 = (p2h - p1) / (s2 - s1);
        this.r.value = p0;
        this.greeks.delta = delta0;
        this.greeks.gamma = 2.0 * (delta1 - delta0) / (s2 - s0);
        this.greeks.theta = this.greeks.blackScholesTheta(this.process, this.r.value, this.greeks.delta, this.greeks.gamma);
    }
}

