/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.pricingengines.bond;

import org.jquantlib.QL;
import org.jquantlib.cashflow.CashFlows;
import org.jquantlib.cashflow.Leg;
import org.jquantlib.instruments.Bond;
import org.jquantlib.quotes.Handle;
import org.jquantlib.termstructures.AbstractYieldTermStructure;
import org.jquantlib.termstructures.YieldTermStructure;
import org.jquantlib.time.Date;

public class DiscountingBondEngine
extends Bond.EngineImpl {
    private final Handle<YieldTermStructure> discountCurve;

    public DiscountingBondEngine() {
        this(new Handle<YieldTermStructure>(new AbstractYieldTermStructure(){

            @Override
            protected double discountImpl(double t) {
                throw new UnsupportedOperationException();
            }

            @Override
            public Date maxDate() {
                throw new UnsupportedOperationException();
            }
        }));
    }

    public DiscountingBondEngine(Handle<YieldTermStructure> discountCurve) {
        this.discountCurve = discountCurve;
        this.discountCurve.addObserver(this);
    }

    @Override
    public void calculate() {
        Bond.ArgumentsImpl a = (Bond.ArgumentsImpl)this.arguments_;
        Bond.ResultsImpl r = (Bond.ResultsImpl)this.results_;
        Leg cashflows = a.cashflows;
        Date settlementDate = a.settlementDate;
        Date valuationDate = this.discountCurve.currentLink().referenceDate();
        QL.require(!this.discountCurve.empty(), "no discounting term structure set");
        r.value = CashFlows.getInstance().npv(cashflows, this.discountCurve, valuationDate, valuationDate);
        r.settlementValue = CashFlows.getInstance().npv(cashflows, this.discountCurve, settlementDate, settlementDate);
    }

    public Handle<YieldTermStructure> discountCurve() {
        return this.discountCurve;
    }
}

