/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.pricingengines.barrier;

import org.jquantlib.QL;
import org.jquantlib.instruments.BarrierOption;
import org.jquantlib.instruments.BarrierType;
import org.jquantlib.instruments.PlainVanillaPayoff;
import org.jquantlib.lang.exceptions.LibraryException;
import org.jquantlib.math.distributions.CumulativeNormalDistribution;
import org.jquantlib.processes.GeneralizedBlackScholesProcess;
import org.jquantlib.termstructures.Compounding;
import org.jquantlib.termstructures.InterestRate;
import org.jquantlib.time.Frequency;

public class AnalyticBarrierEngine
extends BarrierOption.EngineImpl {
    private static final String BS_PROCESS_REQUIRED = "Black-Scholes process required";
    private static final String NON_PLAIN_PAYOFF_GIVEN = "non-plain payoff given";
    private static final String STRIKE_MUST_BE_POSITIVE = "strike must be positive";
    private static final String UNKNOWN_TYPE = "unknown type";
    private final CumulativeNormalDistribution f = new CumulativeNormalDistribution();
    private final transient GeneralizedBlackScholesProcess process;
    private transient PlainVanillaPayoff payoff;
    private final BarrierOption.ArgumentsImpl a = (BarrierOption.ArgumentsImpl)this.arguments_;
    private final BarrierOption.ResultsImpl r = (BarrierOption.ResultsImpl)this.results_;

    public AnalyticBarrierEngine(GeneralizedBlackScholesProcess process) {
        this.process = process;
        this.process.addObserver(this);
    }

    @Override
    public void calculate() {
        QL.require(this.a.payoff instanceof PlainVanillaPayoff, NON_PLAIN_PAYOFF_GIVEN);
        this.payoff = (PlainVanillaPayoff)this.a.payoff;
        QL.require(this.payoff.strike() > 0.0, STRIKE_MUST_BE_POSITIVE);
        double strike = this.payoff.strike();
        BarrierType barrierType = this.a.barrierType;
        switch (this.payoff.optionType()) {
            case Call: {
                switch (barrierType) {
                    case DownIn: {
                        if (strike >= this.barrier()) {
                            this.r.value = this.C(1.0, 1.0) + this.E(1.0);
                            break;
                        }
                        this.r.value = this.A(1.0) - this.B(1.0) + this.D(1.0, 1.0) + this.E(1.0);
                        break;
                    }
                    case UpIn: {
                        if (strike >= this.barrier()) {
                            this.r.value = this.A(1.0) + this.E(-1.0);
                            break;
                        }
                        this.r.value = this.B(1.0) - this.C(-1.0, 1.0) + this.D(-1.0, 1.0) + this.E(-1.0);
                        break;
                    }
                    case DownOut: {
                        if (strike >= this.barrier()) {
                            this.r.value = this.A(1.0) - this.C(1.0, 1.0) + this.F(1.0);
                            break;
                        }
                        this.r.value = this.B(1.0) - this.D(1.0, 1.0) + this.F(1.0);
                        break;
                    }
                    case UpOut: {
                        this.r.value = strike >= this.barrier() ? this.F(-1.0) : this.A(1.0) - this.B(1.0) + this.C(-1.0, 1.0) - this.D(-1.0, 1.0) + this.F(-1.0);
                    }
                }
                break;
            }
            case Put: {
                switch (barrierType) {
                    case DownIn: {
                        if (strike >= this.barrier()) {
                            this.r.value = this.B(-1.0) - this.C(1.0, -1.0) + this.D(1.0, -1.0) + this.E(1.0);
                            break;
                        }
                        this.r.value = this.A(-1.0) + this.E(1.0);
                        break;
                    }
                    case UpIn: {
                        if (strike >= this.barrier()) {
                            this.r.value = this.A(-1.0) - this.B(-1.0) + this.D(-1.0, -1.0) + this.E(-1.0);
                            break;
                        }
                        this.r.value = this.C(-1.0, -1.0) + this.E(-1.0);
                        break;
                    }
                    case DownOut: {
                        if (strike >= this.barrier()) {
                            this.r.value = this.A(-1.0) - this.B(-1.0) + this.C(1.0, -1.0) - this.D(1.0, -1.0) + this.F(1.0);
                            break;
                        }
                        this.r.value = this.F(1.0);
                        break;
                    }
                    case UpOut: {
                        this.r.value = strike >= this.barrier() ? this.B(-1.0) - this.D(-1.0, -1.0) + this.F(-1.0) : this.A(-1.0) - this.C(-1.0, -1.0) + this.F(-1.0);
                    }
                }
                break;
            }
            default: {
                throw new LibraryException(UNKNOWN_TYPE);
            }
        }
    }

    private double underlying() {
        return this.process.initialValues().first();
    }

    private double strike() {
        return this.payoff.strike();
    }

    private double residualTime() {
        return this.process.time(this.a.exercise.lastDate());
    }

    private double volatility() {
        return this.process.blackVolatility().currentLink().blackVol(this.residualTime(), this.strike());
    }

    private double stdDeviation() {
        return this.volatility() * Math.sqrt(this.residualTime());
    }

    private double barrier() {
        return this.a.barrier;
    }

    private double rebate() {
        return this.a.rebate;
    }

    private double riskFreeRate() {
        InterestRate rate = this.process.riskFreeRate().currentLink().zeroRate(this.residualTime(), Compounding.Continuous, Frequency.NoFrequency, false);
        return rate.rate();
    }

    private double riskFreeDiscount() {
        return this.process.riskFreeRate().currentLink().discount(this.residualTime());
    }

    private double dividendYield() {
        InterestRate yield = this.process.dividendYield().currentLink().zeroRate(this.residualTime(), Compounding.Continuous, Frequency.NoFrequency, false);
        return yield.rate();
    }

    private double dividendDiscount() {
        return this.process.dividendYield().currentLink().discount(this.residualTime());
    }

    private double mu() {
        double vol = this.volatility();
        return (this.riskFreeRate() - this.dividendYield()) / (vol * vol) - 0.5;
    }

    private double muSigma() {
        return (1.0 + this.mu()) * this.stdDeviation();
    }

    private double A(double phi) {
        double x1 = Math.log(this.underlying() / this.strike()) / this.stdDeviation() + this.muSigma();
        double N1 = this.f.op(phi * x1);
        double N2 = this.f.op(phi * (x1 - this.stdDeviation()));
        return phi * (this.underlying() * this.dividendDiscount() * N1 - this.strike() * this.riskFreeDiscount() * N2);
    }

    private double B(double phi) {
        double x2 = Math.log(this.underlying() / this.barrier()) / this.stdDeviation() + this.muSigma();
        double N1 = this.f.op(phi * x2);
        double N2 = this.f.op(phi * (x2 - this.stdDeviation()));
        return phi * (this.underlying() * this.dividendDiscount() * N1 - this.strike() * this.riskFreeDiscount() * N2);
    }

    private double C(double eta, double phi) {
        double HS = this.barrier() / this.underlying();
        double powHS0 = Math.pow(HS, 2.0 * this.mu());
        double powHS1 = powHS0 * HS * HS;
        double y1 = Math.log(this.barrier() * HS / this.strike()) / this.stdDeviation() + this.muSigma();
        double N1 = this.f.op(eta * y1);
        double N2 = this.f.op(eta * (y1 - this.stdDeviation()));
        return phi * (this.underlying() * this.dividendDiscount() * powHS1 * N1 - this.strike() * this.riskFreeDiscount() * powHS0 * N2);
    }

    private double D(double eta, double phi) {
        double HS = this.barrier() / this.underlying();
        double powHS0 = Math.pow(HS, 2.0 * this.mu());
        double powHS1 = powHS0 * HS * HS;
        double y2 = Math.log(this.barrier() / this.underlying()) / this.stdDeviation() + this.muSigma();
        double N1 = this.f.op(eta * y2);
        double N2 = this.f.op(eta * (y2 - this.stdDeviation()));
        return phi * (this.underlying() * this.dividendDiscount() * powHS1 * N1 - this.strike() * this.riskFreeDiscount() * powHS0 * N2);
    }

    private double E(double eta) {
        if (this.rebate() > 0.0) {
            double powHS0 = Math.pow(this.barrier() / this.underlying(), 2.0 * this.mu());
            double x2 = Math.log(this.underlying() / this.barrier()) / this.stdDeviation() + this.muSigma();
            double y2 = Math.log(this.barrier() / this.underlying()) / this.stdDeviation() + this.muSigma();
            double N1 = this.f.op(eta * (x2 - this.stdDeviation()));
            double N2 = this.f.op(eta * (y2 - this.stdDeviation()));
            return this.rebate() * this.riskFreeDiscount() * (N1 - powHS0 * N2);
        }
        return 0.0;
    }

    private double F(double eta) {
        if (this.rebate() > 0.0) {
            double m = this.mu();
            double vol = this.volatility();
            double lambda = Math.sqrt(m * m + 2.0 * this.riskFreeRate() / (vol * vol));
            double HS = this.barrier() / this.underlying();
            double powHSplus = Math.pow(HS, m + lambda);
            double powHSminus = Math.pow(HS, m - lambda);
            double sigmaSqrtT = this.stdDeviation();
            double z = Math.log(this.barrier() / this.underlying()) / sigmaSqrtT + lambda * sigmaSqrtT;
            double N1 = this.f.op(eta * z);
            double N2 = this.f.op(eta * (z - 2.0 * lambda * sigmaSqrtT));
            return this.rebate() * (powHSplus * N1 + powHSminus * N2);
        }
        return 0.0;
    }
}

