/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.pricingengines;

import java.lang.reflect.Constructor;
import org.jquantlib.QL;
import org.jquantlib.cashflow.Dividend;
import org.jquantlib.daycounters.DayCounter;
import org.jquantlib.instruments.PlainVanillaPayoff;
import org.jquantlib.instruments.bonds.ConvertibleBondOption;
import org.jquantlib.lang.exceptions.LibraryException;
import org.jquantlib.methods.lattices.BinomialTree;
import org.jquantlib.methods.lattices.TsiveriotisFernandesLattice;
import org.jquantlib.pricingengines.hybrid.DiscretizedConvertible;
import org.jquantlib.processes.GeneralizedBlackScholesProcess;
import org.jquantlib.processes.StochasticProcess1D;
import org.jquantlib.quotes.Handle;
import org.jquantlib.quotes.SimpleQuote;
import org.jquantlib.termstructures.BlackVolTermStructure;
import org.jquantlib.termstructures.Compounding;
import org.jquantlib.termstructures.YieldTermStructure;
import org.jquantlib.termstructures.volatilities.BlackConstantVol;
import org.jquantlib.termstructures.yieldcurves.FlatForward;
import org.jquantlib.time.Calendar;
import org.jquantlib.time.Date;
import org.jquantlib.time.Frequency;
import org.jquantlib.time.TimeGrid;

public class BinomialConvertibleEngine<T extends BinomialTree>
extends ConvertibleBondOption.EngineImpl {
    private final int timeSteps_;
    private final GeneralizedBlackScholesProcess process_;
    private final ConvertibleBondOption.ArgumentsImpl a;
    private final ConvertibleBondOption.ResultsImpl r;
    private final Class<T> typeT;

    public BinomialConvertibleEngine(Class<T> typeT, GeneralizedBlackScholesProcess process, int timeSteps) {
        this.typeT = typeT;
        this.a = (ConvertibleBondOption.ArgumentsImpl)this.arguments_;
        this.r = (ConvertibleBondOption.ResultsImpl)this.results_;
        this.process_ = process;
        this.timeSteps_ = timeSteps;
        QL.require(timeSteps > 0, "timeSteps must be positive, " + timeSteps + " not allowed");
        this.process_.addObserver(this);
    }

    @Override
    public void calculate() {
        BinomialTree tree;
        DayCounter rfdc = this.process_.riskFreeRate().currentLink().dayCounter();
        DayCounter divdc = this.process_.dividendYield().currentLink().dayCounter();
        DayCounter voldc = this.process_.blackVolatility().currentLink().dayCounter();
        Calendar volcal = this.process_.blackVolatility().currentLink().calendar();
        Double s0 = this.process_.x0();
        QL.require(s0 > 0.0, "negative or null underlying");
        double v = this.process_.blackVolatility().currentLink().blackVol(this.a.exercise.lastDate(), (double)s0);
        Date maturityDate = this.a.exercise.lastDate();
        double riskFreeRate = this.process_.riskFreeRate().currentLink().zeroRate(maturityDate, rfdc, Compounding.Continuous, Frequency.NoFrequency).rate();
        double q = this.process_.dividendYield().currentLink().zeroRate(maturityDate, divdc, Compounding.Continuous, Frequency.NoFrequency).rate();
        Date referenceDate = this.process_.riskFreeRate().currentLink().referenceDate();
        for (int i = 0; i < this.a.dividends.size(); ++i) {
            if (!((Dividend)this.a.dividends.get(i)).date().gt(referenceDate)) continue;
            s0 = s0 - ((Dividend)this.a.dividends.get(i)).amount() * this.process_.riskFreeRate().currentLink().discount(((Dividend)this.a.dividends.get(i)).date());
        }
        QL.require(s0 > 0.0, "negative value after subtracting dividends");
        Handle<SimpleQuote> underlying = new Handle<SimpleQuote>(new SimpleQuote(s0));
        Handle<YieldTermStructure> flatRiskFree = new Handle<YieldTermStructure>(new FlatForward(referenceDate, riskFreeRate, rfdc));
        Handle<YieldTermStructure> flatDividends = new Handle<YieldTermStructure>(new FlatForward(referenceDate, q, divdc));
        Handle<BlackVolTermStructure> flatVol = new Handle<BlackVolTermStructure>(new BlackConstantVol(referenceDate, volcal, v, voldc));
        PlainVanillaPayoff payoff = (PlainVanillaPayoff)this.a.payoff;
        QL.require(payoff != null, "non-plain payoff given");
        double maturity = rfdc.yearFraction(this.a.settlementDate, maturityDate);
        GeneralizedBlackScholesProcess bs = new GeneralizedBlackScholesProcess(underlying, flatDividends, flatRiskFree, flatVol);
        try {
            Constructor<T> c = this.typeT.getConstructor(StochasticProcess1D.class, Double.TYPE, Integer.TYPE, Double.TYPE);
            tree = (BinomialTree)this.typeT.cast(c.newInstance(bs, maturity, this.timeSteps_, payoff.strike()));
        }
        catch (Exception e) {
            throw new LibraryException(e);
        }
        double creditSpread = this.a.creditSpread.currentLink().value();
        TsiveriotisFernandesLattice<BinomialTree> lattice = new TsiveriotisFernandesLattice<BinomialTree>(tree, riskFreeRate, maturity, this.timeSteps_, creditSpread, v, q);
        DiscretizedConvertible convertible = new DiscretizedConvertible(this.a, bs, new TimeGrid(maturity, this.timeSteps_));
        convertible.initialize(lattice, maturity);
        convertible.rollback(0.0);
        this.r.value = convertible.presentValue();
    }
}

