/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.model.volatility;

import java.util.Iterator;
import org.jquantlib.QL;
import org.jquantlib.lang.iterators.Iterables;
import org.jquantlib.model.volatility.VolatilityCompositor;
import org.jquantlib.time.Date;
import org.jquantlib.time.TimeSeries;

public class Garch11
implements VolatilityCompositor {
    private double alpha;
    private double beta;
    private double gamma;
    private double v;

    public Garch11(double alpha, double beta, double v) {
        this.alpha = alpha;
        this.beta = beta;
        this.v = v;
        this.gamma = 1.0 - alpha - beta;
    }

    public Garch11(TimeSeries<Double> qs) {
        this.calibrate(qs);
    }

    @Override
    public TimeSeries<Double> calculate(TimeSeries<Double> vs) {
        return this.calculate(vs, this.alpha, this.beta, this.gamma * this.v);
    }

    @Override
    public void calibrate(TimeSeries<Double> timeSeries) {
    }

    protected double costFunction(TimeSeries<Double> vs, double alpha, double beta, double omega) {
        TimeSeries<Double> test = this.calculate(vs, alpha, beta, omega);
        QL.require(test.size() == vs.size(), "quote and test values do not match");
        double retval = 0.0;
        for (Date date : Iterables.unmodifiableIterable(test.navigableKeySet())) {
            double v = (Double)test.get(date);
            double u = (Double)vs.get(date);
            v *= v;
            u *= u;
            retval += 2.0 * Math.log(v) + u / (v * v);
        }
        return retval;
    }

    private TimeSeries<Double> calculate(TimeSeries<Double> vs, double alpha, double beta, double omega) {
        TimeSeries<Double> retValue = new TimeSeries<Double>(Double.class);
        Iterator dates = vs.navigableKeySet().iterator();
        Date date = (Date)dates.next();
        double zerothDayValue = (Double)vs.get(date);
        retValue.put(date, zerothDayValue);
        double u = 0.0;
        double sigma2 = zerothDayValue * zerothDayValue;
        while (dates.hasNext()) {
            date = (Date)dates.next();
            u = (Double)vs.get(date);
            sigma2 = omega * u * u + beta * sigma2;
            retValue.put(date, Math.sqrt(sigma2));
        }
        return retValue;
    }
}

