/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.model.shortrate.twofactormodels;

import java.util.ArrayList;
import org.jquantlib.math.matrixutilities.Matrix;
import org.jquantlib.methods.lattices.Lattice;
import org.jquantlib.methods.lattices.TreeLattice2D;
import org.jquantlib.methods.lattices.TrinomialTree;
import org.jquantlib.model.shortrate.ShortRateModel;
import org.jquantlib.model.shortrate.StochasticProcessArray;
import org.jquantlib.processes.StochasticProcess;
import org.jquantlib.processes.StochasticProcess1D;
import org.jquantlib.time.TimeGrid;

public abstract class TwoFactorModel
extends ShortRateModel {
    public TwoFactorModel(int nParams) {
        super(nParams);
    }

    public abstract ShortRateDynamics dynamics();

    @Override
    public Lattice tree(TimeGrid grid) {
        ShortRateDynamics dyn = this.dynamics();
        TrinomialTree tree1 = new TrinomialTree(dyn.xProcess(), grid, true);
        TrinomialTree tree2 = new TrinomialTree(dyn.yProcess(), grid, true);
        return new ShortRateTree(tree1, tree2, dyn);
    }

    public class ShortRateTree
    extends TreeLattice2D<TrinomialTree> {
        private final ShortRateDynamics dynamics_;

        public ShortRateTree(TrinomialTree tree1, TrinomialTree tree2, ShortRateDynamics dynamics) {
            super(tree1, tree2, dynamics.correlation());
            this.dynamics_ = dynamics;
        }

        @Override
        public double discount(int i, int index) {
            int modulo = this.tree1.size(i);
            int index1 = index % modulo;
            int index2 = index / modulo;
            double x = this.tree1.underlying(i, index1);
            double y = this.tree2.underlying(i, index2);
            double r = this.dynamics_.shortRate(this.timeGrid().at(i), x, y);
            return Math.exp(-r * this.timeGrid().dt(i));
        }
    }

    public abstract class ShortRateDynamics {
        private final StochasticProcess1D xProcess_;
        private final StochasticProcess1D yProcess_;
        double correlation_;

        public ShortRateDynamics(StochasticProcess1D xProcess, StochasticProcess1D yProcess, double correlation) {
            this.xProcess_ = xProcess;
            this.yProcess_ = yProcess;
            this.correlation_ = correlation;
        }

        public abstract double shortRate(double var1, double var3, double var5);

        public StochasticProcess1D xProcess() {
            return this.xProcess_;
        }

        public StochasticProcess1D yProcess() {
            return this.yProcess_;
        }

        public double correlation() {
            return this.correlation_;
        }

        public StochasticProcess process() {
            Matrix correlation = new Matrix(2, 2);
            correlation.set(0, 0, 1.0);
            correlation.set(1, 1, 1.0);
            correlation.set(0, 1, this.correlation_);
            correlation.set(1, 0, this.correlation_);
            ArrayList<StochasticProcess1D> processes = new ArrayList<StochasticProcess1D>();
            processes.add(0, this.xProcess_);
            processes.add(1, this.xProcess_);
            return new StochasticProcessArray(processes, correlation);
        }
    }
}

