/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.model.shortrate.onefactormodels;

import org.jquantlib.lang.annotation.QualityAssurance;
import org.jquantlib.math.Ops;
import org.jquantlib.math.matrixutilities.Array;
import org.jquantlib.math.solvers1D.Brent;
import org.jquantlib.methods.lattices.Lattice;
import org.jquantlib.methods.lattices.TreeLattice1D;
import org.jquantlib.methods.lattices.TrinomialTree;
import org.jquantlib.model.TermStructureFittingParameter;
import org.jquantlib.model.shortrate.ShortRateModel;
import org.jquantlib.processes.StochasticProcess1D;
import org.jquantlib.time.TimeGrid;

@QualityAssurance(quality=QualityAssurance.Quality.Q0_UNFINISHED, version=QualityAssurance.Version.V097, reviewers={"Richard Gomes"})
public abstract class OneFactorModel
extends ShortRateModel {
    public OneFactorModel(int nArguments) {
        super(nArguments);
    }

    @Override
    public Lattice tree(TimeGrid grid) {
        TrinomialTree trinomial = new TrinomialTree(this.dynamics().process(), grid);
        return new ShortRateTree(trinomial, this.dynamics(), grid);
    }

    public abstract ShortRateDynamics dynamics();

    protected class ShortRateTree
    extends TreeLattice1D {
        private final TrinomialTree tree_;
        private final ShortRateDynamics dynamics_;

        public ShortRateTree(TrinomialTree tree, ShortRateDynamics dynamics, TimeGrid timeGrid) {
            super(timeGrid, tree.size(1));
            this.tree_ = tree;
            this.dynamics_ = dynamics;
        }

        public ShortRateTree(TrinomialTree tree, ShortRateDynamics dynamics, TermStructureFittingParameter.NumericalImpl theta, TimeGrid timeGrid) {
            super(timeGrid, tree.size(1));
            this.tree_ = tree;
            this.dynamics_ = dynamics;
            theta.reset();
            double value = 1.0;
            double vMin = -100.0;
            double vMax = 100.0;
            for (int i = 0; i < timeGrid.size() - 1; ++i) {
                double discountBond = theta.termStructure().currentLink().discount(this.t.get(i + 1));
                Helper finder = new Helper(i, discountBond, theta, this);
                Brent s1d = new Brent();
                s1d.setMaxEvaluations(1000);
                value = s1d.solve(finder, 1.0E-7, value, -100.0, 100.0);
                theta.change(value);
            }
        }

        @Override
        public int size(int i) {
            return this.tree_.size(i);
        }

        @Override
        public double discount(int i, int index) {
            double x = this.tree_.underlying(i, index);
            double r = this.dynamics_.shortRate(this.timeGrid().get(i), x);
            return Math.exp(-r * this.timeGrid().dt(i));
        }

        @Override
        public double underlying(int i, int index) {
            return this.tree_.underlying(i, index);
        }

        @Override
        public int descendant(int i, int index, int branch) {
            return this.tree_.descendant(i, index, branch);
        }

        @Override
        public double probability(int i, int index, int branch) {
            return this.tree_.probability(i, index, branch);
        }

        private class Helper
        implements Ops.DoubleOp {
            private final int size_;
            private final int i_;
            private final Array statePrices_;
            private final double discountBondPrice_;
            protected final TermStructureFittingParameter.NumericalImpl theta_;
            private final ShortRateTree tree_;

            private Helper(int i, double discountBondPrice, TermStructureFittingParameter.NumericalImpl theta, ShortRateTree tree) {
                this.i_ = i;
                this.size_ = tree.size(i);
                this.statePrices_ = tree.statePrices(i);
                this.discountBondPrice_ = discountBondPrice;
                this.theta_ = theta;
                this.tree_ = tree;
                this.theta_.set(tree.timeGrid().get(i), 0.0);
            }

            @Override
            public double op(double theta) {
                double value = this.discountBondPrice_;
                this.theta_.change(theta);
                for (int j = 0; j < this.size_; ++j) {
                    value -= this.statePrices_.get(j) * this.tree_.discount(this.i_, j);
                }
                return value;
            }
        }
    }

    protected abstract class ShortRateDynamics {
        private final StochasticProcess1D process_;

        protected ShortRateDynamics(StochasticProcess1D process) {
            this.process_ = process;
        }

        public final StochasticProcess1D process() {
            return this.process_;
        }

        public abstract double variable(double var1, double var3);

        public abstract double shortRate(double var1, double var3);
    }
}

