/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.model.shortrate.calibrationhelpers;

import java.util.ArrayList;
import java.util.List;
import org.jquantlib.daycounters.DayCounter;
import org.jquantlib.indexes.IborIndex;
import org.jquantlib.lang.annotation.Time;
import org.jquantlib.model.CalibrationHelper;
import org.jquantlib.quotes.Handle;
import org.jquantlib.quotes.Quote;
import org.jquantlib.termstructures.YieldTermStructure;
import org.jquantlib.time.BusinessDayConvention;
import org.jquantlib.time.Date;
import org.jquantlib.time.DateGeneration;
import org.jquantlib.time.Frequency;
import org.jquantlib.time.Period;
import org.jquantlib.time.Schedule;
import org.jquantlib.util.DefaultObservable;
import org.jquantlib.util.Observable;
import org.jquantlib.util.Observer;

public class CapHelper
extends CalibrationHelper {
    private final Observable delegatedObservable = new DefaultObservable(this);

    public CapHelper(Period length, Handle<Quote> volatility, IborIndex index, Frequency fixedLegFrequency, DayCounter fixedLegDayCounter, boolean includeFirstSwaplet, Handle<YieldTermStructure> termStructure) {
        this(length, volatility, index, fixedLegFrequency, fixedLegDayCounter, includeFirstSwaplet, termStructure, false);
    }

    public CapHelper(Period length, Handle<Quote> volatility, IborIndex index, Frequency fixedLegFrequency, DayCounter fixedLegDayCounter, boolean includeFirstSwaplet, Handle<YieldTermStructure> termStructure, boolean calibrateVolatility) {
        super(volatility, termStructure, calibrateVolatility);
        Date maturity;
        Date startDate;
        Period indexTenor = index.tenor();
        double fixedRate = 0.04;
        if (includeFirstSwaplet) {
            startDate = termStructure.currentLink().referenceDate();
            maturity = termStructure.currentLink().referenceDate().add(length);
        } else {
            startDate = termStructure.currentLink().referenceDate().add(indexTenor);
            maturity = termStructure.currentLink().referenceDate().add(length);
        }
        IborIndex dummyIndex = new IborIndex("dummy", indexTenor, index.fixingDays(), index.currency(), index.fixingCalendar(), index.businessDayConvention(), index.endOfMonth(), termStructure.currentLink().dayCounter(), termStructure);
        double[] nominals = new double[]{1.0, 1.0};
        Schedule fixedSchedule = new Schedule(startDate, maturity, new Period(fixedLegFrequency), index.fixingCalendar(), BusinessDayConvention.Unadjusted, BusinessDayConvention.Unadjusted, DateGeneration.Rule.Forward, false);
        throw new UnsupportedOperationException("Work in progress");
    }

    @Override
    public void addTimesTo(ArrayList<Time> times) {
    }

    @Override
    public double blackPrice(double volatility) {
        return 0.0;
    }

    @Override
    public double modelValue() {
        return 0.0;
    }

    @Override
    public void update() {
        throw new UnsupportedOperationException("work in progress");
    }

    @Override
    public void addObserver(Observer observer) {
        this.delegatedObservable.addObserver(observer);
    }

    @Override
    public int countObservers() {
        return this.delegatedObservable.countObservers();
    }

    @Override
    public void deleteObserver(Observer observer) {
        this.delegatedObservable.deleteObservers();
    }

    @Override
    public void deleteObservers() {
        this.delegatedObservable.deleteObservers();
    }

    @Override
    public List<Observer> getObservers() {
        return this.delegatedObservable.getObservers();
    }

    @Override
    public void notifyObservers() {
        this.delegatedObservable.notifyObservers();
    }

    @Override
    public void notifyObservers(Object arg) {
        this.delegatedObservable.notifyObservers(arg);
    }
}

