/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.model.shortrate;

import java.util.List;
import org.jquantlib.QL;
import org.jquantlib.math.matrixutilities.Array;
import org.jquantlib.math.matrixutilities.Matrix;
import org.jquantlib.math.matrixutilities.PseudoSqrt;
import org.jquantlib.processes.StochasticProcess;
import org.jquantlib.processes.StochasticProcess1D;
import org.jquantlib.time.Date;

public class StochasticProcessArray
extends StochasticProcess {
    private static final String no_process_given = "no process given";
    private static final String mismatch_processnumber_sizecorrelationmatrix = "mismatch between number of processes and size of correlation matrix";
    protected List<StochasticProcess1D> processes_;
    protected Matrix sqrtCorrelation_;

    public StochasticProcessArray(List<StochasticProcess1D> processes, Matrix correlation) {
        if (System.getProperty("EXPERIMENTAL") == null) {
            throw new UnsupportedOperationException("Work in progress");
        }
        QL.require(!processes.isEmpty(), no_process_given);
        QL.require(correlation.rows() == processes.size(), mismatch_processnumber_sizecorrelationmatrix);
        this.processes_ = processes;
        this.sqrtCorrelation_ = PseudoSqrt.pseudoSqrt(correlation, PseudoSqrt.SalvagingAlgorithm.Spectral);
        for (int i = 0; i < this.processes_.size(); ++i) {
            this.processes_.get(i).addObserver(this);
        }
    }

    @Override
    public Array initialValues() {
        double[] tmp = new double[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            tmp[i] = this.processes_.get(i).x0();
        }
        return new Array(tmp);
    }

    @Override
    public int size() {
        return this.processes_.size();
    }

    @Override
    public Array drift(double t, Array x) {
        double[] tmp = new double[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            tmp[i] = this.processes_.get(i).drift(t, x.get(i));
        }
        return new Array(tmp);
    }

    @Override
    public Matrix diffusion(double t, Array x) {
        for (int i = 0; i < this.size(); ++i) {
            double sigma = this.processes_.get(i).diffusion(t, x.get(i));
            this.sqrtCorrelation_.rangeRow(i).mulAssign(sigma);
        }
        return this.sqrtCorrelation_;
    }

    @Override
    public Array expectation(double t0, Array x0, double dt) {
        double[] tmp = new double[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            tmp[i] = this.processes_.get(i).expectation(t0, x0.get(i), dt);
        }
        return new Array(tmp);
    }

    @Override
    public Matrix stdDeviation(double t0, Array x0, double dt) {
        for (int i = 0; i < this.size(); ++i) {
            double sigma = this.processes_.get(i).stdDeviation(t0, x0.get(i), dt);
            this.sqrtCorrelation_.rangeRow(i).mulAssign(sigma);
        }
        return this.sqrtCorrelation_;
    }

    @Override
    public Matrix covariance(double t0, Array x0, double dt) {
        Matrix tmp = this.stdDeviation(t0, x0, dt);
        return tmp.mul(tmp.transpose());
    }

    @Override
    public Array evolve(double t0, Array x0, double dt, Array dw) {
        Array dz = this.sqrtCorrelation_.mul(dw);
        double[] tmp = new double[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            tmp[i] = this.processes_.get(i).evolve(t0, x0.get(i), dt, dz.get(i));
        }
        return new Array(tmp);
    }

    @Override
    public Array apply(Array x0, Array dx) {
        double[] tmp = new double[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            tmp[i] = this.processes_.get(i).apply(x0.get(i), dx.get(i));
        }
        return new Array(tmp);
    }

    @Override
    public double time(Date d) {
        return this.processes_.get(0).time(d);
    }

    public StochasticProcess1D process(int i) {
        return this.processes_.get(i);
    }

    public Matrix correlation() {
        return this.sqrtCorrelation_.mul(this.sqrtCorrelation_.transpose());
    }
}

