/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.model;

import java.util.ArrayList;
import java.util.List;
import org.jquantlib.QL;
import org.jquantlib.lang.annotation.QualityAssurance;
import org.jquantlib.math.matrixutilities.Array;
import org.jquantlib.math.optimization.NoConstraint;
import org.jquantlib.model.Parameter;
import org.jquantlib.quotes.Handle;
import org.jquantlib.termstructures.YieldTermStructure;

@QualityAssurance(quality=QualityAssurance.Quality.Q3_DOCUMENTATION, version=QualityAssurance.Version.V097, reviewers={"Richard Gomes"})
public class TermStructureFittingParameter
extends Parameter {
    public TermStructureFittingParameter(Parameter.Impl impl) {
        super(0, impl, new NoConstraint());
    }

    public TermStructureFittingParameter(Handle<YieldTermStructure> term) {
        super(0, new NumericalImpl(term), new NoConstraint());
    }

    public static class NumericalImpl
    implements Parameter.Impl {
        private final List<Double> times = new ArrayList<Double>();
        private final List<Double> values = new ArrayList<Double>();
        private final Handle<YieldTermStructure> termStructure;

        public NumericalImpl(Handle<YieldTermStructure> termStructure) {
            this.termStructure = termStructure;
        }

        public void set(double t, double x) {
            this.times.add(t);
            this.values.add(x);
        }

        public void change(double x) {
            int last = this.values.size() - 1;
            this.values.set(last, x);
        }

        public void reset() {
            this.times.clear();
            this.values.clear();
        }

        @Override
        public double value(Array ref, double t) {
            int index = this.times.indexOf(t);
            QL.require(index > -1, "fitting parameter not set!");
            return this.values.get(index);
        }

        public final Handle<YieldTermStructure> termStructure() {
            return this.termStructure;
        }
    }
}

