/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.model;

import java.util.ArrayList;
import java.util.List;
import org.jquantlib.lang.annotation.Time;
import org.jquantlib.math.Ops;
import org.jquantlib.math.solvers1D.Brent;
import org.jquantlib.pricingengines.PricingEngine;
import org.jquantlib.quotes.Handle;
import org.jquantlib.quotes.Quote;
import org.jquantlib.termstructures.YieldTermStructure;
import org.jquantlib.util.Observable;
import org.jquantlib.util.Observer;

public abstract class CalibrationHelper
implements Observer,
Observable {
    protected double marketValue;
    protected Handle<Quote> volatility_;
    protected Handle<YieldTermStructure> termStructure_;
    protected PricingEngine engine_;
    private boolean calibrateVolatility_ = false;

    public CalibrationHelper(Handle<Quote> volatility, Handle<YieldTermStructure> termStructure, boolean calibrateVolatility) {
        if (System.getProperty("EXPERIMENTAL") == null) {
            throw new UnsupportedOperationException("Work in progress");
        }
        this.volatility_ = volatility;
        this.termStructure_ = termStructure;
        this.calibrateVolatility_ = calibrateVolatility;
        this.volatility_.addObserver(this);
        this.termStructure_.addObserver(this);
    }

    double marketValue() {
        return this.marketValue;
    }

    public abstract double modelValue();

    public double calibrationError() {
        if (this.calibrateVolatility_) {
            double lowerPrice = this.blackPrice(0.001);
            double upperPrice = this.blackPrice(10.0);
            double modelPrice = this.modelValue();
            double implied = modelPrice <= lowerPrice ? 0.001 : (modelPrice >= upperPrice ? 10.0 : this.impliedVolatility(modelPrice, 1.0E-12, 5000, 0.001, 10.0));
            return implied - this.volatility_.currentLink().value();
        }
        return Math.abs(this.marketValue() - this.modelValue()) / this.marketValue();
    }

    public double impliedVolatility(double targetValue, double accuracy, int maxEvaluations, double minVol, double maxVol) {
        ImpliedVolatilityHelper f = new ImpliedVolatilityHelper(this, targetValue);
        Brent solver = new Brent();
        solver.setMaxEvaluations(maxEvaluations);
        return solver.solve(f, accuracy, this.volatility_.currentLink().value(), minVol, maxVol);
    }

    public void setPricingEngine(PricingEngine engine) {
        this.engine_ = engine;
    }

    public abstract void addTimesTo(ArrayList<Time> var1);

    public abstract double blackPrice(double var1);

    @Override
    public void update() {
        this.marketValue = this.blackPrice(this.volatility_.currentLink().value());
        this.notifyObservers();
    }

    @Override
    public void addObserver(Observer observer) {
    }

    @Override
    public int countObservers() {
        return 0;
    }

    @Override
    public void deleteObserver(Observer observer) {
    }

    @Override
    public void deleteObservers() {
    }

    @Override
    public List<Observer> getObservers() {
        return null;
    }

    @Override
    public void notifyObservers() {
    }

    @Override
    public void notifyObservers(Object arg) {
    }

    private class ImpliedVolatilityHelper
    implements Ops.DoubleOp {
        private final CalibrationHelper helper_;
        private final double value_;

        public ImpliedVolatilityHelper(CalibrationHelper helper, double value) {
            this.helper_ = helper;
            this.value_ = value;
        }

        @Override
        public double op(double x) {
            return this.value_ - this.helper_.blackPrice(x);
        }
    }
}

