/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.methods.finitedifferences;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jquantlib.lang.exceptions.LibraryException;
import org.jquantlib.math.matrixutilities.Array;
import org.jquantlib.methods.finitedifferences.BoundaryCondition;
import org.jquantlib.methods.finitedifferences.MixedScheme;
import org.jquantlib.methods.finitedifferences.Operator;
import org.jquantlib.methods.finitedifferences.StepCondition;

public class FiniteDifferenceModel<S extends Operator, T extends MixedScheme<S>> {
    private final T evolver;
    private final List<Double> stoppingTimes;
    private final Class<? extends Operator> classS;
    private final Class<? extends MixedScheme> classT;

    public FiniteDifferenceModel(Class<? extends Operator> classS, Class<? extends MixedScheme> classT, S L, List<BoundaryCondition<S>> bcs, List<Double> stoppingTimes) {
        this.classS = classS;
        this.classT = classT;
        this.evolver = this.getEvolver(L, bcs);
        HashSet<Double> times = new HashSet<Double>(stoppingTimes);
        this.stoppingTimes = new ArrayList<Double>(times);
        Collections.sort(stoppingTimes);
    }

    public FiniteDifferenceModel(Class<? extends Operator> classS, Class<? extends MixedScheme> classT, S L, List<BoundaryCondition<S>> bcs) {
        this(classS, classT, L, bcs, new ArrayList<Double>());
    }

    public FiniteDifferenceModel(Class<? extends Operator> classS, Class<? extends MixedScheme> classT, T evolver, List<Double> stoppingTimes) {
        this.classS = classS;
        this.classT = classT;
        this.evolver = evolver;
        HashSet<Double> times = new HashSet<Double>(stoppingTimes);
        this.stoppingTimes = new ArrayList<Double>(times);
        Collections.sort(stoppingTimes);
    }

    public T getEvolver() {
        return this.evolver;
    }

    public Array rollback(Array a, double from, double to, int steps) {
        return this.rollbackImpl(a, from, to, steps, null);
    }

    public Array rollback(Array a, double from, double to, int steps, StepCondition<Array> condition) {
        return this.rollbackImpl(a, from, to, steps, condition);
    }

    private Array rollbackImpl(Array a, double from, double to, int steps, StepCondition<Array> condition) {
        if (from <= to) {
            throw new IllegalStateException("trying to roll back from " + from + " to " + to);
        }
        double dt = (from - to) / (double)steps;
        double t = from;
        ((MixedScheme)this.evolver).setStep(dt);
        int i = 0;
        while (i < steps) {
            double now = t;
            double next = t - dt;
            boolean hit = false;
            for (int j = this.stoppingTimes.size() - 1; j >= 0; --j) {
                if (!(next <= this.stoppingTimes.get(j)) || !(this.stoppingTimes.get(j) < now)) continue;
                hit = true;
                ((MixedScheme)this.evolver).setStep(now - this.stoppingTimes.get(j));
                a = ((MixedScheme)this.evolver).step(a, now);
                if (condition != null) {
                    condition.applyTo(a, this.stoppingTimes.get(j));
                }
                now = this.stoppingTimes.get(j);
            }
            if (hit) {
                if (now > next) {
                    ((MixedScheme)this.evolver).setStep(now - next);
                    a = ((MixedScheme)this.evolver).step(a, now);
                    if (condition != null) {
                        condition.applyTo(a, next);
                    }
                }
                ((MixedScheme)this.evolver).setStep(dt);
            } else {
                a = ((MixedScheme)this.evolver).step(a, now);
                if (condition != null) {
                    condition.applyTo(a, next);
                }
            }
            ++i;
            t -= dt;
        }
        return a;
    }

    protected T getEvolver(S l, List<BoundaryCondition<S>> bcs) {
        try {
            return (T)this.classT.getConstructor(Operator.class, List.class).newInstance(l, bcs);
        }
        catch (Exception e) {
            throw new LibraryException(e);
        }
    }
}

