/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.methods.finitedifferences;

import org.jquantlib.math.matrixutilities.Array;
import org.jquantlib.methods.finitedifferences.BoundaryCondition;
import org.jquantlib.methods.finitedifferences.TridiagonalOperator;

public class DirichletBC
implements BoundaryCondition<TridiagonalOperator> {
    private final double value;
    private final BoundaryCondition.Side side;

    public DirichletBC(double value, BoundaryCondition.Side side) {
        this.value = value;
        this.side = side;
    }

    @Override
    public void applyAfterApplying(Array u) {
        switch (this.side) {
            case Lower: {
                u.set(0, this.value);
                break;
            }
            case Upper: {
                u.set(u.size() - 1, this.value);
                break;
            }
            default: {
                throw new IllegalStateException("unknown side for Neumann boundary condition");
            }
        }
    }

    @Override
    public void applyAfterSolving(Array array) {
    }

    @Override
    public void applyBeforeApplying(TridiagonalOperator operator) {
        switch (this.side) {
            case Lower: {
                operator.setFirstRow(1.0, 0.0);
                break;
            }
            case Upper: {
                operator.setLastRow(0.0, 1.0);
                break;
            }
            default: {
                throw new IllegalStateException("unknown side for Neumann boundary condition");
            }
        }
    }

    @Override
    public void applyBeforeSolving(TridiagonalOperator operator, Array rhs) {
        switch (this.side) {
            case Lower: {
                operator.setFirstRow(1.0, 0.0);
                rhs.set(0, this.value);
                break;
            }
            case Upper: {
                operator.setLastRow(0.0, 1.0);
                rhs.set(rhs.size() - 1, this.value);
                break;
            }
            default: {
                throw new IllegalStateException("unknown side for Neumann boundary condition");
            }
        }
    }

    @Override
    public void setTime(double t) {
    }
}

