/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.math.statistics;

import org.jquantlib.QL;
import org.jquantlib.lang.annotation.QualityAssurance;
import org.jquantlib.math.matrixutilities.Array;
import org.jquantlib.math.matrixutilities.Matrix;
import org.jquantlib.math.statistics.Statistics;

@QualityAssurance(quality=QualityAssurance.Quality.Q4_UNIT, reviewers={"Richard Gomes"}, version=QualityAssurance.Version.V097)
public class GenericSequenceStatistics {
    private static final String UNSUFFICIENT_SAMPLE_WEIGHT = "sampleWeight=0, unsufficient";
    private static final String UNSUFFICIENT_SAMPLE_NUMBER = "sample number <=1, unsufficient";
    private static final String NULL_DIMENSION = "sample error: null dimension";
    private static final String SAMPLE_SIZE_MISMATCH = "sample size mismatch";
    protected int dimension_ = 0;
    protected Statistics[] stats;
    protected Matrix quadraticSum;
    private double[] results;

    public GenericSequenceStatistics() {
        this(0);
    }

    public GenericSequenceStatistics(int dimension) {
        this.reset(dimension);
    }

    public int size() {
        return this.dimension_;
    }

    public Matrix covariance() {
        double sampleWeight = this.weightSum();
        QL.require(sampleWeight > 0.0, UNSUFFICIENT_SAMPLE_WEIGHT);
        double sampleNumber = this.samples();
        QL.require(sampleNumber > 1.0, UNSUFFICIENT_SAMPLE_NUMBER);
        Array m = this.mean();
        double inv = 1.0 / sampleWeight;
        Matrix result = this.quadraticSum.mul(inv);
        result.subAssign(m.outerProduct(m));
        result.mulAssign(sampleNumber / (sampleNumber - 1.0));
        return result;
    }

    public Matrix correlation() {
        Matrix corr = this.covariance();
        Array v = corr.diagonal();
        for (int i = 0; i < this.dimension_; ++i) {
            for (int j = 0; j < this.dimension_; ++j) {
                if (i == j) {
                    if (v.$[v._(i)] == 0.0) {
                        corr.$[corr._((int)i, (int)j)] = 1.0;
                        continue;
                    }
                    int n = corr._(i, j);
                    corr.$[n] = corr.$[n] * (1.0 / Math.sqrt(v.$[v._(i)] * v.$[v._(j)]));
                    continue;
                }
                if (v.$[v._(i)] == 0.0 && v.$[v._(j)] == 0.0) {
                    corr.$[corr._((int)i, (int)j)] = 1.0;
                    continue;
                }
                if (v.$[v._(i)] == 0.0 || v.$[v._(j)] == 0.0) {
                    corr.$[corr._((int)i, (int)j)] = 0.0;
                    continue;
                }
                int n = corr._(i, j);
                corr.$[n] = corr.$[n] * (1.0 / Math.sqrt(v.$[v._(i)] * v.$[v._(j)]));
            }
        }
        return corr;
    }

    public int samples() {
        return this.stats.length == 0 ? 0 : this.stats[0].samples();
    }

    public double weightSum() {
        return this.stats.length == 0 ? 0.0 : this.stats[0].weightSum();
    }

    public Array mean() {
        for (int i = 0; i < this.dimension_; ++i) {
            this.results[i] = this.stats[i].mean();
        }
        return new Array(this.results);
    }

    public Array variance() {
        for (int i = 0; i < this.dimension_; ++i) {
            this.results[i] = this.stats[i].variance();
        }
        return new Array(this.results);
    }

    public Array standardDeviation() {
        for (int i = 0; i < this.dimension_; ++i) {
            this.results[i] = this.stats[i].standardDeviation();
        }
        return new Array(this.results);
    }

    public Array downsideVariance() {
        for (int i = 0; i < this.dimension_; ++i) {
            this.results[i] = this.stats[i].downsideVariance();
        }
        return new Array(this.results);
    }

    public Array downsideDeviation() {
        for (int i = 0; i < this.dimension_; ++i) {
            this.results[i] = this.stats[i].downsideDeviation();
        }
        return new Array(this.results);
    }

    public Array semiVariance() {
        for (int i = 0; i < this.dimension_; ++i) {
            this.results[i] = this.stats[i].semiVariance();
        }
        return new Array(this.results);
    }

    public Array semiDeviation() {
        for (int i = 0; i < this.dimension_; ++i) {
            this.results[i] = this.stats[i].semiDeviation();
        }
        return new Array(this.results);
    }

    public Array errorEstimate() {
        for (int i = 0; i < this.dimension_; ++i) {
            this.results[i] = this.stats[i].errorEstimate();
        }
        return new Array(this.results);
    }

    public Array skewness() {
        for (int i = 0; i < this.dimension_; ++i) {
            this.results[i] = this.stats[i].skewness();
        }
        return new Array(this.results);
    }

    public Array kurtosis() {
        for (int i = 0; i < this.dimension_; ++i) {
            this.results[i] = this.stats[i].kurtosis();
        }
        return new Array(this.results);
    }

    public Array min() {
        for (int i = 0; i < this.dimension_; ++i) {
            this.results[i] = this.stats[i].min();
        }
        return new Array(this.results);
    }

    public Array max() {
        for (int i = 0; i < this.dimension_; ++i) {
            this.results[i] = this.stats[i].max();
        }
        return new Array(this.results);
    }

    public Array gaussianPercentile(double y) {
        for (int i = 0; i < this.dimension_; ++i) {
            this.results[i] = this.stats[i].gaussianPercentile(y);
        }
        return new Array(this.results);
    }

    public Array gaussianPotentialUpside(double percentile) {
        for (int i = 0; i < this.dimension_; ++i) {
            this.results[i] = this.stats[i].gaussianPotentialUpside(percentile);
        }
        return new Array(this.results);
    }

    public Array gaussianValueAtRisk(double percentile) {
        for (int i = 0; i < this.dimension_; ++i) {
            this.results[i] = this.stats[i].gaussianValueAtRisk(percentile);
        }
        return new Array(this.results);
    }

    public Array gaussianExpectedShortfall(double percentile) {
        for (int i = 0; i < this.dimension_; ++i) {
            this.results[i] = this.stats[i].gaussianExpectedShortfall(percentile);
        }
        return new Array(this.results);
    }

    public Array gaussianShortfall(double target) {
        for (int i = 0; i < this.dimension_; ++i) {
            this.results[i] = this.stats[i].gaussianShortfall(target);
        }
        return new Array(this.results);
    }

    public Array gaussianAverageShortfall(double target) {
        for (int i = 0; i < this.dimension_; ++i) {
            this.results[i] = this.stats[i].gaussianAverageShortfall(target);
        }
        return new Array(this.results);
    }

    public Array percentile(double y) {
        for (int i = 0; i < this.dimension_; ++i) {
            this.results[i] = this.stats[i].percentile(y);
        }
        return new Array(this.results);
    }

    public Array potentialUpside(double percentile) {
        for (int i = 0; i < this.dimension_; ++i) {
            this.results[i] = this.stats[i].potentialUpside(percentile);
        }
        return new Array(this.results);
    }

    public Array valueAtRisk(double percentile) {
        for (int i = 0; i < this.dimension_; ++i) {
            this.results[i] = this.stats[i].valueAtRisk(percentile);
        }
        return new Array(this.results);
    }

    public Array expectedShortfall(double percentile) {
        for (int i = 0; i < this.dimension_; ++i) {
            this.results[i] = this.stats[i].expectedShortfall(percentile);
        }
        return new Array(this.results);
    }

    public Array regret(double target) {
        for (int i = 0; i < this.dimension_; ++i) {
            this.results[i] = this.stats[i].regret(target);
        }
        return new Array(this.results);
    }

    public Array shortfall(double target) {
        for (int i = 0; i < this.dimension_; ++i) {
            this.results[i] = this.stats[i].shortfall(target);
        }
        return new Array(this.results);
    }

    public Array averageShortfall(double target) {
        for (int i = 0; i < this.dimension_; ++i) {
            this.results[i] = this.stats[i].averageShortfall(target);
        }
        return new Array(this.results);
    }

    public void reset() {
        this.reset(0);
    }

    public void reset(int dimension) {
        if (dimension > 0) {
            if (dimension == this.dimension_) {
                for (int i = 0; i < this.dimension_; ++i) {
                    this.stats[i].reset();
                }
            } else {
                this.dimension_ = dimension;
                this.stats = new Statistics[dimension];
                for (int i = 0; i < dimension; ++i) {
                    this.stats[i] = new Statistics();
                }
                this.results = new double[dimension];
            }
            this.quadraticSum = new Matrix(this.dimension_, this.dimension_);
        } else {
            this.dimension_ = dimension;
        }
    }

    public void add(double[] datum) {
        this.add(datum, 1.0);
    }

    public void add(double[] datum, double weight) {
        if (this.dimension_ == 0) {
            int dimension = datum.length;
            QL.require(dimension > 0, NULL_DIMENSION);
            this.reset(dimension);
        }
        QL.require(datum.length == this.dimension_, SAMPLE_SIZE_MISMATCH);
        Array array = new Array(datum);
        this.quadraticSum.addAssign(array.outerProduct(array).mulAssign(weight));
        for (int i = 0; i < this.dimension_; ++i) {
            this.stats[i].add(datum[i], weight);
        }
    }

    public void add(Array datum) {
        this.add(datum, 1.0);
    }

    public void add(Array datum, double weight) {
        if (this.dimension_ == 0) {
            int dimension = datum.size();
            QL.require(dimension > 0, NULL_DIMENSION);
            this.reset(dimension);
        }
        QL.require(datum.size() == this.dimension_, SAMPLE_SIZE_MISMATCH);
        this.quadraticSum.addAssign(datum.outerProduct(datum).mulAssign(weight));
        for (int i = 0; i < this.dimension_; ++i) {
            this.stats[i].add(datum.$[datum._(i)], weight);
        }
    }
}

