/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.math.statistics;

import org.jquantlib.QL;
import org.jquantlib.lang.annotation.QualityAssurance;
import org.jquantlib.math.matrixutilities.Array;
import org.jquantlib.math.statistics.SequenceStatistics;

@QualityAssurance(quality=QualityAssurance.Quality.Q4_UNIT, reviewers={"Richard Gomes"}, version=QualityAssurance.Version.V097)
public class DiscrepancyStatistics
extends SequenceStatistics {
    private static final String DIMENSION_NOT_ALLOWED = "dimension==1 not allowed";
    private double bdiscr_;
    private double ddiscr_;
    private double adiscr_;
    private double cdiscr_;

    public DiscrepancyStatistics(int dimension) {
        super(dimension);
        this.reset(dimension);
    }

    public double discrepancy() {
        int N = this.samples();
        return Math.sqrt(this.adiscr_ / (double)(N * N) - this.bdiscr_ / (double)N * this.cdiscr_ + this.ddiscr_);
    }

    @Override
    public void add(double[] datum) {
        this.add(datum, 1.0);
    }

    @Override
    public void add(Array datum) {
        this.add(datum, 1.0);
    }

    @Override
    public void add(double[] datum, double weight) {
        double r_jk;
        double r_ik;
        int k;
        super.add(datum, weight);
        int N = this.samples();
        double temp = 1.0;
        for (k = 0; k < this.dimension_; ++k) {
            r_ik = datum[k];
            temp *= 1.0 - r_ik * r_ik;
        }
        this.cdiscr_ += temp;
        for (int m = 0; m < N - 1; ++m) {
            temp = 1.0;
            for (k = 0; k < this.dimension_; ++k) {
                r_ik = this.stats[k].data().get(m).first();
                r_jk = datum[k];
                temp *= 1.0 - Math.max(r_ik, r_jk);
            }
            this.adiscr_ += temp;
            temp = 1.0;
            for (k = 0; k < this.dimension_; ++k) {
                r_ik = datum[k];
                r_jk = this.stats[k].data().get(m).first();
                temp *= 1.0 - Math.max(r_ik, r_jk);
            }
            this.adiscr_ += temp;
        }
        temp = 1.0;
        for (k = 0; k < this.dimension_; ++k) {
            r_ik = r_jk = datum[k];
            temp *= 1.0 - Math.max(r_ik, r_jk);
        }
        this.adiscr_ += temp;
    }

    @Override
    public void add(Array datum, double weight) {
        double r_jk;
        double r_ik;
        int k;
        super.add(datum, weight);
        int N = this.samples();
        double temp = 1.0;
        for (k = 0; k < this.dimension_; ++k) {
            r_ik = datum.$[datum._(k)];
            temp *= 1.0 - r_ik * r_ik;
        }
        this.cdiscr_ += temp;
        for (int m = 0; m < N - 1; ++m) {
            temp = 1.0;
            for (k = 0; k < this.dimension_; ++k) {
                r_ik = this.stats[k].data().get(m).first();
                r_jk = datum.$[datum._(k)];
                temp *= 1.0 - Math.max(r_ik, r_jk);
            }
            this.adiscr_ += temp;
            temp = 1.0;
            for (k = 0; k < this.dimension_; ++k) {
                r_ik = datum.$[datum._(k)];
                r_jk = this.stats[k].data().get(m).first();
                temp *= 1.0 - Math.max(r_ik, r_jk);
            }
            this.adiscr_ += temp;
        }
        temp = 1.0;
        for (k = 0; k < this.dimension_; ++k) {
            r_ik = r_jk = datum.$[datum._(k)];
            temp *= 1.0 - Math.max(r_ik, r_jk);
        }
        this.adiscr_ += temp;
    }

    @Override
    public void reset() {
        this.reset(0);
    }

    @Override
    public void reset(int dimension) {
        if (dimension == 0) {
            dimension = this.dimension_;
        }
        QL.require(dimension != 1, DIMENSION_NOT_ALLOWED);
        super.reset(dimension);
        this.adiscr_ = 0.0;
        this.bdiscr_ = 1.0 / Math.pow(2.0, dimension - 1);
        this.cdiscr_ = 0.0;
        this.ddiscr_ = 1.0 / Math.pow(3.0, dimension);
    }
}

