/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.math.solvers1D;

import org.jquantlib.lang.exceptions.LibraryException;
import org.jquantlib.math.AbstractSolver1D;
import org.jquantlib.math.Ops;

public class Ridder
extends AbstractSolver1D<Ops.DoubleOp> {
    @Override
    protected double solveImpl(Ops.DoubleOp f, double xAccuracy) {
        double xAccuracy_ = xAccuracy / 100.0;
        this.root = Double.MIN_VALUE;
        while (this.evaluationNumber <= this.getMaxEvaluations()) {
            double xMid = 0.5 * (this.xMin + this.xMax);
            double fxMid = f.op(xMid);
            ++this.evaluationNumber;
            double s = Math.sqrt(fxMid * fxMid - this.fxMin * this.fxMax);
            if (s == 0.0) {
                return this.root;
            }
            double nextRoot = xMid + (xMid - this.xMin) * ((this.fxMin >= this.fxMax ? 1.0 : -1.0) * fxMid / s);
            if (Math.abs(nextRoot - this.root) <= xAccuracy_) {
                return this.root;
            }
            this.root = nextRoot;
            double froot = f.op(this.root);
            ++this.evaluationNumber;
            if (froot == 0.0) {
                return this.root;
            }
            if (this.sign(fxMid, froot) != fxMid) {
                this.xMin = xMid;
                this.fxMin = fxMid;
                this.xMax = this.root;
                this.fxMax = froot;
            } else if (this.sign(this.fxMin, froot) != this.fxMin) {
                this.xMax = this.root;
                this.fxMax = froot;
            } else if (this.sign(this.fxMax, froot) != this.fxMax) {
                this.xMin = this.root;
                this.fxMin = froot;
            } else {
                throw new LibraryException("internal error");
            }
            if (!(Math.abs(this.xMax - this.xMin) <= xAccuracy_)) continue;
            return this.root;
        }
        throw new ArithmeticException("maximum number of function evaluations exceeded");
    }

    private double sign(double a, double b) {
        return b >= 0.0 ? Math.abs(a) : -Math.abs(a);
    }
}

