/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.math.solvers1D;

import org.jquantlib.math.AbstractSolver1D;
import org.jquantlib.math.Closeness;
import org.jquantlib.math.Constants;
import org.jquantlib.math.Ops;

public class Brent
extends AbstractSolver1D<Ops.DoubleOp> {
    @Override
    protected double solveImpl(Ops.DoubleOp f, double xAccuracy) {
        double d = 0.0;
        double e = 0.0;
        this.root = this.xMax;
        double froot = this.fxMax;
        while (this.evaluationNumber <= this.getMaxEvaluations()) {
            if (froot > 0.0 && this.fxMax > 0.0 || froot < 0.0 && this.fxMax < 0.0) {
                this.xMax = this.xMin;
                this.fxMax = this.fxMin;
                e = d = this.root - this.xMin;
            }
            if (Math.abs(this.fxMax) < Math.abs(froot)) {
                this.xMin = this.root;
                this.root = this.xMax;
                this.xMax = this.xMin;
                this.fxMin = froot;
                froot = this.fxMax;
                this.fxMax = this.fxMin;
            }
            double xAcc1 = 2.0 * Constants.QL_EPSILON * Math.abs(this.root) + 0.5 * xAccuracy;
            double xMid = (this.xMax - this.root) / 2.0;
            if (Math.abs(xMid) <= xAcc1 || froot == 0.0) {
                return this.root;
            }
            if (Math.abs(e) >= xAcc1 && Math.abs(this.fxMin) > Math.abs(froot)) {
                double min2;
                double q;
                double p;
                double s = froot / this.fxMin;
                if (Closeness.isClose(this.xMin, this.xMax)) {
                    p = 2.0 * xMid * s;
                    q = 1.0 - s;
                } else {
                    q = this.fxMin / this.fxMax;
                    double r = froot / this.fxMax;
                    p = s * (2.0 * xMid * q * (q - r) - (this.root - this.xMin) * (r - 1.0));
                    q = (q - 1.0) * (r - 1.0) * (s - 1.0);
                }
                if (p > 0.0) {
                    q = -q;
                }
                p = Math.abs(p);
                double min1 = 3.0 * xMid * q - Math.abs(xAcc1 * q);
                double d2 = min1 < (min2 = Math.abs(e * q)) ? min1 : min2;
                if (2.0 * p < d2) {
                    e = d;
                    d = p / q;
                } else {
                    e = d = xMid;
                }
            } else {
                e = d = xMid;
            }
            this.xMin = this.root;
            this.fxMin = froot;
            this.root = Math.abs(d) > xAcc1 ? (this.root += d) : (this.root += this.sign(xAcc1, xMid));
            froot = f.op(this.root);
            ++this.evaluationNumber;
        }
        throw new ArithmeticException("maximum number of function evaluations exceeded");
    }

    private double sign(double a, double b) {
        return b >= 0.0 ? Math.abs(a) : -Math.abs(a);
    }
}

