/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.math.optimization;

import org.jquantlib.math.matrixutilities.Array;
import org.jquantlib.math.optimization.CostFunction;

public class ProjectedCostFunction
extends CostFunction {
    private int numberOfFreeParameters;
    private final Array fixedParameters;
    private final Array actualParameters;
    private final boolean[] parametersFreedoms_;
    private final CostFunction costFunction;

    public ProjectedCostFunction(CostFunction costFunction, Array parameterValues, boolean[] parametersFreedoms) {
        if (System.getProperty("EXPERIMENTAL") == null) {
            throw new UnsupportedOperationException("Work in progress");
        }
        this.numberOfFreeParameters = 0;
        this.fixedParameters = parameterValues.clone();
        this.actualParameters = parameterValues.clone();
        this.parametersFreedoms_ = parametersFreedoms;
        this.costFunction = costFunction;
        if (this.fixedParameters.size() != this.parametersFreedoms_.length) {
            throw new IllegalArgumentException("fixedParameters_.size()!=parametersFreedoms_.size()");
        }
        for (int i = 0; i < this.parametersFreedoms_.length; ++i) {
            if (!this.parametersFreedoms_[i]) {
                ++this.numberOfFreeParameters;
            }
            if (this.numberOfFreeParameters > 0) continue;
            throw new ArithmeticException("numberOfFreeParameters==0");
        }
    }

    public void mapFreeParameters(Array parametersValues) {
        if (parametersValues.size() != this.numberOfFreeParameters) {
            throw new IllegalArgumentException("parametersValues.size()!=numberOfFreeParameters");
        }
        int i = 0;
        for (int j = 0; j < this.actualParameters.size(); ++j) {
            if (this.parametersFreedoms_[j]) continue;
            this.actualParameters.set(j, parametersValues.get(i++));
        }
    }

    @Override
    public double value(Array freeParameters) {
        this.mapFreeParameters(freeParameters);
        return this.costFunction.value(this.actualParameters);
    }

    @Override
    public Array values(Array freeParameters) {
        this.mapFreeParameters(freeParameters);
        return this.costFunction.values(this.actualParameters);
    }

    public Array project(Array parameters) {
        if (parameters.size() != this.parametersFreedoms_.length) {
            throw new ArithmeticException("parameters.size()!=parametersFreedoms_.size()");
        }
        Array projectedParameters = new Array(this.numberOfFreeParameters);
        int i = 0;
        for (int j = 0; j < this.parametersFreedoms_.length; ++j) {
            if (this.parametersFreedoms_[j]) continue;
            projectedParameters.set(i++, parameters.get(j));
        }
        return projectedParameters;
    }

    public Array include(Array projectedParameters) {
        if (projectedParameters.size() != this.numberOfFreeParameters) {
            throw new IllegalArgumentException("projectedParameters.size()!=numberOfFreeParameters");
        }
        Array y = this.fixedParameters.clone();
        int i = 0;
        for (int j = 0; j < y.size(); ++j) {
            if (this.parametersFreedoms_[j]) continue;
            y.set(j, projectedParameters.get(i++));
        }
        return y;
    }
}

