/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.math.optimization;

import org.jquantlib.math.matrixutilities.Array;
import org.jquantlib.math.matrixutilities.Matrix;

public class Minpack {
    public static void qrfac(int m, int n, Matrix a, boolean pivot, int[] ipvt, Array rdiag, Array acnorm, Array wa) {
        MinpackC.qrfac(m, n, a.$, pivot ? 1 : 0, ipvt, rdiag.$, acnorm.$, wa.$);
    }

    private static class MinpackC {
        private static final double MACHEP = 1.2E-16;
        private static final double DWARF = 1.0E-38;
        private static final double rdwarf = 3.834E-20;
        private static final double rgiant = 1.304E19;
        private static final double zero = 0.0;
        private static final double one = 1.0;
        private static final double p5 = 0.5;
        private static final double p05 = 0.05;
        private static final double p25 = 0.25;

        private MinpackC() {
        }

        private static double enorm(int n, double[] x, int offset) {
            double ans;
            double temp;
            double s1 = 0.0;
            double s2 = 0.0;
            double s3 = 0.0;
            double x1max = 0.0;
            double x3max = 0.0;
            double floatn = n;
            double agiant = 1.304E19 / floatn;
            for (int i = 0; i < n; ++i) {
                double xabs = Math.abs(x[offset + i]);
                if (xabs > 3.834E-20 && xabs < agiant) {
                    s2 += xabs * xabs;
                    continue;
                }
                if (xabs > 3.834E-20) {
                    if (xabs > x1max) {
                        temp = x1max / xabs;
                        s1 = 1.0 + s1 * temp * temp;
                        x1max = xabs;
                        continue;
                    }
                    temp = xabs / x1max;
                    s1 += temp * temp;
                    continue;
                }
                if (xabs > x3max) {
                    temp = x3max / xabs;
                    s3 = 1.0 + s3 * temp * temp;
                    x3max = xabs;
                    continue;
                }
                if (xabs == 0.0) continue;
                temp = xabs / x3max;
                s3 += temp * temp;
            }
            if (s1 != 0.0) {
                temp = s1 + s2 / x1max / x1max;
                double ans2 = x1max * Math.sqrt(temp);
                return ans2;
            }
            if (s2 != 0.0) {
                temp = s2 >= x3max ? s2 * (1.0 + x3max / s2 * (x3max * s3)) : x3max * (s2 / x3max + x3max * s3);
                ans = Math.sqrt(temp);
            } else {
                ans = x3max * Math.sqrt(s3);
            }
            return ans;
        }

        public static void qrfac(int m, int n, double[] a, int pivot, int[] ipvt, double[] rdiag, double[] acnorm, double[] wa) {
            int j;
            int ij = 0;
            for (j = 0; j < n; ++j) {
                acnorm[j] = MinpackC.enorm(m, a, ij);
                rdiag[j] = acnorm[j];
                wa[j] = rdiag[j];
                if (pivot != 0) {
                    ipvt[j] = j;
                }
                ij += m;
            }
            int minmn = MinpackC.min0(m, n);
            for (j = 0; j < minmn; ++j) {
                double ajnorm;
                double temp;
                int i;
                int jj;
                int k;
                if (pivot != 0) {
                    int kmax = j;
                    for (k = j; k < n; ++k) {
                        if (!(rdiag[k] > rdiag[kmax])) continue;
                        kmax = k;
                    }
                    if (kmax != j) {
                        ij = m * j;
                        jj = m * kmax;
                        for (i = 0; i < m; ++i) {
                            temp = a[ij];
                            a[ij] = a[jj];
                            a[jj] = temp;
                            ++ij;
                            ++jj;
                        }
                        rdiag[kmax] = rdiag[j];
                        wa[kmax] = wa[j];
                        k = ipvt[j];
                        ipvt[j] = ipvt[kmax];
                        ipvt[kmax] = k;
                    }
                }
                if ((ajnorm = MinpackC.enorm(m - j, a, jj = j + m * j)) != 0.0) {
                    if (a[jj] < 0.0) {
                        ajnorm = -ajnorm;
                    }
                    ij = jj;
                    for (i = j; i < m; ++i) {
                        int n2 = ij++;
                        a[n2] = a[n2] / ajnorm;
                    }
                    int n3 = jj;
                    a[n3] = a[n3] + 1.0;
                    int jp1 = j + 1;
                    if (jp1 < n) {
                        for (k = jp1; k < n; ++k) {
                            double sum = 0.0;
                            ij = j + m * k;
                            jj = j + m * j;
                            for (i = j; i < m; ++i) {
                                sum += a[jj] * a[ij];
                                ++ij;
                                ++jj;
                            }
                            temp = sum / a[j + m * j];
                            ij = j + m * k;
                            jj = j + m * j;
                            for (i = j; i < m; ++i) {
                                int n4 = ij++;
                                a[n4] = a[n4] - temp * a[jj];
                                ++jj;
                            }
                            if (pivot == 0 || rdiag[k] == 0.0) continue;
                            temp = a[j + m * k] / rdiag[k];
                            temp = MinpackC.dmax1(0.0, 1.0 - temp * temp);
                            int n5 = k;
                            rdiag[n5] = rdiag[n5] * Math.sqrt(temp);
                            temp = rdiag[k] / wa[k];
                            if (!(0.05 * temp * temp <= 1.2E-16)) continue;
                            rdiag[k] = MinpackC.enorm(m - j - 1, a, jp1 + m * k);
                            wa[k] = rdiag[k];
                        }
                    }
                }
                rdiag[j] = -ajnorm;
            }
        }

        public static void qrsolv(int n, double[] r, int ldr, int[] ipvt, double[] diag, double[] qtb, double[] x, double[] sdiag, double[] wa) {
            int k;
            int l;
            int i;
            int ik;
            int ij;
            int j;
            int kk = 0;
            for (j = 0; j < n; ++j) {
                ij = kk;
                ik = kk;
                for (i = j; i < n; ++i) {
                    r[ij] = r[ik];
                    ++ij;
                    ik += ldr;
                }
                x[j] = r[kk];
                wa[j] = qtb[j];
                kk += ldr + 1;
            }
            for (j = 0; j < n; ++j) {
                l = ipvt[j];
                if (diag[l] != 0.0) {
                    for (k = j; k < n; ++k) {
                        sdiag[k] = 0.0;
                    }
                    sdiag[j] = diag[l];
                    double qtbpj = 0.0;
                    for (k = j; k < n; ++k) {
                        double cos;
                        double sin;
                        if (sdiag[k] == 0.0) continue;
                        kk = k + ldr * k;
                        if (Math.abs(r[kk]) < Math.abs(sdiag[k])) {
                            double cotan = r[kk] / sdiag[k];
                            sin = 0.5 / Math.sqrt(0.25 + 0.25 * cotan * cotan);
                            cos = sin * cotan;
                        } else {
                            double tan = sdiag[k] / r[kk];
                            cos = 0.5 / Math.sqrt(0.25 + 0.25 * tan * tan);
                            sin = cos * tan;
                        }
                        r[kk] = cos * r[kk] + sin * sdiag[k];
                        double temp = cos * wa[k] + sin * qtbpj;
                        qtbpj = -sin * wa[k] + cos * qtbpj;
                        wa[k] = temp;
                        int kp1 = k + 1;
                        if (n <= kp1) continue;
                        ik = kk + 1;
                        for (i = kp1; i < n; ++i) {
                            temp = cos * r[ik] + sin * sdiag[i];
                            sdiag[i] = -sin * r[ik] + cos * sdiag[i];
                            r[ik] = temp;
                            ++ik;
                        }
                    }
                }
                kk = j + ldr * j;
                sdiag[j] = r[kk];
                r[kk] = x[j];
            }
            int nsing = n;
            for (j = 0; j < n; ++j) {
                if (sdiag[j] == 0.0 && nsing == n) {
                    nsing = j;
                }
                if (nsing >= n) continue;
                wa[j] = 0.0;
            }
            if (nsing >= 1) {
                for (k = 0; k < nsing; ++k) {
                    j = nsing - k - 1;
                    double sum = 0.0;
                    int jp1 = j + 1;
                    if (nsing > jp1) {
                        ij = jp1 + ldr * j;
                        for (i = jp1; i < nsing; ++i) {
                            sum += r[ij] * wa[i];
                            ++ij;
                        }
                    }
                    wa[j] = (wa[j] - sum) / sdiag[j];
                }
            }
            for (j = 0; j < n; ++j) {
                l = ipvt[j];
                x[l] = wa[j];
            }
        }

        private static double dmax1(double a, double b) {
            if (a >= b) {
                return a;
            }
            return b;
        }

        private double dmin1(double a, double b) {
            if (a <= b) {
                return a;
            }
            return b;
        }

        private static int min0(int a, int b) {
            if (a <= b) {
                return a;
            }
            return b;
        }

        private int mod(int k, int m) {
            return k % m;
        }
    }
}

