/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.math.optimization;

import org.jquantlib.math.matrixutilities.Array;
import org.jquantlib.math.optimization.Constraint;
import org.jquantlib.math.optimization.EndCriteria;
import org.jquantlib.math.optimization.Problem;

public class LineSearch {
    private static final String CANNOT_UPDATE_LINESEARCH = "cannot update linesearch";
    protected Array searchDirection_;
    protected Array xtd_;
    protected Array gradient_;
    protected double qt_;
    protected double qpt_;
    protected boolean succeed_;

    public LineSearch() {
        this(0.0);
    }

    public LineSearch(double init) {
        this.qt_ = init;
        this.qpt_ = init;
        this.succeed_ = true;
        if (System.getProperty("EXPERIMENTAL") == null) {
            throw new UnsupportedOperationException("Work in progress");
        }
    }

    public Array lastX() {
        return this.xtd_;
    }

    public double lastFunctionValue() {
        return this.qt_;
    }

    public Array lastGradient() {
        return this.gradient_;
    }

    public double lastGradientNormNorm2() {
        return this.qpt_;
    }

    public Array searchDirection() {
        return this.searchDirection_;
    }

    public double evaluate(Problem P, EndCriteria.Type ecType, EndCriteria endCriteria, double t_ini) {
        throw new UnsupportedOperationException("Work in progress");
    }

    public double update(Array params, Array direction, double beta, Constraint constraint) {
        double diff = beta;
        Array newParams = params.add(direction.mul(diff));
        boolean valid = constraint.test(newParams);
        int icount = 0;
        while (!valid) {
            if (icount > 200) {
                throw new ArithmeticException("can't update lineSearch");
            }
            ++icount;
            newParams = params.add(direction.mul(diff *= 0.5));
            valid = constraint.test(newParams);
        }
        params.add(direction.mul(diff));
        return diff;
    }

    public void setSearchDirection(Array searchDirection) {
        this.searchDirection_ = searchDirection;
    }
}

