/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.math.optimization;

import org.jquantlib.lang.annotation.QualityAssurance;
import org.jquantlib.math.matrixutilities.Array;

@QualityAssurance(quality=QualityAssurance.Quality.Q3_DOCUMENTATION, version=QualityAssurance.Version.V097, reviewers={"Richard Gomes"})
public abstract class CostFunction {
    public void gradient(Array grad, Array x) {
        double eps = this.finiteDifferenceEpsilon();
        Array xx = x.clone();
        for (int i = 0; i < x.size(); ++i) {
            xx.set(i, eps + xx.get(i));
            double fp = this.value(xx);
            xx.set(i, xx.get(i) - 2.0 * eps);
            double fm = this.value(xx);
            grad.set(i, 0.5 * (fp - fm) / eps);
            xx.set(i, x.get(i));
        }
    }

    public double valueAndGradient(Array grad, Array x) {
        this.gradient(grad, x);
        return this.value(x);
    }

    public double finiteDifferenceEpsilon() {
        return 1.0E-8;
    }

    public abstract double value(Array var1);

    public abstract Array values(Array var1);
}

